/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.border;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.border.Border;
import org.jdesktop.swingx.icon.EmptyIcon;

public class IconBorder
implements Border,
Serializable {
    public static final Icon EMPTY_ICON = new EmptyIcon();
    private int padding;
    private Icon icon;
    private int iconPosition;
    private Rectangle iconBounds = new Rectangle();

    public IconBorder(Icon icon, int n2, int n3) {
        this.setIcon(icon);
        this.setPadding(n3);
        this.setIconPosition(n2);
    }

    private boolean isValidPosition(int n2) {
        boolean bl = false;
        switch (n2) {
            case 3: 
            case 7: 
            case 10: 
            case 11: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public Insets getBorderInsets(Component component) {
        int n2 = this.icon.getIconWidth() + 2 * this.padding;
        int n3 = this.bidiDecodeLeadingTrailing(component.getComponentOrientation(), this.iconPosition);
        if (n3 == 3) {
            return new Insets(0, 0, 0, n2);
        }
        return new Insets(0, n2, 0, 0);
    }

    public void setIcon(Icon icon) {
        this.icon = icon == null ? EMPTY_ICON : icon;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6 = this.bidiDecodeLeadingTrailing(component.getComponentOrientation(), this.iconPosition);
        if (n6 == 2) {
            this.iconBounds.y = n3 + this.padding;
            this.iconBounds.x = n2 + n4 - this.padding - this.icon.getIconWidth();
        } else if (n6 == 3) {
            this.iconBounds.y = n3 + (n5 - this.icon.getIconHeight()) / 2;
            this.iconBounds.x = n2 + n4 - this.padding - this.icon.getIconWidth();
        } else if (n6 == 7) {
            this.iconBounds.y = n3 + (n5 - this.icon.getIconHeight()) / 2;
            this.iconBounds.x = n2 + this.padding;
        }
        this.iconBounds.width = this.icon.getIconWidth();
        this.iconBounds.height = this.icon.getIconHeight();
        this.icon.paintIcon(component, graphics, this.iconBounds.x, this.iconBounds.y);
    }

    private int bidiDecodeLeadingTrailing(ComponentOrientation componentOrientation, int n2) {
        if (n2 == 11) {
            if (!componentOrientation.isLeftToRight()) {
                return 7;
            }
            return 3;
        }
        if (n2 == 10) {
            if (componentOrientation.isLeftToRight()) {
                return 7;
            }
            return 3;
        }
        return n2;
    }

    public void setPadding(int n2) {
        this.padding = n2 < 0 ? 0 : n2;
    }

    public void setIconPosition(int n2) {
        if (!this.isValidPosition(n2)) {
            throw new IllegalArgumentException("Invalid icon position");
        }
        this.iconPosition = n2;
    }
}

