/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.EventHandler;
import java.beans.Statement;
import java.util.EventListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import org.jdesktop.swingx.action.AbstractActionExt;

public class BoundAction
extends AbstractActionExt {
    private static final Logger LOG = Logger.getLogger(BoundAction.class.getName());
    private EventListenerList listeners;

    public BoundAction(String string, String string2) {
        super(string, string2);
    }

    public void registerCallback(Object object, String string) {
        if (this.isStateAction()) {
            this.addItemListener(new BooleanInvocationHandler(object, string));
        } else {
            this.addActionListener(EventHandler.create(ActionListener.class, object, string));
        }
    }

    private <T extends EventListener> void addListener(Class<T> clazz, T t2) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(clazz, t2);
    }

    private EventListener[] getListeners(Class<? extends EventListener> clazz) {
        if (this.listeners == null) {
            return null;
        }
        return this.listeners.getListeners(clazz);
    }

    public void addActionListener(ActionListener actionListener) {
        this.addListener(ActionListener.class, actionListener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.getListeners(ActionListener.class);
    }

    public void addItemListener(ItemListener itemListener) {
        this.addListener(ItemListener.class, itemListener);
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])this.getListeners(ItemListener.class);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ActionListener[] actionListenerArray = this.getActionListeners();
        if (actionListenerArray != null) {
            for (int i2 = 0; i2 < actionListenerArray.length; ++i2) {
                actionListenerArray[i2].actionPerformed(actionEvent);
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        boolean bl2 = this.isSelected();
        boolean bl3 = bl = itemEvent.getStateChange() == 1;
        if (bl2 != bl) {
            this.setSelected(bl);
            ItemListener[] itemListenerArray = this.getItemListeners();
            if (itemListenerArray != null) {
                for (int i2 = 0; i2 < itemListenerArray.length; ++i2) {
                    itemListenerArray[i2].itemStateChanged(itemEvent);
                }
            }
        }
    }

    private class BooleanInvocationHandler
    implements ItemListener {
        private Statement falseStatement;
        private Statement trueStatement;

        public BooleanInvocationHandler(Object object, String string) {
            this.falseStatement = new Statement(object, string, new Object[]{Boolean.FALSE});
            this.trueStatement = new Statement(object, string, new Object[]{Boolean.TRUE});
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            Statement statement = itemEvent.getStateChange() == 2 ? this.falseStatement : this.trueStatement;
            try {
                statement.execute();
            }
            catch (Exception exception) {
                LOG.log(Level.FINE, "Couldn't execute boolean method via Statement " + statement, exception);
            }
        }
    }
}

