/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.action;

import java.awt.Insets;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import org.jdesktop.swingx.action.AbstractActionExt;
import org.jdesktop.swingx.action.ActionManager;
import org.jdesktop.swingx.action.ToggleActionPropertyChangeListener;

public class ActionContainerFactory {
    private static Insets TOOLBAR_BUTTON_MARGIN = new Insets(1, 1, 1, 1);
    private ActionManager manager;

    public ActionContainerFactory(ActionManager actionManager) {
        this.setActionManager(actionManager);
    }

    public void setActionManager(ActionManager actionManager) {
        this.manager = actionManager;
    }

    public void configureButton(JToggleButton jToggleButton, AbstractActionExt abstractActionExt, ButtonGroup buttonGroup) {
        this.configureSelectableButton(jToggleButton, abstractActionExt, buttonGroup);
        this.configureButtonFromExtActionProperties(jToggleButton, abstractActionExt);
    }

    public void configureSelectableButton(AbstractButton abstractButton, AbstractActionExt abstractActionExt, ButtonGroup buttonGroup) {
        if (abstractActionExt != null && !abstractActionExt.isStateAction()) {
            throw new IllegalArgumentException("the Action must be a stateAction");
        }
        if (abstractButton.getAction() == abstractActionExt) {
            return;
        }
        Action action = abstractButton.getAction();
        if (action instanceof AbstractActionExt) {
            AbstractActionExt abstractActionExt2 = (AbstractActionExt)action;
            abstractButton.removeItemListener(abstractActionExt2);
            PropertyChangeListener[] propertyChangeListenerArray = abstractActionExt2.getPropertyChangeListeners();
            for (int i2 = propertyChangeListenerArray.length - 1; i2 >= 0; --i2) {
                ToggleActionPropertyChangeListener toggleActionPropertyChangeListener;
                if (!(propertyChangeListenerArray[i2] instanceof ToggleActionPropertyChangeListener) || !(toggleActionPropertyChangeListener = (ToggleActionPropertyChangeListener)propertyChangeListenerArray[i2]).isToggling(abstractButton)) continue;
                abstractActionExt2.removePropertyChangeListener(toggleActionPropertyChangeListener);
            }
        }
        abstractButton.setAction(abstractActionExt);
        if (buttonGroup != null) {
            buttonGroup.add(abstractButton);
        }
        if (abstractActionExt != null) {
            abstractButton.addItemListener(abstractActionExt);
            abstractButton.setSelected(abstractActionExt.isSelected());
            new ToggleActionPropertyChangeListener(abstractActionExt, abstractButton);
        }
    }

    protected void configureButtonFromExtActionProperties(AbstractButton abstractButton, Action action) {
        if (action.getValue("ShortDescription") == null) {
            abstractButton.setToolTipText((String)action.getValue("Name"));
        }
        if (action.getValue("__LargeIcon__") != null) {
            abstractButton.setIcon((Icon)action.getValue("__LargeIcon__"));
        }
        if (abstractButton.getIcon() != null) {
            abstractButton.setText("");
        }
    }
}

