/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.Font;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Method;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.text.html.HTMLDocument;
import org.jdesktop.swingx.ForwardingRepaintManager;
import org.jdesktop.swingx.RepaintManagerX;
import org.jdesktop.swingx.TranslucentRepaintManager;

public final class SwingXUtilities {
    private static String STYLESHEET = "body { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0; font-family: %s; font-size: %dpt;  }a, p, li { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0; font-family: %s; font-size: %dpt;  }";

    public static void updateMnemonicBinding(JComponent jComponent, String string) {
        SwingXUtilities.updateMnemonicBinding(jComponent, string, null);
    }

    public static void updateMnemonicBinding(JComponent jComponent, String string, String string2) {
        Object object;
        Class<?> clazz = jComponent.getClass();
        int n2 = -1;
        try {
            object = clazz.getMethod("getMnemonic", new Class[0]);
            n2 = (Integer)((Method)object).invoke((Object)jComponent, new Object[0]);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("unable to access mnemonic", exception);
        }
        object = SwingUtilities.getUIInputMap(jComponent, 2);
        if (n2 != 0) {
            if (object == null) {
                object = new ComponentInputMapUIResource(jComponent);
                SwingUtilities.replaceUIInputMap(jComponent, 2, (InputMap)object);
            }
            ((InputMap)object).clear();
            ((InputMap)object).put(KeyStroke.getKeyStroke(n2, 8, false), string);
            ((InputMap)object).put(KeyStroke.getKeyStroke(n2, 8, true), string2);
            ((InputMap)object).put(KeyStroke.getKeyStroke(n2, 0, true), string2);
        } else if (object != null) {
            ((InputMap)object).clear();
        }
    }

    public static void setHtmlFont(HTMLDocument hTMLDocument, Font font) {
        String string = String.format(STYLESHEET, font.getName(), font.getSize(), font.getName(), font.getSize());
        try {
            hTMLDocument.getStyleSheet().loadRules(new StringReader(string), null);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public static boolean isDescendingFrom(Component component, Component component2) {
        while (component != null) {
            if (component instanceof JPopupMenu && (component = ((JPopupMenu)component).getInvoker()) == null) {
                return false;
            }
            if (component == component2) {
                return true;
            }
            component = component.getParent();
        }
        return false;
    }

    static RepaintManager getTranslucentRepaintManager(RepaintManager repaintManager) {
        RepaintManager repaintManager2 = repaintManager;
        while (repaintManager2 != null && !repaintManager2.getClass().isAnnotationPresent(TranslucentRepaintManager.class)) {
            if (repaintManager2 instanceof ForwardingRepaintManager) {
                repaintManager2 = ((ForwardingRepaintManager)repaintManager2).getDelegateManager();
                continue;
            }
            repaintManager2 = null;
        }
        return repaintManager2 == null ? new RepaintManagerX(repaintManager) : repaintManager;
    }

    public static boolean isUIInstallable(Object object) {
        return object == null || object instanceof UIResource;
    }
}

