/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.util.logging.Logger;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTree;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.renderer.StringValues;
import org.jdesktop.swingx.tree.DefaultXTreeCellRenderer;
import org.jdesktop.swingx.treetable.TreeTableModel;

public class JXTreeTable
extends JXTable {
    private static final Logger LOG = Logger.getLogger(JXTreeTable.class.getName());
    private TreeTableCellRenderer renderer;

    public TreeTableModel getTreeTableModel() {
        return (TreeTableModel)this.renderer.getModel();
    }

    public TreePath getPathForRow(int n2) {
        return this.renderer.getPathForRow(n2);
    }

    public boolean isHierarchical(int n2) {
        if (n2 < 0 || n2 >= this.getColumnCount()) {
            throw new IllegalArgumentException("column must be valid, was" + n2);
        }
        return this.getHierarchicalColumn() == n2;
    }

    public int getHierarchicalColumn() {
        return this.convertColumnIndexToView(((TreeTableModel)this.renderer.getModel()).getHierarchicalColumn());
    }

    @Override
    public TableCellRenderer getCellRenderer(int n2, int n3) {
        if (this.isHierarchical(n3)) {
            return this.renderer;
        }
        return super.getCellRenderer(n2, n3);
    }

    @Override
    public String getStringAt(int n2, int n3) {
        if (this.isHierarchical(n3)) {
            return this.getHierarchicalStringAt(n2);
        }
        return super.getStringAt(n2, n3);
    }

    private String getHierarchicalStringAt(int n2) {
        return this.renderer.getStringAt(n2);
    }

    protected static class TreeTableDataAdapter
    extends JXTable.TableAdapter {
        private final JXTreeTable table;

        @Override
        public int getDepth() {
            return this.table.getPathForRow(this.row).getPathCount() - 1;
        }

        @Override
        public boolean isLeaf() {
            TreePath treePath = this.table.getPathForRow(this.row);
            if (treePath != null) {
                return this.table.getTreeTableModel().isLeaf(treePath.getLastPathComponent());
            }
            return true;
        }

        @Override
        public String getFilteredStringAt(int n2, int n3) {
            if (this.table.getTreeTableModel().getHierarchicalColumn() == n3 && this.modelToView(n3) < 0) {
                return this.table.getHierarchicalStringAt(n2);
            }
            return super.getFilteredStringAt(n2, n3);
        }
    }

    static class TreeTableCellRenderer
    extends JXTree
    implements TableCellRenderer {
        protected JXTreeTable treeTable;

        private class ClippedTreeCellRenderer
        extends DefaultXTreeCellRenderer
        implements StringValue {
            final /* synthetic */ TreeTableCellRenderer this$0;

            private Object getHierarchicalTableValue(Object object) {
                Object object2 = object;
                if (this.this$0.treeTable != null) {
                    int n2 = this.this$0.treeTable.getTreeTableModel().getHierarchicalColumn();
                    Object object3 = null;
                    if (n2 >= 0) {
                        object3 = this.this$0.treeTable.getTreeTableModel().getValueAt(object, n2);
                    }
                    object2 = object3;
                }
                return object2;
            }

            @Override
            public String getString(Object object) {
                return StringValues.TO_STRING.getString(this.getHierarchicalTableValue(object));
            }
        }
    }
}

