/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.CompoundHighlighter;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.renderer.StringValues;
import org.jdesktop.swingx.rollover.RolloverRenderer;

public class JXTree
extends JTree {
    private static final Logger LOG = Logger.getLogger(JXTree.class.getName());
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final TreePath[] EMPTY_TREEPATH_ARRAY = new TreePath[0];
    protected CompoundHighlighter compoundHighlighter;
    private DelegatingRenderer delegatingRenderer;
    private boolean overwriteIcons;

    public String getStringAt(int n2) {
        return this.getStringAt(this.getPathForRow(n2));
    }

    public String getStringAt(TreePath treePath) {
        if (treePath == null) {
            return null;
        }
        TreeCellRenderer treeCellRenderer = this.getDelegatingRenderer().getDelegateRenderer();
        if (treeCellRenderer instanceof StringValue) {
            return ((StringValue)((Object)treeCellRenderer)).getString(treePath.getLastPathComponent());
        }
        return StringValues.TO_STRING.getString(treePath.getLastPathComponent());
    }

    public boolean isOverwriteRendererIcons() {
        return this.overwriteIcons;
    }

    private DelegatingRenderer getDelegatingRenderer() {
        if (this.delegatingRenderer == null) {
            this.delegatingRenderer = new DelegatingRenderer();
        }
        return this.delegatingRenderer;
    }

    protected TreeCellRenderer createDefaultCellRenderer() {
        throw new InternalError("Badly shrinked");
    }

    protected ComponentAdapter getComponentAdapter(int n2) {
        throw new InternalError("Badly shrinked");
    }

    protected static class TreeAdapter
    extends ComponentAdapter {
        private final JXTree tree;

        @Override
        public boolean hasFocus() {
            return this.tree.isFocusOwner() && this.tree.getLeadSelectionRow() == this.row;
        }

        @Override
        public Object getValueAt(int n2, int n3) {
            TreePath treePath = this.tree.getPathForRow(n2);
            return treePath.getLastPathComponent();
        }

        @Override
        public Object getFilteredValueAt(int n2, int n3) {
            return this.getValueAt(n2, n3);
        }

        @Override
        public Object getValue() {
            return this.getValueAt(this.row, this.column);
        }

        @Override
        public String getFilteredStringAt(int n2, int n3) {
            return this.tree.getStringAt(n2);
        }

        @Override
        public boolean isEditable() {
            return this.tree.isPathEditable(this.tree.getPathForRow(this.row));
        }

        @Override
        public int getDepth() {
            return this.tree.getPathForRow(this.row).getPathCount() - 1;
        }

        @Override
        public boolean isLeaf() {
            return this.tree.getModel().isLeaf(this.getValue());
        }
    }

    public class DelegatingRenderer
    implements TreeCellRenderer,
    RolloverRenderer {
        private Icon closedIcon = null;
        private Icon openIcon = null;
        private Icon leafIcon = null;
        private TreeCellRenderer delegate;

        public DelegatingRenderer() {
            this(null);
            this.initIcons(new DefaultTreeCellRenderer());
        }

        public DelegatingRenderer(TreeCellRenderer treeCellRenderer) {
            this.initIcons((DefaultTreeCellRenderer)(treeCellRenderer instanceof DefaultTreeCellRenderer ? treeCellRenderer : new DefaultTreeCellRenderer()));
            this.setDelegateRenderer(treeCellRenderer);
        }

        private void initIcons(DefaultTreeCellRenderer defaultTreeCellRenderer) {
            this.closedIcon = defaultTreeCellRenderer.getDefaultClosedIcon();
            this.openIcon = defaultTreeCellRenderer.getDefaultOpenIcon();
            this.leafIcon = defaultTreeCellRenderer.getDefaultLeafIcon();
        }

        public void setDelegateRenderer(TreeCellRenderer treeCellRenderer) {
            if (treeCellRenderer == null) {
                treeCellRenderer = JXTree.this.createDefaultCellRenderer();
            }
            this.delegate = treeCellRenderer;
            this.updateIcons();
        }

        private void updateIcons() {
            if (!JXTree.this.isOverwriteRendererIcons()) {
                return;
            }
            this.setClosedIcon(this.closedIcon);
            this.setOpenIcon(this.openIcon);
            this.setLeafIcon(this.leafIcon);
        }

        public void setClosedIcon(Icon icon) {
            if (this.delegate instanceof DefaultTreeCellRenderer) {
                ((DefaultTreeCellRenderer)this.delegate).setClosedIcon(icon);
            }
            this.closedIcon = icon;
        }

        public void setOpenIcon(Icon icon) {
            if (this.delegate instanceof DefaultTreeCellRenderer) {
                ((DefaultTreeCellRenderer)this.delegate).setOpenIcon(icon);
            }
            this.openIcon = icon;
        }

        public void setLeafIcon(Icon icon) {
            if (this.delegate instanceof DefaultTreeCellRenderer) {
                ((DefaultTreeCellRenderer)this.delegate).setLeafIcon(icon);
            }
            this.leafIcon = icon;
        }

        public TreeCellRenderer getDelegateRenderer() {
            return this.delegate;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n2, boolean bl4) {
            Component component = this.delegate.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n2, bl4);
            if (JXTree.this.compoundHighlighter != null && n2 < JXTree.this.getRowCount() && n2 >= 0) {
                component = JXTree.this.compoundHighlighter.highlight(component, JXTree.this.getComponentAdapter(n2));
            }
            return component;
        }
    }
}

