/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.FilterPipeline;
import org.jdesktop.swingx.event.TableColumnModelExtListener;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.renderer.StringValues;
import org.jdesktop.swingx.table.TableColumnExt;

public class JXTable
extends JTable
implements TableColumnModelExtListener {
    private static final Logger LOG = Logger.getLogger(JXTable.class.getName());
    protected FilterPipeline filters;
    private boolean editable;

    @Override
    public int convertRowIndexToModel(int n2) {
        return this.getFilters() != null ? this.getFilters().convertRowIndexToModel(n2) : n2;
    }

    @Override
    public Object getValueAt(int n2, int n3) {
        return this.getModel().getValueAt(this.convertRowIndexToModel(n2), this.convertColumnIndexToModel(n3));
    }

    @Override
    public boolean isCellEditable(int n2, int n3) {
        TableColumnExt tableColumnExt;
        if (!this.isEditable()) {
            return false;
        }
        boolean bl = this.getModel().isCellEditable(this.convertRowIndexToModel(n2), this.convertColumnIndexToModel(n3));
        if (bl && (tableColumnExt = this.getColumnExt(n3)) != null) {
            bl = tableColumnExt.isEditable();
        }
        return bl;
    }

    public FilterPipeline getFilters() {
        return this.filters;
    }

    public TableColumn getColumn(int n2) {
        return this.getColumnModel().getColumn(n2);
    }

    public TableColumnExt getColumnExt(int n2) {
        TableColumn tableColumn = this.getColumn(n2);
        if (tableColumn instanceof TableColumnExt) {
            return (TableColumnExt)tableColumn;
        }
        return null;
    }

    public String getStringAt(int n2, int n3) {
        TableCellRenderer tableCellRenderer = this.getCellRenderer(n2, n3);
        if (tableCellRenderer instanceof StringValue) {
            return ((StringValue)((Object)tableCellRenderer)).getString(this.getValueAt(n2, n3));
        }
        return StringValues.TO_STRING.getString(this.getValueAt(n2, n3));
    }

    @Override
    public TableCellRenderer getCellRenderer(int n2, int n3) {
        TableCellRenderer tableCellRenderer = super.getCellRenderer(n2, n3);
        if (tableCellRenderer == null) {
            tableCellRenderer = this.getDefaultRenderer(Object.class);
        }
        return tableCellRenderer;
    }

    public boolean isEditable() {
        return this.editable;
    }

    static {
        LookAndFeelAddons.getAddon();
    }

    protected static class TableAdapter
    extends ComponentAdapter {
        private final JXTable table;

        protected TableColumn getColumnByModelIndex(int n2) {
            throw new InternalError("Badly shrinked");
        }

        @Override
        public Object getColumnIdentifierAt(int n2) {
            if (n2 < 0 || n2 >= this.getColumnCount()) {
                throw new ArrayIndexOutOfBoundsException("invalid column index: " + n2);
            }
            TableColumn tableColumn = this.getColumnByModelIndex(n2);
            Object object = tableColumn != null ? tableColumn.getIdentifier() : null;
            return object;
        }

        @Override
        public int getColumnCount() {
            return this.table.getModel().getColumnCount();
        }

        @Override
        public Object getValueAt(int n2, int n3) {
            return this.table.getModel().getValueAt(n2, n3);
        }

        @Override
        public boolean isTestable(int n2) {
            return this.getColumnByModelIndex(n2) != null;
        }

        @Override
        public Object getFilteredValueAt(int n2, int n3) {
            return this.getValueAt(this.table.convertRowIndexToModel(n2), n3);
        }

        @Override
        public Object getValue() {
            return this.table.getValueAt(this.row, this.column);
        }

        @Override
        public String getFilteredStringAt(int n2, int n3) {
            int n4 = this.modelToView(n3);
            if (n4 >= 0) {
                return this.table.getStringAt(n2, n4);
            }
            TableCellRenderer tableCellRenderer = this.getRendererByModelColumn(n3);
            if (tableCellRenderer instanceof StringValue) {
                return ((StringValue)((Object)tableCellRenderer)).getString(this.getFilteredValueAt(n2, n3));
            }
            return super.getFilteredStringAt(n2, n3);
        }

        private TableCellRenderer getRendererByModelColumn(int n2) {
            TableColumn tableColumn = this.getColumnByModelIndex(n2);
            TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
            if (tableCellRenderer == null) {
                tableCellRenderer = this.table.getDefaultRenderer(this.table.getModel().getColumnClass(n2));
            }
            if (tableCellRenderer == null) {
                tableCellRenderer = this.table.getDefaultRenderer(Object.class);
            }
            return tableCellRenderer;
        }

        @Override
        public boolean isEditable() {
            return this.table.isCellEditable(this.row, this.column);
        }

        @Override
        public boolean hasFocus() {
            boolean bl = this.table.getSelectionModel().getLeadSelectionIndex() == this.row;
            boolean bl2 = this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex() == this.column;
            return this.table.isFocusOwner() && bl && bl2;
        }

        @Override
        public int modelToView(int n2) {
            return this.table.convertColumnIndexToView(n2);
        }

        @Override
        public int viewToModel(int n2) {
            return this.table.convertColumnIndexToModel(n2);
        }
    }
}

