/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Insets;
import javax.swing.JComponent;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.StatusBarAddon;
import org.jdesktop.swingx.plaf.StatusBarUI;

public class JXStatusBar
extends JComponent {
    private boolean resizeHandleEnabled;

    public JXStatusBar() {
        this.updateUI();
    }

    public void setResizeHandleEnabled(boolean bl) {
        boolean bl2 = this.isResizeHandleEnabled();
        this.resizeHandleEnabled = bl;
        this.firePropertyChange("resizeHandleEnabled", bl2, this.isResizeHandleEnabled());
    }

    public boolean isResizeHandleEnabled() {
        return this.resizeHandleEnabled;
    }

    public void setUI(StatusBarUI statusBarUI) {
        super.setUI(statusBarUI);
    }

    @Override
    public String getUIClassID() {
        return "StatusBarUI";
    }

    @Override
    public void updateUI() {
        this.setUI((StatusBarUI)LookAndFeelAddons.getUI(this, StatusBarUI.class));
    }

    static {
        LookAndFeelAddons.contribute(new StatusBarAddon());
    }

    public static class Constraint {
        private Insets insets;
        private ResizeBehavior resizeBehavior;
        private int fixedWidth = 0;

        public Constraint(Insets insets) {
            this(ResizeBehavior.FIXED, insets);
        }

        public Constraint(ResizeBehavior resizeBehavior) {
            this(resizeBehavior, null);
        }

        public Constraint(ResizeBehavior resizeBehavior, Insets insets) {
            this.resizeBehavior = resizeBehavior;
            this.insets = insets == null ? new Insets(0, 0, 0, 0) : (Insets)insets.clone();
        }

        public ResizeBehavior getResizeBehavior() {
            return this.resizeBehavior;
        }

        public Insets getInsets() {
            return (Insets)this.insets.clone();
        }

        public int getFixedWidth() {
            return this.fixedWidth;
        }

        public static enum ResizeBehavior {
            FILL,
            FIXED;

        }
    }
}

