/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.RepaintManager;
import javax.swing.Scrollable;
import org.jdesktop.swingx.SwingXUtilities;
import org.jdesktop.swingx.painter.Painter;

public class JXPanel
extends JPanel
implements Scrollable {
    private boolean scrollableTracksViewportHeight = true;
    private boolean scrollableTracksViewportWidth = true;
    private float alpha = 1.0f;
    private boolean oldOpaque;
    private boolean inheritAlpha = true;
    private Painter backgroundPainter;
    private boolean paintBorderInsets = true;

    public JXPanel() {
    }

    public JXPanel(LayoutManager layoutManager) {
        super(layoutManager);
    }

    public void setAlpha(float f2) {
        if (this.alpha != f2) {
            assert (f2 >= 0.0f && (double)f2 <= 1.0);
            float f3 = this.alpha;
            this.alpha = f2;
            if (f2 > 0.0f && f2 < 1.0f) {
                if (f3 == 1.0f) {
                    this.oldOpaque = this.isOpaque();
                    this.setOpaque(false);
                }
                RepaintManager repaintManager = RepaintManager.currentManager(this);
                RepaintManager repaintManager2 = SwingXUtilities.getTranslucentRepaintManager(repaintManager);
                RepaintManager.setCurrentManager(repaintManager2);
            } else if (f2 == 1.0f && this.oldOpaque) {
                this.setOpaque(true);
            }
            this.firePropertyChange("alpha", f3, f2);
            this.repaint();
        }
    }

    public float getAlpha() {
        return this.alpha;
    }

    public float getEffectiveAlpha() {
        if (this.inheritAlpha) {
            float f2 = this.alpha;
            Container container = this;
            while ((container = container.getParent()) != null) {
                if (!(container instanceof JXPanel)) continue;
                f2 = Math.min(((JXPanel)container).getAlpha(), f2);
            }
            return f2;
        }
        return this.alpha;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this.scrollableTracksViewportHeight;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.scrollableTracksViewportWidth;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n2, int n3) {
        return 10;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n2, int n3) {
        return 10;
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
    }

    public void setBackgroundPainter(Painter painter) {
        Painter painter2 = this.getBackgroundPainter();
        this.backgroundPainter = painter;
        this.firePropertyChange("backgroundPainter", painter2, this.getBackgroundPainter());
        this.repaint();
    }

    public Painter getBackgroundPainter() {
        return this.backgroundPainter;
    }

    public boolean isPaintBorderInsets() {
        return this.paintBorderInsets;
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        float f2 = this.getEffectiveAlpha();
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, f2);
        graphics2D.setComposite(alphaComposite);
        super.paint(graphics2D);
        graphics2D.setComposite(composite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.backgroundPainter != null) {
            if (this.isOpaque()) {
                super.paintComponent(graphics);
            }
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            try {
                if (this.isPaintBorderInsets()) {
                    this.backgroundPainter.paint(graphics2D, this, this.getWidth(), this.getHeight());
                }
                Insets insets = this.getInsets();
                graphics2D.translate(insets.left, insets.top);
                this.backgroundPainter.paint(graphics2D, this, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
            }
            finally {
                graphics2D.dispose();
            }
        } else {
            super.paintComponent(graphics);
        }
    }
}

