/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.jdesktop.swingx.calendar.CalendarUtils;
import org.jdesktop.swingx.calendar.DateSelectionModel;
import org.jdesktop.swingx.calendar.DaySelectionModel;
import org.jdesktop.swingx.event.EventListenerMap;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.MonthViewAddon;
import org.jdesktop.swingx.plaf.MonthViewUI;

public class JXMonthView
extends JComponent {
    private static final Logger LOG = Logger.getLogger(JXMonthView.class.getName());
    private Date firstDisplayedDay;
    private Calendar cal;
    private Calendar anchor;
    private Date today;
    private DateSelectionModel model;
    private DaySelectionModel flaggedDates;
    private EventListenerMap listenerMap;
    private boolean traversable;
    private boolean leadingDays;
    private boolean trailingDays;
    private boolean showWeekNumber;
    private boolean componentInputMapEnabled;
    private String[] _daysOfTheWeek;
    private int boxPaddingX;
    private int boxPaddingY;
    private int minCalCols;
    private int minCalRows;
    private Color todayBackgroundColor;
    private Color monthStringBackground;
    private Color monthStringForeground;
    private Color daysOfTheWeekForeground;
    private Color selectedBackground;
    private Hashtable<Integer, Color> dayToColorTable;
    private Color flaggedDayForeground;
    private Color selectedForeground;
    private boolean zoomable;

    @Override
    public void setLocale(Locale locale) {
        this.model.setLocale(locale);
    }

    public Calendar getCalendar() {
        if (this.cal == null) {
            throw new IllegalStateException("must not be called before instantiation is complete");
        }
        Calendar calendar = (Calendar)this.cal.clone();
        calendar.setTime(this.firstDisplayedDay);
        return calendar;
    }

    public TimeZone getTimeZone() {
        return this.cal.getTimeZone();
    }

    public Date getLastDisplayedDay() {
        return this.getUI().getLastDisplayedDay();
    }

    public Date getFirstDisplayedDay() {
        return this.firstDisplayedDay;
    }

    public void setFirstDisplayedDay(Date date) {
        this.anchor.setTime(date);
        Date date2 = this.getFirstDisplayedDay();
        this.cal.setTime(this.anchor.getTime());
        CalendarUtils.startOfMonth(this.cal);
        this.firstDisplayedDay = this.cal.getTime();
        this.firePropertyChange("firstDisplayedDay", date2, this.getFirstDisplayedDay());
    }

    public void ensureDateVisible(Date date) {
        if (date.before(this.firstDisplayedDay)) {
            this.setFirstDisplayedDay(date);
        } else {
            Date date2 = this.getLastDisplayedDay();
            if (date.after(date2)) {
                this.cal.setTime(date);
                int n2 = this.cal.get(2);
                int n3 = this.cal.get(1);
                this.cal.setTime(date2);
                int n4 = this.cal.get(2);
                int n5 = this.cal.get(1);
                int n6 = n2 - n4 + (n3 - n5) * 12;
                this.cal.setTime(this.firstDisplayedDay);
                this.cal.add(2, n6);
                this.setFirstDisplayedDay(this.cal.getTime());
            }
        }
    }

    public Date getToday() {
        return this.today != null ? (Date)this.today.clone() : null;
    }

    @Override
    public MonthViewUI getUI() {
        return (MonthViewUI)this.ui;
    }

    public DateSelectionModel getSelectionModel() {
        return this.model;
    }

    public void clearSelection() {
        this.getSelectionModel().clearSelection();
    }

    public boolean isSelectionEmpty() {
        return this.getSelectionModel().isSelectionEmpty();
    }

    public SortedSet<Date> getSelection() {
        return this.getSelectionModel().getSelection();
    }

    public void addSelectionInterval(Date date, Date date2) {
        this.getSelectionModel().addSelectionInterval(date, date2);
    }

    public void setSelectionInterval(Date date, Date date2) {
        this.getSelectionModel().setSelectionInterval(date, date2);
    }

    public DateSelectionModel.SelectionMode getSelectionMode() {
        return this.getSelectionModel().getSelectionMode();
    }

    public Date getFirstSelectionDate() {
        return this.getSelectionModel().getFirstSelectionDate();
    }

    public Date getLastSelectionDate() {
        return this.getSelectionModel().getLastSelectionDate();
    }

    public Date getSelectionDate() {
        return this.getFirstSelectionDate();
    }

    public void setSelectionDate(Date date) {
        if (date == null) {
            this.clearSelection();
        } else {
            this.setSelectionInterval(date, date);
        }
    }

    public boolean isSelected(Date date) {
        return this.getSelectionModel().isSelected(date);
    }

    public Date getLowerBound() {
        return this.getSelectionModel().getLowerBound();
    }

    public Date getUpperBound() {
        return this.getSelectionModel().getUpperBound();
    }

    public boolean isUnselectableDate(Date date) {
        return this.getSelectionModel().isUnselectableDate(date);
    }

    public boolean isFlaggedDate(Date date) {
        if (date == null) {
            return false;
        }
        return this.flaggedDates.isSelected(date);
    }

    public boolean isShowingLeadingDays() {
        return this.leadingDays;
    }

    public boolean isShowingTrailingDays() {
        return this.trailingDays;
    }

    public boolean isTraversable() {
        if (this.isZoomable()) {
            return true;
        }
        return this.traversable;
    }

    public boolean isZoomable() {
        return this.zoomable;
    }

    public void setZoomable(boolean bl) {
        boolean bl2 = this.isZoomable();
        this.zoomable = bl;
        this.firePropertyChange("zoomable", bl2, this.isZoomable());
    }

    public boolean isShowingWeekNumber() {
        return this.showWeekNumber;
    }

    public String[] getDaysOfTheWeek() {
        if (this._daysOfTheWeek != null) {
            String[] stringArray = new String[7];
            System.arraycopy(this._daysOfTheWeek, 0, stringArray, 0, 7);
            return stringArray;
        }
        return this.getUI().getDaysOfTheWeek();
    }

    public String getDayOfTheWeek(int n2) {
        return this.getDaysOfTheWeek()[n2 - 1];
    }

    public int getBoxPaddingX() {
        return this.boxPaddingX;
    }

    public void setBoxPaddingX(int n2) {
        int n3 = this.getBoxPaddingX();
        this.boxPaddingX = n2;
        this.firePropertyChange("boxPaddingX", n3, this.getBoxPaddingX());
    }

    public int getBoxPaddingY() {
        return this.boxPaddingY;
    }

    public void setBoxPaddingY(int n2) {
        int n3 = this.getBoxPaddingY();
        this.boxPaddingY = n2;
        this.firePropertyChange("boxPaddingY", n3, this.getBoxPaddingY());
    }

    public Color getSelectionBackground() {
        return this.selectedBackground;
    }

    public void setSelectionBackground(Color color) {
        Color color2 = this.getSelectionBackground();
        this.selectedBackground = color;
        this.firePropertyChange("selectionBackground", color2, this.getSelectionBackground());
    }

    public Color getSelectionForeground() {
        return this.selectedForeground;
    }

    public void setSelectionForeground(Color color) {
        Color color2 = this.getSelectionForeground();
        this.selectedForeground = color;
        this.firePropertyChange("selectionForeground", color2, this.getSelectionForeground());
    }

    public Color getTodayBackground() {
        return this.todayBackgroundColor;
    }

    public Color getMonthStringBackground() {
        return this.monthStringBackground;
    }

    public void setMonthStringBackground(Color color) {
        Color color2 = this.getMonthStringBackground();
        this.monthStringBackground = color;
        this.firePropertyChange("monthStringBackground", color2, this.getMonthStringBackground());
        this.repaint();
    }

    public Color getMonthStringForeground() {
        return this.monthStringForeground;
    }

    public void setMonthStringForeground(Color color) {
        Color color2 = this.getMonthStringForeground();
        this.monthStringForeground = color;
        this.firePropertyChange("monthStringForeground", color2, this.getMonthStringForeground());
        this.repaint();
    }

    public void setDaysOfTheWeekForeground(Color color) {
        Color color2 = this.getDaysOfTheWeekForeground();
        this.daysOfTheWeekForeground = color;
        this.firePropertyChange("daysOfTheWeekForeground", color2, this.getDaysOfTheWeekForeground());
    }

    public Color getDaysOfTheWeekForeground() {
        return this.daysOfTheWeekForeground;
    }

    public Color getPerDayOfWeekForeground(int n2) {
        return this.dayToColorTable.get(n2);
    }

    public void setFlaggedDayForeground(Color color) {
        Color color2 = this.getFlaggedDayForeground();
        this.flaggedDayForeground = color;
        this.firePropertyChange("flaggedDayForeground", color2, this.getFlaggedDayForeground());
    }

    public Color getFlaggedDayForeground() {
        return this.flaggedDayForeground;
    }

    public int getPreferredColumnCount() {
        return this.minCalCols;
    }

    public int getPreferredRowCount() {
        return this.minCalRows;
    }

    public void commitSelection() {
        this.getSelectionModel().setAdjusting(false);
        this.fireActionPerformed("monthViewCommit");
    }

    public void cancelSelection() {
        this.getSelectionModel().setAdjusting(false);
        this.fireActionPerformed("monthViewCancel");
    }

    public void setComponentInputMapEnabled(boolean bl) {
        boolean bl2 = this.isComponentInputMapEnabled();
        this.componentInputMapEnabled = bl;
        this.firePropertyChange("componentInputMapEnabled", bl2, this.isComponentInputMapEnabled());
    }

    public boolean isComponentInputMapEnabled() {
        return this.componentInputMapEnabled;
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerMap.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerMap.remove(ActionListener.class, actionListener);
    }

    protected void fireActionPerformed(String string) {
        throw new InternalError("Badly shrinked");
    }

    static {
        LookAndFeelAddons.contribute(new MonthViewAddon());
    }
}

