/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.StringReader;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.WrappedPlainView;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.painter.Painter;

public class JXLabel
extends JLabel {
    private double textRotation = 0.0;
    private boolean painting = false;
    private Painter foregroundPainter;
    private Painter backgroundPainter;
    private boolean multiLine;
    private int pWidth;
    private int pHeight;
    private boolean dontIgnoreRepaint = false;
    private int occupiedWidth;
    private boolean paintBorderInsets = true;
    private int maxLineSpan = -1;
    public boolean painted;
    private TextAlignment textAlignment = TextAlignment.LEFT;

    public JXLabel() {
        this.initPainterSupport();
        this.initLineWrapSupport();
    }

    private void initPainterSupport() {
        this.foregroundPainter = new AbstractPainter<JXLabel>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void doPaint(Graphics2D graphics2D, JXLabel jXLabel, int n2, int n3) {
                Insets insets = JXLabel.this.getInsets();
                graphics2D = (Graphics2D)graphics2D.create(-insets.left, -insets.top, n2, n3);
                try {
                    jXLabel.paint(graphics2D);
                }
                finally {
                    graphics2D.dispose();
                }
            }

            @Override
            protected boolean shouldUseCache() {
                return false;
            }

            public boolean equals(Object object) {
                return object != null && this.getClass().equals(object.getClass());
            }
        };
    }

    private void initLineWrapSupport() {
        this.addPropertyChangeListener(new MultiLineSupport());
        this.addHierarchyBoundsListener(new HierarchyBoundsAdapter(){

            @Override
            public void ancestorResized(HierarchyEvent hierarchyEvent) {
                View view;
                Rectangle rectangle;
                if (hierarchyEvent.getChanged() instanceof JViewport && (rectangle = hierarchyEvent.getChanged().getBounds()).getWidth() < (double)JXLabel.this.getWidth() && (view = JXLabel.this.getWrappingView()) != null) {
                    view.setSize(rectangle.width, rectangle.height);
                }
            }
        });
    }

    public final Painter getForegroundPainter() {
        return this.foregroundPainter;
    }

    @Override
    public void reshape(int n2, int n3, int n4, int n5) {
        View view;
        int n6 = this.getHeight();
        super.reshape(n2, n3, n4, n5);
        if (!this.isLineWrap()) {
            return;
        }
        if (n6 == 0) {
            return;
        }
        if (n4 > this.getVisibleRect().width) {
            n4 = this.getVisibleRect().width;
        }
        if ((view = (View)this.getClientProperty("html")) != null && view instanceof Renderer) {
            view.setSize(n4 - this.occupiedWidth, n5);
        }
    }

    public double getTextRotation() {
        return this.textRotation;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.isPreferredSizeSet()) {
            return dimension;
        }
        if (this.textRotation == 0.0) {
            int n2;
            int n3;
            View view = this.getWrappingView();
            if (view == null) {
                if (this.isLineWrap() && !MultiLineSupport.isHTML(this.getText())) {
                    this.getMultiLineSupport();
                    this.putClientProperty("html", MultiLineSupport.createView(this));
                    view = (View)this.getClientProperty("html");
                } else {
                    return dimension;
                }
            }
            Insets insets = this.getInsets();
            int n4 = insets.left + insets.right;
            int n5 = insets.top + insets.bottom;
            Rectangle rectangle = new Rectangle();
            Rectangle rectangle2 = new Rectangle();
            rectangle.height = 0;
            rectangle.width = 0;
            rectangle.y = 0;
            rectangle.x = 0;
            rectangle2.x = n4;
            rectangle2.y = n5;
            rectangle2.height = Short.MAX_VALUE;
            rectangle2.width = Short.MAX_VALUE;
            Rectangle rectangle3 = this.calculateIconRect();
            boolean bl = this.getText() == null || this.getText().equals("");
            int n6 = 0;
            if (bl) {
                rectangle.height = 0;
                rectangle.width = 0;
                n3 = 0;
            } else {
                JPanel jPanel;
                Border border;
                n3 = rectangle3.width == 0 ? 0 : this.getIconTextGap();
                this.occupiedWidth = n4 + rectangle3.width + n3;
                Container container = this.getParent();
                if (container != null && container instanceof JPanel && (border = (jPanel = (JPanel)container).getBorder()) != null) {
                    Insets insets2 = border.getBorderInsets(jPanel);
                    this.occupiedWidth += insets2.left + insets2.right;
                }
                n2 = this.getHorizontalTextPosition() == 0 ? rectangle2.width : rectangle2.width - (rectangle3.width + n3);
                float f2 = view.getPreferredSpan(0);
                rectangle.width = Math.min(n2, (int)f2);
                if (this.maxLineSpan > 0) {
                    rectangle.width = Math.min(rectangle.width, this.maxLineSpan);
                    if (f2 > (float)this.maxLineSpan) {
                        view.setSize(this.maxLineSpan, rectangle.height);
                    }
                }
                rectangle.height = (int)view.getPreferredSpan(1);
                if (rectangle.height == 0) {
                    rectangle.height = this.getFont().getSize();
                }
            }
            rectangle.y = this.getVerticalTextPosition() == 1 ? (this.getHorizontalTextPosition() != 0 ? 0 : -(rectangle.height + n3)) : (this.getVerticalTextPosition() == 0 ? rectangle3.height / 2 - rectangle.height / 2 : (this.getVerticalTextPosition() != 0 ? rectangle3.height - rectangle.height : rectangle3.height + n3));
            rectangle.x = this.getHorizontalTextPosition() == 2 ? -(rectangle.width + n3) : (this.getHorizontalTextPosition() == 0 ? rectangle3.width / 2 - rectangle.width / 2 : rectangle3.width + n3);
            n2 = Math.min(rectangle3.x, rectangle.x);
            int n7 = Math.max(rectangle3.x + rectangle3.width, rectangle.x + rectangle.width) - n2;
            int n8 = Math.min(rectangle3.y, rectangle.y);
            int n9 = Math.max(rectangle3.y + rectangle3.height, rectangle.y + rectangle.height) - n8;
            int n10 = this.getVerticalAlignment() == 1 ? rectangle2.y - n8 : (this.getVerticalAlignment() == 0 ? rectangle2.y + rectangle2.height / 2 - (n8 + n9 / 2) : rectangle2.y + rectangle2.height - (n8 + n9));
            int n11 = this.getHorizontalAlignment() == 2 ? rectangle2.x - n2 : (this.getHorizontalAlignment() == 4 ? rectangle2.x + rectangle2.width - (n2 + n7) : rectangle2.x + rectangle2.width / 2 - (n2 + n7 / 2));
            rectangle.x += n11;
            rectangle.y += n10;
            rectangle3.x += n11;
            rectangle3.y += n10;
            if (n6 < 0) {
                rectangle.x -= n6;
            }
            int n12 = Math.min(rectangle3.x, rectangle.x);
            int n13 = Math.max(rectangle3.x + rectangle3.width, rectangle.x + rectangle.width);
            int n14 = Math.min(rectangle3.y, rectangle.y);
            int n15 = Math.max(rectangle3.y + rectangle3.height, rectangle.y + rectangle.height);
            Dimension dimension2 = new Dimension(n13 - n12, n15 - n14);
            dimension2.width += n4;
            dimension2.height += n5;
            return dimension2;
        }
        double d2 = this.getTextRotation();
        dimension.setSize(JXLabel.rotateWidth(dimension, d2), JXLabel.rotateHeight(dimension, d2));
        return dimension;
    }

    private View getWrappingView() {
        if (super.getTopLevelAncestor() == null) {
            return null;
        }
        View view = (View)this.getClientProperty("html");
        if (!(view instanceof Renderer)) {
            return null;
        }
        return view;
    }

    private Rectangle calculateIconRect() {
        Rectangle rectangle = new Rectangle();
        Icon icon = this.isEnabled() ? this.getIcon() : this.getDisabledIcon();
        rectangle.height = 0;
        rectangle.width = 0;
        rectangle.y = 0;
        rectangle.x = 0;
        if (icon != null) {
            rectangle.width = icon.getIconWidth();
            rectangle.height = icon.getIconHeight();
        } else {
            rectangle.height = 0;
            rectangle.width = 0;
        }
        return rectangle;
    }

    public int getMaxLineSpan() {
        return this.maxLineSpan;
    }

    private static int rotateWidth(Dimension dimension, double d2) {
        return (int)Math.round((double)dimension.width * Math.abs(Math.cos(d2)) + (double)dimension.height * Math.abs(Math.sin(d2)));
    }

    private static int rotateHeight(Dimension dimension, double d2) {
        return (int)Math.round((double)dimension.width * Math.abs(Math.sin(d2)) + (double)dimension.height * Math.abs(Math.cos(d2)));
    }

    public void setLineWrap(boolean bl) {
        boolean bl2 = this.isLineWrap();
        this.multiLine = bl;
        if (this.isLineWrap() != bl2) {
            this.firePropertyChange("lineWrap", bl2, this.isLineWrap());
            if (this.getForegroundPainter() != null) {
                ((AbstractPainter)this.getForegroundPainter()).setCacheable(!bl);
            }
        }
    }

    public boolean isLineWrap() {
        return this.multiLine;
    }

    public TextAlignment getTextAlignment() {
        return this.textAlignment;
    }

    public boolean isPaintBorderInsets() {
        return this.paintBorderInsets;
    }

    @Override
    public boolean isOpaque() {
        return this.painting ? false : super.isOpaque();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics graphics) {
        this.painted = true;
        if (this.painting || this.backgroundPainter == null && this.foregroundPainter == null) {
            super.paintComponent(graphics);
        } else {
            Object object;
            this.pWidth = this.getWidth();
            this.pHeight = this.getHeight();
            Insets insets = this.getInsets();
            if (this.backgroundPainter != null) {
                object = (Graphics2D)graphics.create();
                try {
                    if (!this.isPaintBorderInsets()) {
                        ((Graphics2D)object).translate(insets.left, insets.top);
                        this.pWidth = this.pWidth - insets.left - insets.right;
                        this.pHeight = this.pHeight - insets.top - insets.bottom;
                    }
                    this.backgroundPainter.paint((Graphics2D)object, this, this.pWidth, this.pHeight);
                }
                finally {
                    ((Graphics)object).dispose();
                }
            }
            if (this.foregroundPainter != null) {
                this.pWidth = this.getWidth() - insets.left - insets.right;
                this.pHeight = this.getHeight() - insets.top - insets.bottom;
                object = this.calculateT();
                double d2 = Math.sin(this.textRotation) * ((Point2D)object).getY() + Math.cos(this.textRotation) * ((Point2D)object).getX();
                double d3 = Math.sin(this.textRotation) * ((Point2D)object).getX() + Math.cos(this.textRotation) * ((Point2D)object).getY();
                double d4 = ((double)this.getWidth() - d2) / 2.0 + Math.sin(this.textRotation) * ((Point2D)object).getY();
                double d5 = ((double)this.getHeight() - d3) / 2.0;
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                if (insets != null) {
                    graphics2D.translate((double)insets.left + d4, (double)insets.top + d5);
                } else {
                    graphics2D.translate(d4, d5);
                }
                graphics2D.rotate(this.textRotation);
                this.painting = true;
                this.foregroundPainter.paint(graphics2D, this, this.pWidth, this.pHeight);
                graphics2D.dispose();
                this.painting = false;
                this.pWidth = 0;
                this.pHeight = 0;
            }
        }
    }

    private Point2D calculateT() {
        double d2 = this.getWidth();
        double d3 = this.getHeight();
        if (this.textRotation > 4.697 && this.textRotation < 4.727 || this.textRotation > 1.555 && this.textRotation < 1.585) {
            int n2 = this.pHeight;
            this.pHeight = this.pWidth;
            this.pWidth = n2;
            d2 = this.pWidth;
            d3 = this.pHeight;
        } else if (this.textRotation > -0.015 && this.textRotation < 0.015 || this.textRotation > 3.14 && this.textRotation < 3.143) {
            this.pHeight = this.getHeight();
            this.pWidth = this.getWidth();
        } else {
            this.dontIgnoreRepaint = false;
            double d4 = (double)Math.min(this.getHeight(), this.getWidth()) * Math.cos(0.7853981633974483);
            View view = (View)this.getClientProperty("html");
            if (view == null) {
                d3 = this.getFontMetrics(this.getFont()).getHeight();
                double d5 = ((double)this.getWidth() - Math.abs(d3 * Math.sin(this.textRotation))) / Math.abs(Math.cos(this.textRotation));
                double d6 = ((double)this.getHeight() - Math.abs(d3 * Math.cos(this.textRotation))) / Math.abs(Math.sin(this.textRotation));
                d2 = d5 < 0.0 ? d6 : (d6 > 0.0 ? Math.min(d5, d6) : d5);
            } else {
                float f2 = view.getPreferredSpan(0);
                float f3 = view.getPreferredSpan(1);
                double d7 = f2;
                double d8 = this.textRotation;
                boolean bl = false;
                while (!bl) {
                    while (f3 == view.getPreferredSpan(1)) {
                        view.setSize(f2 -= 10.0f, f3);
                    }
                    if ((double)f2 < d4 || (double)f3 > d4) {
                        f2 = f3 = (float)d4;
                        view.setSize(f2, 100000.0f);
                        break;
                    }
                    f3 = view.getPreferredSpan(1);
                    double d9 = ((double)this.getWidth() - Math.abs((double)f3 * Math.sin(d8))) / Math.abs(Math.cos(d8));
                    double d10 = ((double)this.getHeight() - Math.abs((double)f3 * Math.cos(d8))) / Math.abs(Math.sin(d8));
                    d7 = d9 < 0.0 ? d10 : (d10 > 0.0 ? Math.min(d9, d10) : d9);
                    if ((d7 -= 1.0) > (double)f2) {
                        view.setSize((float)d7, 10.0f * f3);
                        bl = true;
                        continue;
                    }
                    view.setSize((float)d7, 10.0f * f3);
                    if (view.getPreferredSpan(1) > f3) {
                        view.setSize(f2, 10.0f * f3);
                        continue;
                    }
                    f2 = (float)d7;
                    bl = true;
                }
                d2 = Math.floor(f2);
                d3 = f3;
            }
            this.pWidth = (int)d2;
            this.pHeight = (int)d3;
            this.dontIgnoreRepaint = true;
        }
        return new Point2D.Double(d2, d3);
    }

    @Override
    public void repaint() {
        if (!this.dontIgnoreRepaint) {
            return;
        }
        super.repaint();
    }

    @Override
    public void repaint(int n2, int n3, int n4, int n5) {
        if (!this.dontIgnoreRepaint) {
            return;
        }
        super.repaint(n2, n3, n4, n5);
    }

    @Override
    public void repaint(long l2) {
        if (!this.dontIgnoreRepaint) {
            return;
        }
        super.repaint(l2);
    }

    @Override
    public void repaint(long l2, int n2, int n3, int n4, int n5) {
        if (!this.dontIgnoreRepaint) {
            return;
        }
        super.repaint(l2, n2, n3, n4, n5);
    }

    @Override
    public int getHeight() {
        int n2 = super.getHeight();
        if (this.painting) {
            n2 = this.pHeight;
        }
        return n2;
    }

    @Override
    public int getWidth() {
        int n2 = super.getWidth();
        if (this.painting) {
            n2 = this.pWidth;
        }
        return n2;
    }

    protected MultiLineSupport getMultiLineSupport() {
        return new MultiLineSupport();
    }

    protected int getOccupiedWidth() {
        return this.occupiedWidth;
    }

    static class Renderer
    extends WrappedPlainView {
        JXLabel host;
        boolean invalidated = false;
        private float width;
        private float height;
        private View view;
        private ViewFactory factory;

        Renderer(JXLabel jXLabel, ViewFactory viewFactory, View view, boolean bl) {
            super(null, bl);
            this.factory = viewFactory;
            this.view = view;
            this.view.setParent(this);
            this.host = jXLabel;
            if (this.host.getVisibleRect().width == 0) {
                this.invalidated = true;
                return;
            }
            int n2 = this.host.getVisibleRect().width;
            this.setSize(jXLabel.getMaxLineSpan() > -1 ? (float)jXLabel.getMaxLineSpan() : (float)n2, this.host.getVisibleRect().height);
        }

        @Override
        protected void updateLayout(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, Shape shape) {
            if (shape != null) {
                this.preferenceChanged(null, true, true);
                Container container = this.getContainer();
                if (container != null) {
                    container.repaint();
                }
            }
        }

        @Override
        public void preferenceChanged(View view, boolean bl, boolean bl2) {
            if (this.host != null && this.host.painted) {
                this.host.revalidate();
                this.host.repaint();
            }
        }

        @Override
        public AttributeSet getAttributes() {
            return null;
        }

        @Override
        public void paint(Graphics graphics, Shape shape) {
            Rectangle rectangle = shape.getBounds();
            if (graphics.getClipBounds() == null) {
                graphics.setClip(rectangle);
                this.view.paint(graphics, shape);
                graphics.setClip(null);
            } else {
                this.view.paint(graphics, shape);
            }
        }

        @Override
        public void setParent(View view) {
            throw new Error("Can't set parent on root view");
        }

        @Override
        public int getViewCount() {
            return 1;
        }

        @Override
        public View getView(int n2) {
            return this.view;
        }

        @Override
        public Document getDocument() {
            return this.view == null ? null : this.view.getDocument();
        }

        @Override
        public void setSize(float f2, float f3) {
            if (this.host.maxLineSpan > 0) {
                f2 = Math.min(f2, (float)this.host.maxLineSpan);
            }
            if (f2 == this.width && f3 == this.height) {
                return;
            }
            this.width = (int)f2;
            this.height = (int)f3;
            this.view.setSize(f2, f3 == 0.0f ? 32767.0f : f3);
            if (this.height == 0.0f) {
                this.height = this.view.getPreferredSpan(1);
            }
        }

        @Override
        public float getPreferredSpan(int n2) {
            if (n2 == 0) {
                int n3;
                if (this.invalidated && (n3 = this.host.getVisibleRect().width) != 0) {
                    this.invalidated = false;
                    this.setSize(n3 - this.host.getOccupiedWidth(), this.host.getVisibleRect().height);
                }
                return this.width > 0.0f ? this.width : this.view.getPreferredSpan(n2);
            }
            return this.view.getPreferredSpan(n2);
        }

        @Override
        public Container getContainer() {
            return this.host;
        }

        @Override
        public ViewFactory getViewFactory() {
            return this.factory;
        }

        @Override
        public int getWidth() {
            return (int)this.width;
        }

        @Override
        public int getHeight() {
            return (int)this.height;
        }
    }

    static class BasicDocument
    extends DefaultStyledDocument {
        BasicDocument(Font font, Color color, TextAlignment textAlignment, float f2) {
            this.setFontAndColor(font, color);
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setAlignment(simpleAttributeSet, textAlignment.getValue());
            this.getStyle("default").addAttributes(simpleAttributeSet);
            simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setRightIndent(simpleAttributeSet, f2);
            this.getStyle("default").addAttributes(simpleAttributeSet);
        }

        private void setFontAndColor(Font font, Color color) {
            SimpleAttributeSet simpleAttributeSet;
            if (color != null) {
                simpleAttributeSet = new SimpleAttributeSet();
                StyleConstants.setForeground(simpleAttributeSet, color);
                this.getStyle("default").addAttributes(simpleAttributeSet);
            }
            if (font != null) {
                simpleAttributeSet = new SimpleAttributeSet();
                StyleConstants.setFontFamily(simpleAttributeSet, font.getFamily());
                this.getStyle("default").addAttributes(simpleAttributeSet);
                simpleAttributeSet = new SimpleAttributeSet();
                StyleConstants.setFontSize(simpleAttributeSet, font.getSize());
                this.getStyle("default").addAttributes(simpleAttributeSet);
                simpleAttributeSet = new SimpleAttributeSet();
                StyleConstants.setBold(simpleAttributeSet, font.isBold());
                this.getStyle("default").addAttributes(simpleAttributeSet);
                simpleAttributeSet = new SimpleAttributeSet();
                StyleConstants.setItalic(simpleAttributeSet, font.isItalic());
                this.getStyle("default").addAttributes(simpleAttributeSet);
            }
            simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setSpaceAbove(simpleAttributeSet, 0.0f);
            this.getStyle("default").addAttributes(simpleAttributeSet);
        }
    }

    private static class BasicViewFactory
    implements ViewFactory {
        private BasicViewFactory() {
        }

        @Override
        public View create(Element element) {
            String string = element.getName();
            View view = null;
            if (string == null) {
                view = new LabelView(element);
            } else if (string.equals("content")) {
                view = new LabelView(element);
            } else if (string.equals("paragraph")) {
                view = new ParagraphView(element);
            } else if (string.equals("section")) {
                view = new BoxView(element, 1);
            } else if (string.equals("component")) {
                view = new ComponentView(element);
            } else if (string.equals("icon")) {
                view = new IconView(element);
            }
            return view;
        }
    }

    public static class MultiLineSupport
    implements PropertyChangeListener {
        private static ViewFactory basicViewFactory;
        private static BasicEditorKit basicFactory;

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            JXLabel jXLabel = (JXLabel)propertyChangeEvent.getSource();
            if ("ancestor".equals(string)) {
                jXLabel.dontIgnoreRepaint = true;
            }
            if (jXLabel.isLineWrap()) {
                if ("font".equals(string) || "foreground".equals(string) || "maxLineSpan".equals(string) || "textAlignment".equals(string) || "icon".equals(string) || "iconTextGap".equals(string)) {
                    if (propertyChangeEvent.getOldValue() != null && !MultiLineSupport.isHTML(jXLabel.getText())) {
                        MultiLineSupport.updateRenderer(jXLabel);
                    }
                } else if ("text".equals(string)) {
                    if (MultiLineSupport.isHTML((String)propertyChangeEvent.getOldValue()) && propertyChangeEvent.getNewValue() != null && !MultiLineSupport.isHTML((String)propertyChangeEvent.getNewValue())) {
                        if (jXLabel.getClientProperty("washtml") == null && jXLabel.getClientProperty("html") != null) {
                            jXLabel.putClientProperty("washtml", jXLabel.getClientProperty("html"));
                        }
                        jXLabel.putClientProperty("html", MultiLineSupport.createView(jXLabel));
                    } else if (!MultiLineSupport.isHTML((String)propertyChangeEvent.getOldValue()) && propertyChangeEvent.getNewValue() != null && !MultiLineSupport.isHTML((String)propertyChangeEvent.getNewValue())) {
                        MultiLineSupport.updateRenderer(jXLabel);
                    } else {
                        MultiLineSupport.restoreHtmlRenderer(jXLabel);
                    }
                } else if ("lineWrap".equals(string) && !MultiLineSupport.isHTML(jXLabel.getText())) {
                    jXLabel.putClientProperty("html", MultiLineSupport.createView(jXLabel));
                }
            } else if ("lineWrap".equals(string) && !((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                MultiLineSupport.restoreHtmlRenderer(jXLabel);
            }
        }

        private static void restoreHtmlRenderer(JXLabel jXLabel) {
            Object object = jXLabel.getClientProperty("html");
            if (object == null || object instanceof Renderer) {
                jXLabel.putClientProperty("html", jXLabel.getClientProperty("washtml"));
            }
        }

        private static boolean isHTML(String string) {
            return string != null && string.toLowerCase().startsWith("<html>");
        }

        public static View createView(JXLabel jXLabel) {
            BasicEditorKit basicEditorKit = MultiLineSupport.getFactory();
            float f2 = 0.0f;
            if (jXLabel.getIcon() != null && jXLabel.getHorizontalTextPosition() != 0) {
                f2 = jXLabel.getIcon().getIconWidth() + jXLabel.getIconTextGap();
            }
            Document document = basicEditorKit.createDefaultDocument(jXLabel.getFont(), jXLabel.getForeground(), jXLabel.getTextAlignment(), f2);
            StringReader stringReader = new StringReader(jXLabel.getText() == null ? "" : jXLabel.getText());
            try {
                basicEditorKit.read(stringReader, document, 0);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ViewFactory viewFactory = basicEditorKit.getViewFactory();
            View view = viewFactory.create(document.getDefaultRootElement());
            Renderer renderer = new Renderer(jXLabel, viewFactory, view, true);
            return renderer;
        }

        public static void updateRenderer(JXLabel jXLabel) {
            View view = null;
            View view2 = (View)jXLabel.getClientProperty("html");
            if (view2 == null || view2 instanceof Renderer) {
                view = MultiLineSupport.createView(jXLabel);
            }
            if (view != view2 && view2 != null) {
                for (int i2 = 0; i2 < view2.getViewCount(); ++i2) {
                    view2.getView(i2).setParent(null);
                }
            }
            jXLabel.putClientProperty("html", view);
        }

        private static BasicEditorKit getFactory() {
            if (basicFactory == null) {
                basicViewFactory = new BasicViewFactory();
                basicFactory = new BasicEditorKit();
            }
            return basicFactory;
        }

        private static class BasicEditorKit
        extends StyledEditorKit {
            private BasicEditorKit() {
            }

            public Document createDefaultDocument(Font font, Color color, TextAlignment textAlignment, float f2) {
                BasicDocument basicDocument = new BasicDocument(font, color, textAlignment, f2);
                basicDocument.setAsynchronousLoadPriority(Integer.MAX_VALUE);
                return basicDocument;
            }

            @Override
            public ViewFactory getViewFactory() {
                return basicViewFactory;
            }
        }
    }

    protected static interface IValue {
    }

    public static enum TextAlignment implements IValue
    {
        LEFT(0),
        CENTER(1),
        RIGHT(2),
        JUSTIFY(3);

        private int value;

        private TextAlignment(int n3) {
            this.value = n3;
        }

        public int getValue() {
            return this.value;
        }
    }
}

