/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.lang.ref.SoftReference;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import org.jdesktop.swingx.JXPanel;

public class JXImagePanel
extends JXPanel {
    private static final Logger LOG = Logger.getLogger(JXImagePanel.class.getName());
    private SoftReference<Image> img;
    private static final ExecutorService service = Executors.newFixedThreadPool(5);

    public void setImage(Image image) {
        if (image != this.img.get()) {
            Image image2 = this.img.get();
            this.img = new SoftReference<Image>(image);
            this.firePropertyChange("image", image2, this.img);
            this.invalidate();
            this.repaint();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Image image;
        if (!this.isPreferredSizeSet() && this.img != null && (image = this.img.get()) != null) {
            int n2 = image.getWidth(null);
            int n3 = image.getHeight(null);
            if (n2 == -1 || n3 == -1) {
                return super.getPreferredSize();
            }
            Insets insets = this.getInsets();
            return new Dimension(n2 += insets.left + insets.right, n3 += insets.top + insets.bottom);
        }
        return super.getPreferredSize();
    }
}

