/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdesktop.swingx.error.ErrorReporter;
import org.jdesktop.swingx.plaf.ErrorPaneAddon;
import org.jdesktop.swingx.plaf.ErrorPaneUI;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

public class JXErrorPane
extends JComponent {
    private ErrorInfo errorInfo = new ErrorInfo("Error", "Normally this place contains problem description.\n You see this text because one of the following reasons:\n * Either it is a test\n * Developer have not provided error details\n * This error message was invoked unexpectedly and there are no more details available", null, null, null, null, null);
    private Icon icon;
    private ErrorReporter reporter;

    public JXErrorPane() {
        this.updateUI();
    }

    @Override
    public ErrorPaneUI getUI() {
        return (ErrorPaneUI)this.ui;
    }

    public void setUI(ErrorPaneUI errorPaneUI) {
        super.setUI(errorPaneUI);
    }

    @Override
    public String getUIClassID() {
        return "ErrorPaneUI";
    }

    @Override
    public void updateUI() {
        this.setUI((ErrorPaneUI)LookAndFeelAddons.getUI(this, ErrorPaneUI.class));
    }

    public void setErrorInfo(ErrorInfo errorInfo) {
        if (errorInfo == null) {
            throw new NullPointerException("ErrorInfo can't be null. Provide valid ErrorInfo object.");
        }
        ErrorInfo errorInfo2 = this.errorInfo;
        this.errorInfo = errorInfo;
        this.firePropertyChange("errorInfo", errorInfo2, this.errorInfo);
    }

    public ErrorInfo getErrorInfo() {
        return this.errorInfo;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public ErrorReporter getErrorReporter() {
        return this.reporter;
    }

    public static void showDialog(Component component, ErrorInfo errorInfo) {
        JXErrorPane jXErrorPane = new JXErrorPane();
        jXErrorPane.setErrorInfo(errorInfo);
        JXErrorPane.showDialog(component, jXErrorPane);
    }

    public static void showDialog(final Component component, final JXErrorPane jXErrorPane) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                JDialog jDialog = JXErrorPane.createDialog(component, jXErrorPane);
                jDialog.setVisible(true);
            }
        };
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            runnable.run();
        }
    }

    public static JDialog createDialog(Component component, JXErrorPane jXErrorPane) {
        JDialog jDialog = jXErrorPane.getUI().getErrorDialog(component);
        if (component != null) {
            jXErrorPane.applyComponentOrientation(component.getComponentOrientation());
        } else {
            jXErrorPane.applyComponentOrientation(jDialog.getComponentOrientation());
        }
        jDialog.setDefaultCloseOperation(2);
        jDialog.pack();
        jDialog.setLocationRelativeTo(component);
        return jDialog;
    }

    static {
        LookAndFeelAddons.contribute(new ErrorPaneAddon());
    }
}

