/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ActionMap;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.jdesktop.swingx.UIAction;
import org.jdesktop.swingx.action.ActionManager;
import org.jdesktop.swingx.action.Targetable;
import org.jdesktop.swingx.action.TargetableSupport;
import org.jdesktop.swingx.search.SearchFactory;
import org.jdesktop.swingx.search.Searchable;

public class JXEditorPane
extends JEditorPane
implements Targetable {
    private static final Logger LOG = Logger.getLogger(JXEditorPane.class.getName());
    private UndoableEditListener undoHandler;
    private UndoManager undoManager;
    private CaretListener caretHandler;
    private JComboBox selector;
    private TargetableSupport targetSupport = new TargetableSupport(this);
    private Searchable searchable;

    public JXEditorPane() {
        this.init();
    }

    private void init() {
        this.setEditorKitForContentType("text/html", new SloppyHTMLEditorKit());
        this.addPropertyChangeListener(new PropertyHandler());
        this.getDocument().addUndoableEditListener(this.getUndoableEditListener());
        this.initActions();
    }

    UndoableEditListener getUndoableEditListener() {
        if (this.undoHandler == null) {
            this.undoHandler = new UndoHandler();
            this.undoManager = new UndoManager();
        }
        return this.undoHandler;
    }

    @Override
    public void setEditorKit(EditorKit editorKit) {
        super.setEditorKit(editorKit);
        if (editorKit instanceof StyledEditorKit) {
            if (this.caretHandler == null) {
                this.caretHandler = new CaretHandler();
            }
            this.addCaretListener(this.caretHandler);
        }
    }

    protected void initActions() {
        ActionMap actionMap = this.getActionMap();
        actionMap.put("find", new Actions("find"));
        actionMap.put("undo", new Actions("undo"));
        actionMap.put("redo", new Actions("redo"));
        actionMap.put("cut", new Actions("cut"));
        actionMap.put("copy", new Actions("copy"));
        actionMap.put("paste", new Actions("paste"));
        KeyStroke keyStroke = SearchFactory.getInstance().getSearchAccelerator();
        this.getInputMap(1).put(keyStroke, "find");
    }

    private void updateActionState() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ActionManager actionManager = ActionManager.getInstance();
                actionManager.setEnabled("undo", JXEditorPane.this.undoManager.canUndo());
                actionManager.setEnabled("redo", JXEditorPane.this.undoManager.canRedo());
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    @Override
    public void paste() {
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        if (transferable != null) {
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            try {
                for (int i2 = 0; i2 < dataFlavorArray.length; ++i2) {
                    if (!String.class.equals(dataFlavorArray[i2].getRepresentationClass())) continue;
                    Object object = transferable.getTransferData(dataFlavorArray[i2]);
                    if (!dataFlavorArray[i2].isMimeTypeEqual("text/plain")) continue;
                    this.replaceSelection(object.toString());
                    break;
                }
            }
            catch (Exception exception) {
                LOG.log(Level.FINE, "What can produce a problem with data flavor?", exception);
            }
        }
    }

    private void find() {
        SearchFactory.getInstance().showFindInput(this, this.getSearchable());
    }

    public Searchable getSearchable() {
        if (this.searchable == null) {
            this.searchable = new DocumentSearchable();
        }
        return this.searchable;
    }

    private static final class SloppyHTMLEditorKit
    extends HTMLEditorKit {
        private SloppyHTMLEditorKit() {
        }

        @Override
        public void read(Reader reader, Document document, int n2) throws IOException, BadLocationException {
            int n3;
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[1024];
            while ((n3 = reader.read(cArray)) != -1) {
                stringBuffer.append(cArray, 0, n3);
            }
            StringReader stringReader = new StringReader(stringBuffer.toString().replaceAll("/>", ">"));
            super.read(stringReader, document, n2);
        }
    }

    private class CaretHandler
    implements CaretListener {
        private CaretHandler() {
        }

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            StyledDocument styledDocument = (StyledDocument)JXEditorPane.this.getDocument();
            int n2 = caretEvent.getDot();
            n2 = n2 > 0 ? n2 - 1 : n2;
            Element element = styledDocument.getCharacterElement(n2);
            AttributeSet attributeSet = element.getAttributes();
            ActionManager actionManager = ActionManager.getInstance();
            actionManager.setSelected("font-bold", StyleConstants.isBold(attributeSet));
            actionManager.setSelected("font-italic", StyleConstants.isItalic(attributeSet));
            actionManager.setSelected("font-underline", StyleConstants.isUnderline(attributeSet));
            element = styledDocument.getParagraphElement(n2);
            attributeSet = element.getAttributes();
            if (JXEditorPane.this.selector != null) {
                JXEditorPane.this.selector.setSelectedItem(attributeSet.getAttribute(StyleConstants.NameAttribute));
            }
            switch (StyleConstants.getAlignment(attributeSet)) {
                case 0: {
                    actionManager.setSelected("left-justify", true);
                    break;
                }
                case 1: {
                    actionManager.setSelected("center-justify", true);
                    break;
                }
                case 2: {
                    actionManager.setSelected("right-justify", true);
                }
            }
        }
    }

    public class DocumentSearchable
    implements Searchable {
        int lastFoundIndex = -1;
        MatchResult lastMatchResult;
        String lastRegEx;

        @Override
        public int search(Pattern pattern) {
            return this.search(pattern, -1);
        }

        public int search(Pattern pattern, int n2) {
            return this.search(pattern, n2, false);
        }

        @Override
        public int search(Pattern pattern, int n2, boolean bl) {
            int n3;
            if (pattern == null || JXEditorPane.this.getDocument().getLength() == 0 || n2 > -1 && JXEditorPane.this.getDocument().getLength() < n2) {
                this.updateStateAfterNotFound();
                return -1;
            }
            int n4 = n2;
            if (this.maybeExtendedMatch(n2)) {
                if (this.foundExtendedMatch(pattern, n4)) {
                    return this.lastFoundIndex;
                }
                ++n4;
            }
            if (bl) {
                n4 = 0;
                n3 = n2 < 0 ? JXEditorPane.this.getDocument().getLength() - 1 : -1 + n2;
            } else {
                if (n4 < 0) {
                    n4 = 0;
                }
                n3 = JXEditorPane.this.getDocument().getLength() - n4;
            }
            Segment segment = new Segment();
            try {
                JXEditorPane.this.getDocument().getText(n4, n3, segment);
            }
            catch (BadLocationException badLocationException) {
                LOG.log(Level.FINE, "this should not happen (calculated the valid start/length) ", badLocationException);
            }
            Matcher matcher = pattern.matcher(segment.toString());
            MatchResult matchResult = this.getMatchResult(matcher, !bl);
            if (matchResult != null) {
                this.updateStateAfterFound(matchResult, n4);
            } else {
                this.updateStateAfterNotFound();
            }
            return this.lastFoundIndex;
        }

        private boolean foundExtendedMatch(Pattern pattern, int n2) {
            if (pattern.pattern().equals(this.lastRegEx)) {
                return false;
            }
            int n3 = JXEditorPane.this.getDocument().getLength() - n2;
            Segment segment = new Segment();
            try {
                JXEditorPane.this.getDocument().getText(n2, n3, segment);
            }
            catch (BadLocationException badLocationException) {
                LOG.log(Level.FINE, "this should not happen (calculated the valid start/length) ", badLocationException);
            }
            Matcher matcher = pattern.matcher(segment.toString());
            MatchResult matchResult = this.getMatchResult(matcher, true);
            if (matchResult != null && matchResult.start() == 0 && !this.lastMatchResult.group().equals(matchResult.group())) {
                this.updateStateAfterFound(matchResult, n2);
                return true;
            }
            return false;
        }

        private boolean maybeExtendedMatch(int n2) {
            return n2 >= 0 && n2 == this.lastFoundIndex;
        }

        private int updateStateAfterFound(MatchResult matchResult, int n2) {
            int n3 = matchResult.end() + n2;
            int n4 = matchResult.start() + n2;
            JXEditorPane.this.select(n4, n3);
            JXEditorPane.this.getCaret().setSelectionVisible(true);
            this.lastFoundIndex = n4;
            this.lastMatchResult = matchResult;
            this.lastRegEx = ((Matcher)this.lastMatchResult).pattern().pattern();
            return n4;
        }

        private MatchResult getMatchResult(Matcher matcher, boolean bl) {
            MatchResult matchResult = null;
            while (matcher.find()) {
                matchResult = matcher.toMatchResult();
                if (!bl) continue;
                break;
            }
            return matchResult;
        }

        private void updateStateAfterNotFound() {
            this.lastFoundIndex = -1;
            this.lastMatchResult = null;
            this.lastRegEx = null;
            JXEditorPane.this.setCaretPosition(JXEditorPane.this.getSelectionEnd());
        }
    }

    private class Actions
    extends UIAction {
        Actions(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.getName();
            if ("find".equals(string)) {
                JXEditorPane.this.find();
            } else if ("undo".equals(string)) {
                try {
                    JXEditorPane.this.undoManager.undo();
                }
                catch (CannotUndoException cannotUndoException) {
                    LOG.info("Could not undo");
                }
                JXEditorPane.this.updateActionState();
            } else if ("redo".equals(string)) {
                try {
                    JXEditorPane.this.undoManager.redo();
                }
                catch (CannotRedoException cannotRedoException) {
                    LOG.info("Could not redo");
                }
                JXEditorPane.this.updateActionState();
            } else if ("cut".equals(string)) {
                ActionMap actionMap = JXEditorPane.this.getActionMap();
                actionMap.remove("cut");
                JXEditorPane.this.cut();
                actionMap.put("cut", this);
            } else if ("copy".equals(string)) {
                ActionMap actionMap = JXEditorPane.this.getActionMap();
                actionMap.remove("copy");
                JXEditorPane.this.copy();
                actionMap.put("copy", this);
            } else if ("paste".equals(string)) {
                ActionMap actionMap = JXEditorPane.this.getActionMap();
                actionMap.remove("paste");
                JXEditorPane.this.paste();
                actionMap.put("paste", this);
            } else {
                LOG.fine("ActionHandled: " + string);
            }
        }

        @Override
        public boolean isEnabled(Object object) {
            boolean bl;
            String string = this.getName();
            if ("undo".equals(string)) {
                return JXEditorPane.this.isEditable() && JXEditorPane.this.undoManager.canUndo();
            }
            if ("redo".equals(string)) {
                return JXEditorPane.this.isEditable() && JXEditorPane.this.undoManager.canRedo();
            }
            if ("paste".equals(string)) {
                if (!JXEditorPane.this.isEditable()) {
                    return false;
                }
                boolean bl2 = false;
                try {
                    bl2 = JXEditorPane.this.getToolkit().getSystemClipboard().getContents(null) != null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return bl2;
            }
            boolean bl3 = bl = JXEditorPane.this.getSelectionEnd() - JXEditorPane.this.getSelectionStart() > 0;
            if ("cut".equals(string)) {
                return JXEditorPane.this.isEditable() && bl;
            }
            if ("copy".equals(string)) {
                return bl;
            }
            if ("find".equals(string)) {
                return JXEditorPane.this.getDocument().getLength() > 0;
            }
            return true;
        }
    }

    private class UndoHandler
    implements UndoableEditListener {
        private UndoHandler() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            JXEditorPane.this.undoManager.addEdit(undoableEditEvent.getEdit());
            JXEditorPane.this.updateActionState();
        }
    }

    private class PropertyHandler
    implements PropertyChangeListener {
        private PropertyHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("document")) {
                Document document = (Document)propertyChangeEvent.getOldValue();
                if (document != null) {
                    document.removeUndoableEditListener(JXEditorPane.this.getUndoableEditListener());
                }
                if ((document = (Document)propertyChangeEvent.getNewValue()) != null) {
                    document.addUndoableEditListener(JXEditorPane.this.getUndoableEditListener());
                }
            }
        }
    }
}

