/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.plaf.basic.BasicOptionPaneUI;
import org.jdesktop.swingx.action.BoundAction;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.UIManagerExt;

public class JXDialog
extends JDialog {
    protected JComponent content;

    public JXDialog(Frame frame, JComponent jComponent) {
        super(frame);
        this.setContent(jComponent);
    }

    public JXDialog(Dialog dialog, JComponent jComponent) {
        super(dialog);
        this.setContent(jComponent);
    }

    private void setContent(JComponent jComponent) {
        Action action;
        if (this.content != null) {
            throw new IllegalStateException("content must not be set more than once");
        }
        this.initActions();
        Action action2 = jComponent.getActionMap().get("close");
        if (action2 != null) {
            this.putAction("close", action2);
        }
        if ((action = jComponent.getActionMap().get("execute")) != null) {
            this.putAction("execute", action);
        }
        this.content = jComponent;
        this.build();
        this.setTitleFromContent();
    }

    protected void setTitleFromContent() {
        if (this.content == null) {
            return;
        }
        this.setTitle(this.content.getName());
    }

    private void build() {
        Box box = new Box(3);
        box.add(this.content);
        JComponent jComponent = this.createButtonPanel();
        box.add(jComponent);
        box.setBorder(BorderFactory.createEmptyBorder(14, 14, 14, 14));
        this.add(box);
    }

    @Override
    public void setVisible(boolean bl) {
        if (this.content == null) {
            throw new IllegalStateException("content must be built before showing the dialog");
        }
        super.setVisible(bl);
    }

    @Override
    public void setLocale(Locale locale) {
        if (this.content != null) {
            this.content.setLocale(locale);
            this.updateLocaleState(locale);
        }
        super.setLocale(locale);
    }

    protected void updateLocaleState(Locale locale) {
        this.setTitleFromContent();
        for (Object object : this.getRootPane().getActionMap().allKeys()) {
            String string;
            if (!(object instanceof String)) continue;
            Action action = this.content.getActionMap().get(object);
            Action action2 = this.getAction(object);
            if (action2.equals(action) || object.equals(string = this.getUIString((String)object, locale))) continue;
            action2.putValue("Name", string);
        }
    }

    private void initActions() {
        Action action = this.createCloseAction();
        this.putAction("close", action);
        this.putAction("execute", action);
    }

    private Action createCloseAction() {
        String string = this.getUIString("close");
        BoundAction boundAction = new BoundAction(string, "close");
        boundAction.registerCallback(this, "doClose");
        return boundAction;
    }

    protected JComponent createButtonPanel() {
        JPanel jPanel = new JPanel(new BasicOptionPaneUI.ButtonAreaLayout(true, 6)){

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        jPanel.setBorder(BorderFactory.createEmptyBorder(9, 0, 0, 0));
        Action action = this.getAction("execute");
        Action action2 = this.getAction("close");
        JButton jButton = new JButton(action);
        jPanel.add(jButton);
        if (action != action2) {
            jPanel.add(new JButton(action2));
        }
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0, false);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(27, 0, false);
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.put(keyStroke, "execute");
        inputMap.put(keyStroke2, "close");
        this.getRootPane().setDefaultButton(jButton);
        return jPanel;
    }

    private void putAction(Object object, Action action) {
        this.getRootPane().getActionMap().put(object, action);
    }

    private Action getAction(Object object) {
        return this.getRootPane().getActionMap().get(object);
    }

    protected String getUIString(String string) {
        return this.getUIString(string, this.getLocale());
    }

    protected String getUIString(String string, Locale locale) {
        String string2 = UIManagerExt.getString("XDialog." + string, locale);
        return string2 != null ? string2 : string;
    }

    static {
        LookAndFeelAddons.getAddon();
    }
}

