/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyVetoException;
import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.text.DefaultFormatterFactory;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.calendar.DatePickerFormatter;
import org.jdesktop.swingx.painter.MattePainter;
import org.jdesktop.swingx.plaf.DatePickerAddon;
import org.jdesktop.swingx.plaf.DatePickerUI;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.util.Contract;

public class JXDatePicker
extends JComponent {
    private static final Logger LOG = Logger.getLogger(JXDatePicker.class.getName());
    private static final DateFormat[] EMPTY_DATE_FORMATS;
    private JFormattedTextField _dateField;
    private JPanel _linkPanel;
    private Date linkDate;
    private JXMonthView _monthView;
    private boolean editable;
    protected boolean lightWeightPopupEnabled;
    private Date date;

    public void setDate(Date date) {
        try {
            date = this.getUI().getSelectableDate(date);
        }
        catch (PropertyVetoException propertyVetoException) {
            return;
        }
        Date date2 = this.getDate();
        this.date = date;
        this.firePropertyChange("date", date2, this.getDate());
    }

    public Date getDate() {
        return this.date;
    }

    @Override
    public DatePickerUI getUI() {
        return (DatePickerUI)this.ui;
    }

    public void setFormats(DateFormat ... dateFormatArray) {
        if (dateFormatArray != null) {
            Contract.asNotNull(dateFormatArray, "the array of formats must not contain null elements");
        }
        DateFormat[] dateFormatArray2 = this.getFormats();
        this._dateField.setFormatterFactory(new DefaultFormatterFactory(new DatePickerFormatter(dateFormatArray, this.getLocale())));
        this.firePropertyChange("formats", dateFormatArray2, this.getFormats());
    }

    public DateFormat[] getFormats() {
        JFormattedTextField.AbstractFormatter abstractFormatter;
        JFormattedTextField.AbstractFormatterFactory abstractFormatterFactory = this._dateField.getFormatterFactory();
        if (abstractFormatterFactory != null && (abstractFormatter = abstractFormatterFactory.getFormatter(this._dateField)) instanceof DatePickerFormatter) {
            return ((DatePickerFormatter)abstractFormatter).getFormats();
        }
        return EMPTY_DATE_FORMATS;
    }

    public JXMonthView getMonthView() {
        return this._monthView;
    }

    public TimeZone getTimeZone() {
        return this._monthView.getTimeZone();
    }

    public Date getLinkDay() {
        return this.linkDate;
    }

    public void setLinkDay(Date date) {
        Format[] formatArray;
        this.linkDate = date;
        for (Format format : formatArray = this.getLinkFormat().getFormatsByArgumentIndex()) {
            if (!(format instanceof DateFormat)) continue;
            ((DateFormat)format).setTimeZone(this.getTimeZone());
        }
        this.setLinkPanel(new TodayPanel());
    }

    protected void setLinkFormat(MessageFormat messageFormat) {
        throw new InternalError("Badly shrinked");
    }

    protected MessageFormat getLinkFormat() {
        throw new InternalError("Badly shrinked");
    }

    private void updateLinkFormat() {
        String string = UIManagerExt.getString("JXDatePicker.linkFormat", this.getLocale());
        if (string != null) {
            this.setLinkFormat(new MessageFormat(string));
        } else {
            this.setLinkFormat(new MessageFormat("{0,date, dd MMMM yyyy}"));
        }
    }

    public JPanel getLinkPanel() {
        return this._linkPanel;
    }

    public void setLinkPanel(JPanel jPanel) {
        JPanel jPanel2 = this._linkPanel;
        this._linkPanel = jPanel;
        this.firePropertyChange("linkPanel", jPanel2, this._linkPanel);
    }

    public JFormattedTextField getEditor() {
        return this._dateField;
    }

    public void setEditor(JFormattedTextField jFormattedTextField) {
        Contract.asNotNull(jFormattedTextField, "editor must not be null");
        JFormattedTextField jFormattedTextField2 = this._dateField;
        this._dateField = jFormattedTextField;
        this.firePropertyChange("editor", jFormattedTextField2, this._dateField);
    }

    public void commitEdit() throws ParseException {
        this._dateField.commitEdit();
        this.fireActionPerformed("datePickerCommit");
    }

    public void cancelEdit() {
        this._dateField.setValue(this._dateField.getValue());
        this.fireActionPerformed("datePickerCancel");
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isLightWeightPopupEnabled() {
        return this.lightWeightPopupEnabled;
    }

    protected void fireActionPerformed(String string) {
        throw new InternalError("Badly shrinked");
    }

    static {
        LookAndFeelAddons.contribute(new DatePickerAddon());
        EMPTY_DATE_FORMATS = new DateFormat[0];
    }

    private final class TodayPanel
    extends JXPanel {
        private TodayAction todayAction;
        private JXHyperlink todayLink;

        TodayPanel() {
            super(new FlowLayout());
            this.setBackgroundPainter(new MattePainter(new GradientPaint(0.0f, 0.0f, new Color(238, 238, 238), 0.0f, 1.0f, Color.WHITE)));
            this.todayAction = new TodayAction();
            this.todayLink = new JXHyperlink(this.todayAction);
            this.todayLink.addMouseListener(this.createDoubleClickListener());
            Color color = new Color(16, 66, 104);
            this.todayLink.setUnclickedColor(color);
            this.todayLink.setClickedColor(color);
            this.add(this.todayLink);
        }

        private MouseListener createDoubleClickListener() {
            MouseAdapter mouseAdapter = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() != 2) {
                        return;
                    }
                    ((TodayPanel)TodayPanel.this).todayAction.select = true;
                }
            };
            return mouseAdapter;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            graphics.setColor(new Color(187, 187, 187));
            graphics.drawLine(0, 0, this.getWidth(), 0);
            graphics.setColor(new Color(221, 221, 221));
            graphics.drawLine(0, 1, this.getWidth(), 1);
        }

        @Override
        public void setLocale(Locale locale) {
            super.setLocale(locale);
            JXDatePicker.this.updateLinkFormat();
            this.todayLink.setText(JXDatePicker.this.getLinkFormat().format(new Object[]{JXDatePicker.this.getLinkDay()}));
        }

        private final class TodayAction
        extends AbstractAction {
            boolean select;

            TodayAction() {
                super(JXDatePicker.this.getLinkFormat().format(new Object[]{JXDatePicker.this.getLinkDay()}));
                Calendar calendar = JXDatePicker.this._monthView.getCalendar();
                calendar.setTime(JXDatePicker.this.getLinkDay());
                this.putValue("Name", JXDatePicker.this.getLinkFormat().format(new Object[]{calendar.getTime()}));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = this.select ? "commitHome" : "navigateHome";
                this.select = false;
                Action action = TodayPanel.this.getActionMap().get(string);
                if (action != null && action.isEnabled()) {
                    action.actionPerformed(null);
                }
            }
        }
    }
}

