/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import org.jdesktop.swingx.HorizontalLayout;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.VerticalLayout;

public class JXCollapsiblePane
extends JXPanel {
    private boolean collapsed = false;
    private Direction direction = Direction.UP;
    private Timer animateTimer;
    private AnimationListener animator;
    private int currentDimension = -1;
    private WrapperContainer wrapper;
    private boolean useAnimation = true;
    private AnimationParams animationParams;

    public JXCollapsiblePane() {
        this(Direction.UP, new BorderLayout(0, 0));
    }

    public JXCollapsiblePane(Direction direction, LayoutManager layoutManager) {
        super.setLayout(layoutManager);
        this.direction = direction;
        this.animator = new AnimationListener();
        this.setAnimationParams(new AnimationParams(30, 8, 0.01f, 1.0f));
        JXPanel jXPanel = new JXPanel();
        this.setContentPane(jXPanel);
        this.setDirection(direction);
        this.getActionMap().put("toggle", new ToggleAction());
    }

    public void setContentPane(Container container) {
        if (container == null) {
            throw new IllegalArgumentException("Content pane can't be null");
        }
        if (this.wrapper != null) {
            assert (super.getComponent(0) == this.wrapper);
            super.remove(0);
        }
        this.wrapper = new WrapperContainer(container);
        this.wrapper.collapsedState = this.isCollapsed();
        super.addImpl(this.wrapper, "Center", -1);
    }

    public Container getContentPane() {
        if (this.wrapper == null) {
            return null;
        }
        return (Container)this.wrapper.getView();
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
        if (this.wrapper != null) {
            this.getContentPane().setLayout(layoutManager);
        }
    }

    @Override
    protected void addImpl(Component component, Object object, int n2) {
        this.getContentPane().add(component, object, n2);
    }

    @Override
    public void remove(Component component) {
        this.getContentPane().remove(component);
    }

    @Override
    public void remove(int n2) {
        this.getContentPane().remove(n2);
    }

    @Override
    public void removeAll() {
        this.getContentPane().removeAll();
    }

    public void setAnimated(boolean bl) {
        if (bl != this.useAnimation) {
            this.useAnimation = bl;
            this.firePropertyChange("animated", !this.useAnimation, this.useAnimation);
        }
    }

    public boolean isAnimated() {
        return this.useAnimation;
    }

    public void setDirection(Direction direction) {
        if (this.animateTimer.isRunning()) {
            throw new IllegalStateException("cannot be change direction while collapsing.");
        }
        Direction direction2 = this.getDirection();
        this.direction = direction;
        if (direction.isVertical()) {
            this.getContentPane().setLayout(new VerticalLayout(2));
        } else {
            this.getContentPane().setLayout(new HorizontalLayout(2));
        }
        this.firePropertyChange("direction", (Object)direction2, (Object)this.getDirection());
    }

    public Direction getDirection() {
        return this.direction;
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void setCollapsed(boolean bl) {
        if (this.collapsed != bl) {
            this.collapsed = bl;
            if (this.isAnimated()) {
                if (this.collapsed) {
                    int n2 = this.direction.isVertical() ? this.wrapper.getHeight() : this.wrapper.getWidth();
                    this.setAnimationParams(new AnimationParams(30, Math.max(8, n2 / 10), 1.0f, 0.01f));
                    this.animator.reinit(n2, 0);
                    this.animateTimer.start();
                } else {
                    int n3 = this.direction.isVertical() ? this.wrapper.getHeight() : this.wrapper.getWidth();
                    int n4 = this.direction.isVertical() ? this.getContentPane().getPreferredSize().height : this.getContentPane().getPreferredSize().width;
                    int n5 = Math.max(8, n4 / 10);
                    this.setAnimationParams(new AnimationParams(30, n5, 0.01f, 1.0f));
                    this.animator.reinit(n3, n4);
                    this.animateTimer.start();
                }
            } else {
                this.wrapper.collapsedState = this.collapsed;
                this.revalidate();
            }
            this.repaint();
            this.firePropertyChange("collapsed", !this.collapsed, this.collapsed);
        }
    }

    @Override
    public Border getBorder() {
        if (this.getContentPane() instanceof JComponent) {
            return ((JComponent)this.getContentPane()).getBorder();
        }
        return null;
    }

    @Override
    public void setBorder(Border border) {
        if (this.getContentPane() instanceof JComponent) {
            ((JComponent)this.getContentPane()).setBorder(border);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void setMinimumSize(Dimension dimension) {
        this.getContentPane().setMinimumSize(dimension);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = this.getContentPane().getPreferredSize();
        if (this.currentDimension != -1) {
            if (this.direction.isVertical()) {
                dimension.height = this.currentDimension;
            } else {
                dimension.width = this.currentDimension;
            }
        } else if (this.wrapper.collapsedState) {
            if (this.direction.isVertical()) {
                dimension.height = 0;
            } else {
                dimension.width = 0;
            }
        }
        return dimension;
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        this.getContentPane().setPreferredSize(dimension);
    }

    private void setAnimationParams(AnimationParams animationParams) {
        if (animationParams == null) {
            throw new IllegalArgumentException("params can't be null");
        }
        if (this.animateTimer != null) {
            this.animateTimer.stop();
        }
        this.animationParams = animationParams;
        this.animateTimer = new Timer(this.animationParams.waitTime, this.animator);
        this.animateTimer.setInitialDelay(0);
    }

    private final class WrapperContainer
    extends JViewport {
        float alpha = 1.0f;
        boolean collapsedState = false;

        public WrapperContainer(Container container) {
            this.setView(container);
            if (container instanceof JComponent && !container.isOpaque()) {
                ((JComponent)container).setOpaque(true);
            }
        }
    }

    private final class AnimationListener
    implements ActionListener {
        private final Object ANIMATION_MUTEX = "Animation Synchronization Mutex";
        private int startDimension = 0;
        private int finalDimension = 0;
        private float animateAlpha = 1.0f;

        private AnimationListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = this.ANIMATION_MUTEX;
            synchronized (object) {
                if (this.startDimension == this.finalDimension) {
                    JXCollapsiblePane.this.animateTimer.stop();
                    this.animateAlpha = ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.alphaEnd;
                    if (this.finalDimension > 0) {
                        JXCollapsiblePane.this.currentDimension = -1;
                        ((JXCollapsiblePane)JXCollapsiblePane.this).wrapper.collapsedState = false;
                        this.validate();
                        JXCollapsiblePane.this.firePropertyChange("animationState", null, "expanded");
                        return;
                    }
                    ((JXCollapsiblePane)JXCollapsiblePane.this).wrapper.collapsedState = true;
                    JXCollapsiblePane.this.firePropertyChange("animationState", null, "collapsed");
                }
                boolean bl = this.startDimension > this.finalDimension;
                int n2 = bl ? -1 * ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.delta : ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.delta;
                int n3 = JXCollapsiblePane.this.direction.isVertical() ? JXCollapsiblePane.this.wrapper.getHeight() + n2 : JXCollapsiblePane.this.wrapper.getWidth() + n2;
                if (bl) {
                    if (n3 < this.finalDimension) {
                        n3 = this.finalDimension;
                    }
                } else if (n3 > this.finalDimension) {
                    n3 = this.finalDimension;
                }
                int n4 = JXCollapsiblePane.this.direction.isVertical() ? ((JXCollapsiblePane)JXCollapsiblePane.this).wrapper.getView().getPreferredSize().height : ((JXCollapsiblePane)JXCollapsiblePane.this).wrapper.getView().getPreferredSize().width;
                this.animateAlpha = (float)n3 / (float)n4;
                Rectangle rectangle = JXCollapsiblePane.this.wrapper.getBounds();
                if (JXCollapsiblePane.this.direction.isVertical()) {
                    int n5 = rectangle.height;
                    rectangle.height = n3;
                    JXCollapsiblePane.this.wrapper.setBounds(rectangle);
                    if (JXCollapsiblePane.this.direction == Direction.DOWN) {
                        JXCollapsiblePane.this.wrapper.setViewPosition(new Point(0, ((JXCollapsiblePane)JXCollapsiblePane.this).wrapper.getView().getPreferredSize().height - n3));
                    } else {
                        JXCollapsiblePane.this.wrapper.setViewPosition(new Point(0, n3));
                    }
                    rectangle = JXCollapsiblePane.this.getBounds();
                    rectangle.height = rectangle.height - n5 + n3;
                    JXCollapsiblePane.this.currentDimension = rectangle.height;
                } else {
                    int n6 = rectangle.width;
                    rectangle.width = n3;
                    JXCollapsiblePane.this.wrapper.setBounds(rectangle);
                    if (JXCollapsiblePane.this.direction == Direction.RIGHT) {
                        JXCollapsiblePane.this.wrapper.setViewPosition(new Point(((JXCollapsiblePane)JXCollapsiblePane.this).wrapper.getView().getPreferredSize().width - n3, 0));
                    } else {
                        JXCollapsiblePane.this.wrapper.setViewPosition(new Point(n3, 0));
                    }
                    rectangle = JXCollapsiblePane.this.getBounds();
                    rectangle.width = rectangle.width - n6 + n3;
                    JXCollapsiblePane.this.currentDimension = rectangle.width;
                }
                JXCollapsiblePane.this.setBounds(rectangle);
                this.startDimension = n3;
                if (bl) {
                    if (this.animateAlpha < ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.alphaEnd) {
                        this.animateAlpha = ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.alphaEnd;
                    }
                    if (this.animateAlpha > ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.alphaStart) {
                        this.animateAlpha = ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.alphaStart;
                    }
                } else {
                    if (this.animateAlpha > ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.alphaEnd) {
                        this.animateAlpha = ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.alphaEnd;
                    }
                    if (this.animateAlpha < ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.alphaStart) {
                        this.animateAlpha = ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.alphaStart;
                    }
                }
                ((JXCollapsiblePane)JXCollapsiblePane.this).wrapper.alpha = this.animateAlpha;
                this.validate();
            }
        }

        void validate() {
            Container container = SwingUtilities.getAncestorOfClass(CollapsiblePaneContainer.class, JXCollapsiblePane.this);
            container = container != null ? ((CollapsiblePaneContainer)((Object)container)).getValidatingContainer() : JXCollapsiblePane.this.getParent();
            if (container != null) {
                if (container instanceof JComponent) {
                    ((JComponent)container).revalidate();
                } else {
                    container.invalidate();
                }
                container.doLayout();
                container.repaint();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reinit(int n2, int n3) {
            Object object = this.ANIMATION_MUTEX;
            synchronized (object) {
                JXCollapsiblePane.this.firePropertyChange("animationState", null, "reinit");
                this.startDimension = n2;
                this.finalDimension = n3;
                this.animateAlpha = ((JXCollapsiblePane)JXCollapsiblePane.this).animationParams.alphaStart;
                JXCollapsiblePane.this.currentDimension = -1;
            }
        }
    }

    private static class AnimationParams {
        final int waitTime;
        final int delta;
        final float alphaStart;
        final float alphaEnd;

        public AnimationParams(int n2, int n3, float f2, float f3) {
            this.waitTime = n2;
            this.delta = n3;
            this.alphaStart = f2;
            this.alphaEnd = f3;
        }
    }

    public static interface CollapsiblePaneContainer {
        public Container getValidatingContainer();
    }

    private class ToggleAction
    extends AbstractAction
    implements PropertyChangeListener {
        public ToggleAction() {
            super("toggle");
            JXCollapsiblePane.this.addPropertyChangeListener("collapsed", this);
        }

        @Override
        public void putValue(String string, Object object) {
            super.putValue(string, object);
            if ("expandIcon".equals(string) || "collapseIcon".equals(string)) {
                this.updateIcon();
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JXCollapsiblePane.this.setCollapsed(!JXCollapsiblePane.this.isCollapsed());
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.updateIcon();
        }

        void updateIcon() {
            if (JXCollapsiblePane.this.isCollapsed()) {
                this.putValue("SmallIcon", this.getValue("expandIcon"));
            } else {
                this.putValue("SmallIcon", this.getValue("collapseIcon"));
            }
        }
    }

    public static enum Direction {
        LEFT(false),
        RIGHT(false),
        UP(true),
        DOWN(true);

        private final boolean vertical;

        private Direction(boolean bl) {
            this.vertical = bl;
        }

        public boolean isVertical() {
            return this.vertical;
        }
    }
}

