/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class HorizontalLayout
implements LayoutManager {
    private int gap = 0;

    public HorizontalLayout(int n2) {
        this.gap = n2;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        Dimension dimension = container.getSize();
        int n2 = dimension.height - insets.top - insets.bottom;
        int n3 = insets.left;
        int n4 = container.getComponentCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            Component component = container.getComponent(i2);
            if (!component.isVisible()) continue;
            component.setBounds(n3, insets.top, component.getPreferredSize().width, n2);
            n3 += component.getSize().width + this.gap;
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        Dimension dimension = new Dimension(0, 0);
        int n2 = container.getComponentCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Component component = container.getComponent(i2);
            if (!component.isVisible()) continue;
            Dimension dimension2 = container.getComponent(i2).getPreferredSize();
            dimension.height = Math.max(dimension.height, dimension2.height);
            dimension.width += dimension2.width + this.gap;
        }
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }
}

