/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.ActionMap;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.action.AbstractActionExt;
import org.jdesktop.swingx.action.ActionContainerFactory;
import org.jdesktop.swingx.action.BoundAction;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.search.PatternModel;

public abstract class AbstractPatternPanel
extends JXPanel {
    protected JLabel searchLabel;
    protected JTextField searchField;
    protected JCheckBox matchCheck;
    protected PatternModel patternModel;
    private ActionContainerFactory actionFactory;

    public abstract void match();

    protected AbstractActionExt getAction(String string) {
        return (AbstractActionExt)this.getActionMap().get(string);
    }

    protected void initActions() {
        this.initPatternActions();
        this.initExecutables();
    }

    protected void initExecutables() {
        AbstractActionExt abstractActionExt = this.createBoundAction("match", "match");
        this.getActionMap().put("execute", abstractActionExt);
        this.getActionMap().put("match", abstractActionExt);
        this.refreshEmptyFromModel();
    }

    protected void initPatternActions() {
        ActionMap actionMap = this.getActionMap();
        actionMap.put("matchCase", this.createModelStateAction("matchCase", "setCaseSensitive", this.getPatternModel().isCaseSensitive()));
        actionMap.put("wrapSearch", this.createModelStateAction("wrapSearch", "setWrapping", this.getPatternModel().isWrapping()));
        actionMap.put("backwardsSearch", this.createModelStateAction("backwardsSearch", "setBackwards", this.getPatternModel().isBackwards()));
        actionMap.put("matchIncremental", this.createModelStateAction("matchIncremental", "setIncremental", this.getPatternModel().isIncremental()));
    }

    protected String getUIString(String string) {
        return this.getUIString(string, this.getLocale());
    }

    protected String getUIString(String string, Locale locale) {
        String string2 = UIManagerExt.getString("Search." + string, locale);
        return string2 != null ? string2 : string;
    }

    protected AbstractActionExt createModelStateAction(String string, String string2, boolean bl) {
        String string3 = this.getUIString(string);
        BoundAction boundAction = new BoundAction(string3, string);
        boundAction.setStateAction();
        boundAction.registerCallback(this.getPatternModel(), string2);
        boundAction.setSelected(bl);
        return boundAction;
    }

    protected AbstractActionExt createBoundAction(String string, String string2) {
        String string3 = this.getUIString(string);
        BoundAction boundAction = new BoundAction(string3, string);
        boundAction.registerCallback(this, string2);
        return boundAction;
    }

    @Override
    public void setLocale(Locale locale) {
        this.updateLocaleState(locale);
        super.setLocale(locale);
    }

    protected void updateLocaleState(Locale locale) {
        for (Object object : this.getActionMap().allKeys()) {
            String string;
            if (!(object instanceof String) || object.equals(string = this.getUIString((String)object, locale))) continue;
            this.getActionMap().get(object).putValue("Name", string);
        }
        this.bindSearchLabel(locale);
    }

    protected void refreshPatternFromModel() {
        if (this.getPatternModel().isIncremental()) {
            this.match();
        }
    }

    protected PatternModel getPatternModel() {
        if (this.patternModel == null) {
            this.patternModel = this.createPatternModel();
            this.patternModel.addPropertyChangeListener(this.getPatternModelListener());
        }
        return this.patternModel;
    }

    protected PatternModel createPatternModel() {
        return new PatternModel();
    }

    protected PropertyChangeListener getPatternModelListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if ("pattern".equals(string)) {
                    AbstractPatternPanel.this.refreshPatternFromModel();
                } else if ("rawText".equals(string)) {
                    AbstractPatternPanel.this.refreshDocumentFromModel();
                } else if ("caseSensitive".equals(string)) {
                    AbstractPatternPanel.this.getAction("matchCase").setSelected((Boolean)propertyChangeEvent.getNewValue());
                } else if ("wrapping".equals(string)) {
                    AbstractPatternPanel.this.getAction("wrapSearch").setSelected((Boolean)propertyChangeEvent.getNewValue());
                } else if ("backwards".equals(string)) {
                    AbstractPatternPanel.this.getAction("backwardsSearch").setSelected((Boolean)propertyChangeEvent.getNewValue());
                } else if ("incremental".equals(string)) {
                    AbstractPatternPanel.this.getAction("matchIncremental").setSelected((Boolean)propertyChangeEvent.getNewValue());
                } else if ("empty".equals(string)) {
                    AbstractPatternPanel.this.refreshEmptyFromModel();
                }
            }
        };
    }

    protected void refreshEmptyFromModel() {
        boolean bl = !this.getPatternModel().isEmpty();
        this.getAction("match").setEnabled(bl);
    }

    protected void refreshModelFromDocument() {
        this.getPatternModel().setRawText(this.searchField.getText());
    }

    protected void refreshDocumentFromModel() {
        if (this.searchField.getText().equals(this.getPatternModel().getRawText())) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractPatternPanel.this.searchField.setText(AbstractPatternPanel.this.getPatternModel().getRawText());
            }
        });
    }

    protected DocumentListener getSearchFieldListener() {
        return new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                AbstractPatternPanel.this.refreshModelFromDocument();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                AbstractPatternPanel.this.refreshModelFromDocument();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                AbstractPatternPanel.this.refreshModelFromDocument();
            }
        };
    }

    protected void bind() {
        this.bindSearchLabel(this.getLocale());
        this.searchField.getDocument().addDocumentListener(this.getSearchFieldListener());
        this.getActionContainerFactory().configureButton(this.matchCheck, (AbstractActionExt)this.getActionMap().get("matchCase"), null);
    }

    protected void bindSearchLabel(Locale locale) {
        this.searchLabel.setText(this.getUIString("searchFieldLabel", locale));
        String string = this.getUIString("searchFieldLabel.mnemonic", locale);
        if (string != "searchFieldLabel.mnemonic") {
            this.searchLabel.setDisplayedMnemonic(string.charAt(0));
        }
        this.searchLabel.setLabelFor(this.searchField);
    }

    protected ActionContainerFactory getActionContainerFactory() {
        if (this.actionFactory == null) {
            this.actionFactory = new ActionContainerFactory(null);
        }
        return this.actionFactory;
    }

    protected void initComponents() {
        this.searchLabel = new JLabel();
        this.searchField = new JTextField(this.getSearchFieldWidth()){

            @Override
            public Dimension getMaximumSize() {
                Dimension dimension = super.getMaximumSize();
                dimension.height = this.getPreferredSize().height;
                return dimension;
            }
        };
        this.matchCheck = new JCheckBox();
    }

    protected int getSearchFieldWidth() {
        return 15;
    }

    static {
        LookAndFeelAddons.getAddon();
    }
}

