/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.server;

import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.java_websocket.AbstractWebSocket;
import org.java_websocket.WebSocket;
import org.java_websocket.WebSocketImpl;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.handshake.Handshakedata;

public abstract class WebSocketServer
extends AbstractWebSocket
implements Runnable {
    private static final int AVAILABLE_PROCESSORS = Runtime.getRuntime().availableProcessors();
    private final Collection<WebSocket> connections;
    private Selector selector;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<WebSocket> getConnections() {
        Collection<WebSocket> collection = this.connections;
        synchronized (collection) {
            return Collections.unmodifiableCollection(new ArrayList<WebSocket>(this.connections));
        }
    }

    protected void releaseBuffers(WebSocket webSocket) throws InterruptedException {
        throw new InternalError("Badly shrinked");
    }

    @Override
    public final void onWebsocketMessage(WebSocket webSocket, String string) {
        this.onMessage(webSocket, string);
    }

    @Override
    public final void onWebsocketMessage(WebSocket webSocket, ByteBuffer byteBuffer) {
        this.onMessage(webSocket, byteBuffer);
    }

    @Override
    public final void onWebsocketOpen(WebSocket webSocket, Handshakedata handshakedata) {
        if (this.addConnection(webSocket)) {
            this.onOpen(webSocket, (ClientHandshake)handshakedata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onWebsocketClose(WebSocket webSocket, int n2, String string, boolean bl) {
        this.selector.wakeup();
        try {
            if (this.removeConnection(webSocket)) {
                this.onClose(webSocket, n2, string, bl);
            }
        }
        finally {
            try {
                this.releaseBuffers(webSocket);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    protected boolean removeConnection(WebSocket webSocket) {
        throw new InternalError("Badly shrinked");
    }

    protected boolean addConnection(WebSocket webSocket) {
        throw new InternalError("Badly shrinked");
    }

    @Override
    public final void onWebsocketError(WebSocket webSocket, Exception exception) {
        this.onError(webSocket, exception);
    }

    @Override
    public final void onWriteDemand(WebSocket webSocket) {
        WebSocketImpl webSocketImpl = (WebSocketImpl)webSocket;
        try {
            webSocketImpl.getSelectionKey().interestOps(5);
        }
        catch (CancelledKeyException cancelledKeyException) {
            webSocketImpl.outQueue.clear();
        }
        this.selector.wakeup();
    }

    @Override
    public void onWebsocketCloseInitiated(WebSocket webSocket, int n2, String string) {
        this.onCloseInitiated(webSocket, n2, string);
    }

    @Override
    public void onWebsocketClosing(WebSocket webSocket, int n2, String string, boolean bl) {
        this.onClosing(webSocket, n2, string, bl);
    }

    public void onCloseInitiated(WebSocket webSocket, int n2, String string) {
    }

    public void onClosing(WebSocket webSocket, int n2, String string, boolean bl) {
    }

    public abstract void onOpen(WebSocket var1, ClientHandshake var2);

    public abstract void onClose(WebSocket var1, int var2, String var3, boolean var4);

    public abstract void onMessage(WebSocket var1, String var2);

    public abstract void onError(WebSocket var1, Exception var2);

    public void onMessage(WebSocket webSocket, ByteBuffer byteBuffer) {
    }
}

