/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.extensions.permessage_deflate;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.java_websocket.enums.Opcode;
import org.java_websocket.exceptions.InvalidDataException;
import org.java_websocket.exceptions.InvalidFrameException;
import org.java_websocket.extensions.CompressionExtension;
import org.java_websocket.extensions.ExtensionRequestData;
import org.java_websocket.extensions.IExtension;
import org.java_websocket.framing.BinaryFrame;
import org.java_websocket.framing.ContinuousFrame;
import org.java_websocket.framing.DataFrame;
import org.java_websocket.framing.Framedata;
import org.java_websocket.framing.FramedataImpl1;
import org.java_websocket.framing.TextFrame;

public class PerMessageDeflateExtension
extends CompressionExtension {
    private static final byte[] TAIL_BYTES = new byte[]{0, 0, -1, -1};
    private boolean serverNoContextTakeover = true;
    private boolean clientNoContextTakeover = false;
    private Map<String, String> requestedParameters = new LinkedHashMap<String, String>();
    private Inflater inflater = new Inflater(true);
    private Deflater deflater = new Deflater(-1, true);

    @Override
    public void decodeFrame(Framedata framedata) throws InvalidDataException {
        if (!(framedata instanceof DataFrame)) {
            return;
        }
        if (framedata.getOpcode() == Opcode.CONTINUOUS && framedata.isRSV1()) {
            throw new InvalidDataException(1008, "RSV1 bit can only be set for the first frame.");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.decompress(framedata.getPayloadData().array(), byteArrayOutputStream);
            if (this.inflater.getRemaining() > 0) {
                this.inflater = new Inflater(true);
                this.decompress(framedata.getPayloadData().array(), byteArrayOutputStream);
            }
            if (framedata.isFin()) {
                this.decompress(TAIL_BYTES, byteArrayOutputStream);
                if (this.clientNoContextTakeover) {
                    this.inflater = new Inflater(true);
                }
            }
        }
        catch (DataFormatException dataFormatException) {
            throw new InvalidDataException(1008, dataFormatException.getMessage());
        }
        if (framedata.isRSV1()) {
            ((DataFrame)framedata).setRSV1(false);
        }
        ((FramedataImpl1)framedata).setPayload(ByteBuffer.wrap(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size()));
    }

    private void decompress(byte[] byArray, ByteArrayOutputStream byteArrayOutputStream) throws DataFormatException {
        int n2;
        this.inflater.setInput(byArray);
        byte[] byArray2 = new byte[1024];
        while ((n2 = this.inflater.inflate(byArray2)) > 0) {
            byteArrayOutputStream.write(byArray2, 0, n2);
        }
    }

    @Override
    public void encodeFrame(Framedata framedata) {
        int n2;
        if (!(framedata instanceof DataFrame)) {
            return;
        }
        if (!(framedata instanceof ContinuousFrame)) {
            ((DataFrame)framedata).setRSV1(true);
        }
        this.deflater.setInput(framedata.getPayloadData().array());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while ((n2 = this.deflater.deflate(byArray, 0, byArray.length, 2)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        int n3 = byArray2.length;
        if (framedata.isFin()) {
            if (this.endsWithTail(byArray2)) {
                n3 -= TAIL_BYTES.length;
            }
            if (this.serverNoContextTakeover) {
                this.deflater.end();
                this.deflater = new Deflater(-1, true);
            }
        }
        ((FramedataImpl1)framedata).setPayload(ByteBuffer.wrap(byArray2, 0, n3));
    }

    private boolean endsWithTail(byte[] byArray) {
        if (byArray.length < 4) {
            return false;
        }
        int n2 = byArray.length;
        for (int i2 = 0; i2 < TAIL_BYTES.length; ++i2) {
            if (TAIL_BYTES[i2] == byArray[n2 - TAIL_BYTES.length + i2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean acceptProvidedExtensionAsServer(String string) {
        String[] stringArray;
        for (String string2 : stringArray = string.split(",")) {
            ExtensionRequestData extensionRequestData = ExtensionRequestData.parseExtensionRequest(string2);
            if (!"permessage-deflate".equalsIgnoreCase(extensionRequestData.getExtensionName())) continue;
            Map<String, String> map = extensionRequestData.getExtensionParameters();
            this.requestedParameters.putAll(map);
            if (this.requestedParameters.containsKey("client_no_context_takeover")) {
                this.clientNoContextTakeover = true;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean acceptProvidedExtensionAsClient(String string) {
        String[] stringArray;
        for (String string2 : stringArray = string.split(",")) {
            ExtensionRequestData extensionRequestData = ExtensionRequestData.parseExtensionRequest(string2);
            if (!"permessage-deflate".equalsIgnoreCase(extensionRequestData.getExtensionName())) continue;
            Map<String, String> map = extensionRequestData.getExtensionParameters();
            return true;
        }
        return false;
    }

    @Override
    public String getProvidedExtensionAsClient() {
        this.requestedParameters.put("client_no_context_takeover", ExtensionRequestData.EMPTY_VALUE);
        this.requestedParameters.put("server_no_context_takeover", ExtensionRequestData.EMPTY_VALUE);
        return "permessage-deflate; server_no_context_takeover; client_no_context_takeover";
    }

    @Override
    public String getProvidedExtensionAsServer() {
        return "permessage-deflate; server_no_context_takeover" + (this.clientNoContextTakeover ? "; client_no_context_takeover" : "");
    }

    @Override
    public IExtension copyInstance() {
        return new PerMessageDeflateExtension();
    }

    @Override
    public void isFrameValid(Framedata framedata) throws InvalidDataException {
        if ((framedata instanceof TextFrame || framedata instanceof BinaryFrame) && !framedata.isRSV1()) {
            throw new InvalidFrameException("RSV1 bit must be set for DataFrames.");
        }
        if (framedata instanceof ContinuousFrame && (framedata.isRSV1() || framedata.isRSV2() || framedata.isRSV3())) {
            throw new InvalidFrameException("bad rsv RSV1: " + framedata.isRSV1() + " RSV2: " + framedata.isRSV2() + " RSV3: " + framedata.isRSV3());
        }
        super.isFrameValid(framedata);
    }

    @Override
    public String toString() {
        return "PerMessageDeflateExtension";
    }
}

