/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.java_websocket.AbstractWebSocket;
import org.java_websocket.WebSocket;
import org.java_websocket.WebSocketImpl;
import org.java_websocket.client.DnsResolver;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_6455;
import org.java_websocket.exceptions.InvalidHandshakeException;
import org.java_websocket.framing.Framedata;
import org.java_websocket.handshake.HandshakeImpl1Client;
import org.java_websocket.handshake.Handshakedata;
import org.java_websocket.handshake.ServerHandshake;

public abstract class WebSocketClient
extends AbstractWebSocket
implements Runnable,
WebSocket {
    protected URI uri = null;
    private WebSocketImpl engine = null;
    private Socket socket = null;
    private SocketFactory socketFactory = null;
    private OutputStream ostream;
    private Proxy proxy = Proxy.NO_PROXY;
    private Thread writeThread;
    private Thread connectReadThread;
    private Draft draft;
    private Map<String, String> headers;
    private CountDownLatch connectLatch = new CountDownLatch(1);
    private CountDownLatch closeLatch = new CountDownLatch(1);
    private int connectTimeout = 0;
    private DnsResolver dnsResolver = null;

    public WebSocketClient(URI uRI) {
        this(uRI, new Draft_6455());
    }

    public WebSocketClient(URI uRI, Draft draft) {
        this(uRI, draft, null, 0);
    }

    public WebSocketClient(URI uRI, Draft draft, Map<String, String> map, int n2) {
        if (uRI == null) {
            throw new IllegalArgumentException();
        }
        if (draft == null) {
            throw new IllegalArgumentException("null as draft is permitted for `WebSocketServer` only!");
        }
        this.uri = uRI;
        this.draft = draft;
        this.dnsResolver = new DnsResolver(){

            @Override
            public InetAddress resolve(URI uRI) throws UnknownHostException {
                return InetAddress.getByName(uRI.getHost());
            }
        };
        if (map != null) {
            this.headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            this.headers.putAll(map);
        }
        this.connectTimeout = n2;
        this.setTcpNoDelay(false);
        this.setReuseAddr(false);
        this.engine = new WebSocketImpl(this, draft);
    }

    public URI getURI() {
        return this.uri;
    }

    public void addHeader(String string, String string2) {
        if (this.headers == null) {
            this.headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        }
        this.headers.put(string, string2);
    }

    public void connect() {
        if (this.connectReadThread != null) {
            throw new IllegalStateException("WebSocketClient objects are not reuseable");
        }
        this.connectReadThread = new Thread(this);
        this.connectReadThread.setName("WebSocketConnectReadThread-" + this.connectReadThread.getId());
        this.connectReadThread.start();
    }

    public void close() {
        if (this.writeThread != null) {
            this.engine.close(1000);
        }
    }

    public void send(String string) {
        this.engine.send(string);
    }

    @Override
    protected Collection<WebSocket> getConnections() {
        return Collections.singletonList(this.engine);
    }

    @Override
    public void run() {
        InputStream inputStream;
        try {
            Object object;
            Object object2;
            boolean bl = false;
            if (this.socketFactory != null) {
                this.socket = this.socketFactory.createSocket();
            } else if (this.socket == null) {
                this.socket = new Socket(this.proxy);
                bl = true;
            } else if (this.socket.isClosed()) {
                throw new IOException();
            }
            this.socket.setTcpNoDelay(this.isTcpNoDelay());
            this.socket.setReuseAddress(this.isReuseAddr());
            if (!this.socket.isConnected()) {
                object2 = new InetSocketAddress(this.dnsResolver.resolve(this.uri), this.getPort());
                this.socket.connect((SocketAddress)object2, this.connectTimeout);
            }
            if (bl && "wss".equals(this.uri.getScheme())) {
                object2 = SSLContext.getInstance("TLSv1.2");
                ((SSLContext)object2).init(null, null, null);
                object = ((SSLContext)object2).getSocketFactory();
                this.socket = ((SSLSocketFactory)object).createSocket(this.socket, this.uri.getHost(), this.getPort(), true);
            }
            if (this.socket instanceof SSLSocket) {
                object2 = (SSLSocket)this.socket;
                object = ((SSLSocket)object2).getSSLParameters();
                this.onSetSSLParameters((SSLParameters)object);
                ((SSLSocket)object2).setSSLParameters((SSLParameters)object);
            }
            inputStream = this.socket.getInputStream();
            this.ostream = this.socket.getOutputStream();
            this.sendHandshake();
        }
        catch (Exception exception) {
            this.onWebsocketError(this.engine, exception);
            this.engine.closeConnection(-1, exception.getMessage());
            return;
        }
        catch (InternalError internalError) {
            if (internalError.getCause() instanceof InvocationTargetException && internalError.getCause().getCause() instanceof IOException) {
                IOException iOException = (IOException)internalError.getCause().getCause();
                this.onWebsocketError(this.engine, iOException);
                this.engine.closeConnection(-1, iOException.getMessage());
                return;
            }
            throw internalError;
        }
        this.writeThread = new Thread(new WebsocketWriteThread(this));
        this.writeThread.start();
        byte[] byArray = new byte[16384];
        try {
            int n2;
            while (!this.isClosing() && !this.isClosed() && (n2 = inputStream.read(byArray)) != -1) {
                this.engine.decode(ByteBuffer.wrap(byArray, 0, n2));
            }
            this.engine.eot();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
        catch (RuntimeException runtimeException) {
            this.onError(runtimeException);
            this.engine.closeConnection(1006, runtimeException.getMessage());
        }
        this.connectReadThread = null;
    }

    protected void onSetSSLParameters(SSLParameters sSLParameters) {
        sSLParameters.setEndpointIdentificationAlgorithm("HTTPS");
    }

    private int getPort() {
        int n2 = this.uri.getPort();
        String string = this.uri.getScheme();
        if ("wss".equals(string)) {
            return n2 == -1 ? 443 : n2;
        }
        if ("ws".equals(string)) {
            return n2 == -1 ? 80 : n2;
        }
        throw new IllegalArgumentException("unknown scheme: " + string);
    }

    private void sendHandshake() throws InvalidHandshakeException {
        String string = this.uri.getRawPath();
        String string2 = this.uri.getRawQuery();
        String string3 = string == null || string.length() == 0 ? "/" : string;
        if (string2 != null) {
            string3 = string3 + '?' + string2;
        }
        int n2 = this.getPort();
        String string4 = this.uri.getHost() + (n2 != 80 && n2 != 443 ? ":" + n2 : "");
        HandshakeImpl1Client handshakeImpl1Client = new HandshakeImpl1Client();
        handshakeImpl1Client.setResourceDescriptor(string3);
        handshakeImpl1Client.put("Host", string4);
        if (this.headers != null) {
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                handshakeImpl1Client.put(entry.getKey(), entry.getValue());
            }
        }
        this.engine.startHandshake(handshakeImpl1Client);
    }

    @Override
    public final void onWebsocketMessage(WebSocket webSocket, String string) {
        this.onMessage(string);
    }

    @Override
    public final void onWebsocketMessage(WebSocket webSocket, ByteBuffer byteBuffer) {
        this.onMessage(byteBuffer);
    }

    @Override
    public final void onWebsocketOpen(WebSocket webSocket, Handshakedata handshakedata) {
        this.startConnectionLostTimer();
        this.onOpen((ServerHandshake)handshakedata);
        this.connectLatch.countDown();
    }

    @Override
    public final void onWebsocketClose(WebSocket webSocket, int n2, String string, boolean bl) {
        this.stopConnectionLostTimer();
        if (this.writeThread != null) {
            this.writeThread.interrupt();
        }
        this.onClose(n2, string, bl);
        this.connectLatch.countDown();
        this.closeLatch.countDown();
    }

    @Override
    public final void onWebsocketError(WebSocket webSocket, Exception exception) {
        this.onError(exception);
    }

    @Override
    public final void onWriteDemand(WebSocket webSocket) {
    }

    @Override
    public void onWebsocketCloseInitiated(WebSocket webSocket, int n2, String string) {
        this.onCloseInitiated(n2, string);
    }

    @Override
    public void onWebsocketClosing(WebSocket webSocket, int n2, String string, boolean bl) {
        this.onClosing(n2, string, bl);
    }

    public void onCloseInitiated(int n2, String string) {
    }

    public void onClosing(int n2, String string, boolean bl) {
    }

    public abstract void onOpen(ServerHandshake var1);

    public abstract void onMessage(String var1);

    public abstract void onClose(int var1, String var2, boolean var3);

    public abstract void onError(Exception var1);

    public void onMessage(ByteBuffer byteBuffer) {
    }

    public boolean isOpen() {
        return this.engine.isOpen();
    }

    public boolean isClosed() {
        return this.engine.isClosed();
    }

    public boolean isClosing() {
        return this.engine.isClosing();
    }

    @Override
    public void sendFrame(Framedata framedata) {
        this.engine.sendFrame(framedata);
    }

    private void handleIOException(IOException iOException) {
        if (iOException instanceof SSLException) {
            this.onError(iOException);
        }
        this.engine.eot();
    }

    private class WebsocketWriteThread
    implements Runnable {
        private final WebSocketClient webSocketClient;

        WebsocketWriteThread(WebSocketClient webSocketClient2) {
            this.webSocketClient = webSocketClient2;
        }

        @Override
        public void run() {
            Thread.currentThread().setName("WebSocketWriteThread-" + Thread.currentThread().getId());
            try {
                this.runWriteData();
            }
            catch (IOException iOException) {
                WebSocketClient.this.handleIOException(iOException);
            }
            finally {
                this.closeSocket();
                WebSocketClient.this.writeThread = null;
            }
        }

        private void runWriteData() throws IOException {
            try {
                while (!Thread.interrupted()) {
                    ByteBuffer byteBuffer = ((WebSocketClient)WebSocketClient.this).engine.outQueue.take();
                    WebSocketClient.this.ostream.write(byteBuffer.array(), 0, byteBuffer.limit());
                    WebSocketClient.this.ostream.flush();
                }
            }
            catch (InterruptedException interruptedException) {
                for (ByteBuffer byteBuffer : ((WebSocketClient)WebSocketClient.this).engine.outQueue) {
                    WebSocketClient.this.ostream.write(byteBuffer.array(), 0, byteBuffer.limit());
                    WebSocketClient.this.ostream.flush();
                }
                Thread.currentThread().interrupt();
            }
        }

        private void closeSocket() {
            try {
                if (WebSocketClient.this.socket != null) {
                    WebSocketClient.this.socket.close();
                }
            }
            catch (IOException iOException) {
                WebSocketClient.this.onWebsocketError(this.webSocketClient, iOException);
            }
        }
    }
}

