/*
 * Decompiled with CFR 0.152.
 */
package net.straylightlabs.hola.utils;

import java.io.IOException;
import java.net.DatagramPacket;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Level;
import roomeqwizard.WizardLogger;

public class Utils {
    private static int nextDumpPathSuffix = 1;

    public static void dumpPacket(DatagramPacket datagramPacket, String string) {
        byte[] byArray = new byte[datagramPacket.getLength()];
        System.arraycopy(datagramPacket.getData(), datagramPacket.getOffset(), byArray, 0, datagramPacket.getLength());
        Utils.printBuffer(byArray, "Buffer to save");
        try {
            Path path = Utils.getNextPath(string);
            Files.write(path, byArray, new OpenOption[0]);
        }
        catch (IOException iOException) {
            WizardLogger.getLogger().log(Level.SEVERE, "Error writing file: {}", iOException.getLocalizedMessage());
        }
    }

    public static Path getNextPath(String string) {
        Path path;
        do {
            path = Paths.get(String.format("%s%s", string, Integer.toString(nextDumpPathSuffix)), new String[0]);
            ++nextDumpPathSuffix;
        } while (Files.exists(path, new LinkOption[0]));
        return path;
    }

    public static void printBuffer(byte[] byArray, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (i2 % 20 == 0) {
                stringBuilder.append("\n\t");
            }
            stringBuilder.append(String.format("%02x", byArray[i2]));
        }
    }
}

