/*
 * Decompiled with CFR 0.152.
 */
package net.straylightlabs.hola.sd;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Service {
    private final String name;
    private final List<String> labels;
    private static final Pattern SERVICE_PATTERN = Pattern.compile("^((_[a-zA-Z0-9_\\-]+\\.)?_(tcp|udp))\\.?|$");

    public static Service fromName(String string) {
        Matcher matcher = SERVICE_PATTERN.matcher(string);
        if (matcher.find()) {
            return new Service(matcher.group(1));
        }
        throw new IllegalArgumentException("Name does not match service syntax");
    }

    private Service(String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("A Service's name can't be null or empty");
        }
        this.name = string;
        this.labels = Arrays.asList(string.split("\\."));
    }

    public String getName() {
        return this.name;
    }

    public List<String> getLabels() {
        return Collections.unmodifiableList(this.labels);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Service service = (Service)object;
        return this.name.equals(service.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "Service{name='" + this.name + '\'' + ", labels=" + this.labels + '}';
    }
}

