/*
 * Decompiled with CFR 0.152.
 */
package net.straylightlabs.hola.sd;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import net.straylightlabs.hola.dns.ARecord;
import net.straylightlabs.hola.dns.AaaaRecord;
import net.straylightlabs.hola.dns.Domain;
import net.straylightlabs.hola.dns.PtrRecord;
import net.straylightlabs.hola.dns.Question;
import net.straylightlabs.hola.dns.Record;
import net.straylightlabs.hola.dns.Response;
import net.straylightlabs.hola.dns.SrvRecord;
import net.straylightlabs.hola.dns.TxtRecord;
import net.straylightlabs.hola.sd.Instance;
import net.straylightlabs.hola.sd.Service;
import roomeqwizard.WizardLogger;

public class Query {
    private final Service service;
    private final Domain domain;
    private final int browsingTimeout;
    private final Lock socketLock;
    private MulticastSocket socket;
    private InetAddress mdnsGroupIPv4;
    private InetAddress mdnsGroupIPv6;
    private boolean isUsingIPv4;
    private boolean isUsingIPv6;
    private Question initialQuestion;
    private Set<Question> questions;
    private Set<Instance> instances;
    private Set<Record> records;
    private boolean listenerStarted;
    private boolean listenerFinished;
    public static final String MDNS_IP4_ADDRESS = "224.0.0.251";
    public static final String MDNS_IP6_ADDRESS = "FF02::FB";
    public static final int MDNS_PORT = 5353;
    private static final int WAIT_FOR_LISTENER_MS = 10;
    static final InetAddress TEST_SUITE_ADDRESS = null;
    private static final boolean LOG_DEBUG = false;
    private static final int BROWSING_TIMEOUT = 750;

    public static Query createFor(Service service, Domain domain) {
        return new Query(service, domain, 750);
    }

    public static Query createWithTimeout(Service service, Domain domain, int n2) {
        return new Query(service, domain, n2);
    }

    private Query(Service service, Domain domain, int n2) {
        this.service = service;
        this.domain = domain;
        this.browsingTimeout = n2;
        this.questions = new HashSet<Question>();
        this.records = new HashSet<Record>();
        this.socketLock = new ReentrantLock();
    }

    public Set<Instance> runOnce() throws IOException {
        InetAddress inetAddress;
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress("google.com", 80));
            inetAddress = socket.getLocalAddress();
        }
        catch (Exception exception) {
            inetAddress = InetAddress.getLocalHost();
        }
        return this.runOnceOn(inetAddress, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Instance> runOnceOn(InetAddress inetAddress, NetworkInterface networkInterface) throws IOException {
        this.initialQuestion = new Question(this.service, this.domain);
        this.instances = Collections.synchronizedSet(new HashSet());
        try {
            this.openSocket(inetAddress, networkInterface);
            Thread thread = this.listenForResponses();
            while (!this.isServerIsListening()) {
            }
            this.ask(this.initialQuestion);
            if (thread != null) {
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    WizardLogger.getLogger().log(Level.SEVERE, "InterruptedException while listening for mDNS responses");
                }
            }
        }
        catch (IOException iOException) {
            WizardLogger.getLogger().log(Level.SEVERE, "IOException when trying InetAddress {0}: {1}", new Object[]{inetAddress, iOException.getLocalizedMessage()});
        }
        finally {
            this.closeSocket();
        }
        return this.instances;
    }

    private void ask(Question question) throws IOException {
        if (this.questions.contains(question)) {
            return;
        }
        this.questions.add(question);
        boolean bl = false;
        if (this.isUsingIPv6) {
            try {
                question.askOn(this.socket, this.mdnsGroupIPv6);
                bl = true;
            }
            catch (IOException iOException) {
                WizardLogger.getLogger().log(Level.SEVERE, "IOException while asking question on IPV6: {0}", iOException.getLocalizedMessage());
            }
        }
        if (!bl && this.isUsingIPv4) {
            try {
                question.askOn(this.socket, this.mdnsGroupIPv4);
            }
            catch (IOException iOException) {
                WizardLogger.getLogger().log(Level.SEVERE, "IOException while asking question on IPV4: {0}", iOException.getLocalizedMessage());
            }
        }
    }

    private boolean isServerIsListening() {
        boolean bl;
        try {
            while (!this.socketLock.tryLock(10L, TimeUnit.MILLISECONDS)) {
                this.socketLock.notify();
            }
            if (this.listenerFinished) {
                throw new RuntimeException("Listener has already finished");
            }
            bl = this.listenerStarted;
        }
        catch (InterruptedException interruptedException) {
            WizardLogger.getLogger().log(Level.SEVERE, "Interrupted while waiting to acquire socket lock");
            throw new RuntimeException("Server is not listening");
        }
        finally {
            this.socketLock.unlock();
        }
        return bl;
    }

    public void start() {
        throw new RuntimeException("Not implemented yet");
    }

    private void openSocket(InetAddress inetAddress, NetworkInterface networkInterface) throws IOException {
        this.mdnsGroupIPv4 = InetAddress.getByName(MDNS_IP4_ADDRESS);
        this.mdnsGroupIPv6 = InetAddress.getByName(MDNS_IP6_ADDRESS);
        this.socket = new MulticastSocket(5353);
        if (inetAddress != null && !inetAddress.isLoopbackAddress()) {
            this.socket.setNetworkInterface(networkInterface);
        }
        try {
            this.socket.joinGroup(this.mdnsGroupIPv6);
            this.isUsingIPv6 = true;
        }
        catch (SocketException socketException) {
            WizardLogger.getLogger().log(Level.SEVERE, "SocketException when joining group for {0}, IPv6-only hosts will not be found", MDNS_IP6_ADDRESS);
        }
        if (!this.isUsingIPv6) {
            try {
                this.socket.joinGroup(this.mdnsGroupIPv4);
                this.isUsingIPv4 = true;
            }
            catch (SocketException socketException) {
                WizardLogger.getLogger().log(Level.SEVERE, "SocketException when joining group for {0}, IPv4-only hosts will not be found", MDNS_IP4_ADDRESS);
            }
        }
        if (!this.isUsingIPv4 && !this.isUsingIPv6) {
            WizardLogger.getLogger().log(Level.SEVERE, "No usable network interfaces found");
            throw new IOException("No usable network interfaces found");
        }
        this.socket.setTimeToLive(10);
        this.socket.setSoTimeout(this.browsingTimeout);
    }

    private Thread listenForResponses() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                Query.this.collectResponses();
            }
        });
        thread.start();
        return thread;
    }

    private Set<Instance> collectResponses() {
        long l2;
        long l3 = l2 = System.currentTimeMillis();
        this.socketLock.lock();
        this.listenerStarted = true;
        this.listenerFinished = false;
        this.socketLock.unlock();
        int n2 = 0;
        while (n2 == 0 && l3 - l2 < (long)this.browsingTimeout) {
            byte[] byArray = new byte[9000];
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
            try {
                this.socket.receive(datagramPacket);
                l3 = System.currentTimeMillis();
                try {
                    this.parseResponsePacket(datagramPacket);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    n2 = 0;
                    continue;
                }
                n2 = 0;
            }
            catch (SocketTimeoutException socketTimeoutException) {
                ++n2;
            }
            catch (IOException iOException) {
                WizardLogger.getLogger().log(Level.SEVERE, "IOException while listening for mDNS responses: ", iOException);
            }
        }
        this.socketLock.lock();
        this.listenerFinished = true;
        this.socketLock.unlock();
        this.buildInstancesFromRecords();
        return this.instances;
    }

    void parseResponsePacket(DatagramPacket datagramPacket) throws IOException {
        Response response = Response.createFrom(datagramPacket, this.socket);
        if (response.answers(this.questions)) {
            this.records.addAll(response.getRecords());
            this.fetchMissingRecords();
        }
    }

    private void fetchMissingRecords() throws IOException {
        Record record;
        for (Record record2 : this.records) {
            if (!(record2 instanceof PtrRecord)) continue;
            record = (PtrRecord)record2;
            this.fetchMissingSrvRecordsFor((PtrRecord)record);
            this.fetchMissingTxtRecordsFor((PtrRecord)record);
        }
        for (Record record2 : this.records) {
            if (!(record2 instanceof SrvRecord)) continue;
            record = (SrvRecord)record2;
            this.fetchMissingAddressRecordsFor((SrvRecord)record);
        }
    }

    private void fetchMissingSrvRecordsFor(PtrRecord ptrRecord) throws IOException {
        long l2 = 0L;
        for (Record record : this.records) {
            if (!(record instanceof SrvRecord) || !record.getName().equals(ptrRecord.getPtrName())) continue;
            ++l2;
        }
        if (l2 == 0L) {
            this.querySrvRecordFor(ptrRecord);
        }
    }

    private void fetchMissingTxtRecordsFor(PtrRecord ptrRecord) throws IOException {
        long l2 = 0L;
        for (Record record : this.records) {
            if (!(record instanceof TxtRecord) || !record.getName().equals(ptrRecord.getPtrName())) continue;
            ++l2;
        }
        if (l2 == 0L) {
            this.queryTxtRecordFor(ptrRecord);
        }
    }

    private void fetchMissingAddressRecordsFor(SrvRecord srvRecord) throws IOException {
        long l2 = 0L;
        for (Record record : this.records) {
            if (!(record instanceof ARecord) && !(record instanceof AaaaRecord) || !record.getName().equals(srvRecord.getTarget())) continue;
            ++l2;
        }
        if (l2 == 0L) {
            this.queryAddressesFor(srvRecord);
        }
    }

    private void querySrvRecordFor(PtrRecord ptrRecord) throws IOException {
        Question question = new Question(ptrRecord.getPtrName(), Question.QType.SRV, Question.QClass.IN);
        this.ask(question);
    }

    private void queryTxtRecordFor(PtrRecord ptrRecord) throws IOException {
        Question question = new Question(ptrRecord.getPtrName(), Question.QType.TXT, Question.QClass.IN);
        this.ask(question);
    }

    private void queryAddressesFor(SrvRecord srvRecord) throws IOException {
        Question question = new Question(srvRecord.getTarget(), Question.QType.A, Question.QClass.IN);
        this.ask(question);
        question = new Question(srvRecord.getTarget(), Question.QType.AAAA, Question.QClass.IN);
        this.ask(question);
    }

    void buildInstancesFromRecords() {
        for (Record record : this.records) {
            if (!(record instanceof PtrRecord) || !this.initialQuestion.answeredBy(record)) continue;
            PtrRecord ptrRecord = (PtrRecord)record;
            this.instances.add(Instance.createFromRecords(ptrRecord, this.records));
        }
    }

    private void closeSocket() {
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
    }

    Set<Question> getQuestions() {
        return Collections.unmodifiableSet(this.questions);
    }

    Set<Instance> getInstances() {
        return Collections.unmodifiableSet(this.instances);
    }
}

