/*
 * Decompiled with CFR 0.152.
 */
package net.straylightlabs.hola.sd;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.straylightlabs.hola.dns.ARecord;
import net.straylightlabs.hola.dns.AaaaRecord;
import net.straylightlabs.hola.dns.PtrRecord;
import net.straylightlabs.hola.dns.Record;
import net.straylightlabs.hola.dns.SrvRecord;
import net.straylightlabs.hola.dns.TxtRecord;

public class Instance {
    private final String name;
    private final Set<InetAddress> addresses;
    private final int port;
    private final Map<String, String> attributes;

    static Instance createFromRecords(PtrRecord ptrRecord, Set<Record> set) {
        int n2;
        String string = ptrRecord.getUserVisibleName();
        ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>();
        Map<String, String> map = Collections.emptyMap();
        SrvRecord srvRecord = null;
        for (Record object : set) {
            if (!(object instanceof SrvRecord) || !object.getName().equals(ptrRecord.getPtrName())) continue;
            srvRecord = (SrvRecord)object;
            break;
        }
        if (srvRecord != null) {
            n2 = srvRecord.getPort();
            for (Record record : set) {
                if (!(record instanceof ARecord) || !record.getName().equals(srvRecord.getTarget())) continue;
                arrayList.add(((ARecord)record).getAddress());
            }
            for (Record record : set) {
                if (!(record instanceof AaaaRecord) || !record.getName().equals(srvRecord.getTarget())) continue;
                arrayList.add(((AaaaRecord)record).getAddress());
            }
        } else {
            throw new IllegalStateException("Cannot create Instance when no SRV record is available");
        }
        Object object = null;
        for (Record record : set) {
            if (!(record instanceof TxtRecord) || !record.getName().equals(ptrRecord.getPtrName())) continue;
            object = (TxtRecord)record;
            break;
        }
        if (object != null) {
            map = ((TxtRecord)object).getAttributes();
        }
        return new Instance(string, arrayList, n2, map);
    }

    Instance(String string, List<InetAddress> list, int n2, Map<String, String> map) {
        this.name = string;
        this.addresses = new HashSet<InetAddress>();
        this.addresses.addAll(list);
        this.port = n2;
        this.attributes = map;
    }

    public String getName() {
        return this.name;
    }

    public Set<InetAddress> getAddresses() {
        return Collections.unmodifiableSet(this.addresses);
    }

    public int getPort() {
        return this.port;
    }

    public boolean hasAttribute(String string) {
        return this.attributes.containsKey(string);
    }

    public String lookupAttribute(String string) {
        return this.attributes.get(string);
    }

    public String toString() {
        return "Instance{name='" + this.name + '\'' + ", addresses=" + this.addresses + ", port=" + this.port + ", attributes=" + this.attributes + '}';
    }

    public int hashCode() {
        int n2 = 17;
        n2 = 31 * n2 + this.getName().hashCode();
        n2 = 31 * n2 + this.getPort();
        for (InetAddress object : this.getAddresses()) {
            n2 = 31 * n2 + object.hashCode();
        }
        for (Map.Entry entry : this.attributes.entrySet()) {
            n2 = 31 * n2 + entry.hashCode();
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Instance)) {
            return false;
        }
        Instance instance = (Instance)object;
        if (!this.getName().equals(instance.getName())) {
            return false;
        }
        if (this.getPort() != instance.getPort()) {
            return false;
        }
        for (InetAddress object2 : this.getAddresses()) {
            if (instance.getAddresses().contains(object2)) continue;
            return false;
        }
        for (InetAddress inetAddress : instance.getAddresses()) {
            if (this.getAddresses().contains(inetAddress)) continue;
            return false;
        }
        for (String string : this.attributes.keySet()) {
            if (instance.hasAttribute(string) && instance.lookupAttribute(string).equals(this.lookupAttribute(string))) continue;
            return false;
        }
        for (String string : instance.attributes.keySet()) {
            if (this.hasAttribute(string) && this.lookupAttribute(string).equals(instance.lookupAttribute(string))) continue;
            return false;
        }
        return true;
    }
}

