/*
 * Decompiled with CFR 0.152.
 */
package net.straylightlabs.hola.dns;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.straylightlabs.hola.dns.Record;

public class TxtRecord
extends Record {
    private Map<String, String> attributes;

    public TxtRecord(ByteBuffer byteBuffer, String string, Record.Class clazz, long l2, int n2) {
        super(string, clazz, l2);
        List<String> list = TxtRecord.readStringsFromBuffer(byteBuffer, n2);
        this.attributes = this.parseDataStrings(list);
    }

    private Map<String, String> parseDataStrings(List<String> list) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : list) {
            String[] stringArray = string.split("=");
            if (stringArray.length <= 1) continue;
            hashMap.put(stringArray[0], stringArray[1]);
        }
        return hashMap;
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    @Override
    public String toString() {
        return "TxtRecord{name='" + this.name + '\'' + ", recordClass=" + (Object)((Object)this.recordClass) + ", ttl=" + this.ttl + ", attributes=" + this.attributes + '}';
    }
}

