/*
 * Decompiled with CFR 0.152.
 */
package net.straylightlabs.hola.dns;

import java.nio.ByteBuffer;
import net.straylightlabs.hola.dns.Record;

public class SrvRecord
extends Record {
    private final int priority;
    private final int weight;
    private final int port;
    private final String target;

    public SrvRecord(ByteBuffer byteBuffer, String string, Record.Class clazz, long l2) {
        super(string, clazz, l2);
        this.priority = byteBuffer.getShort() & 0xFFFF;
        this.weight = byteBuffer.getShort() & 0xFFFF;
        this.port = byteBuffer.getShort() & 0xFFFF;
        this.target = SrvRecord.readNameFromBuffer(byteBuffer);
    }

    public int getPriority() {
        return this.priority;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getPort() {
        return this.port;
    }

    public String getTarget() {
        return this.target;
    }

    @Override
    public String toString() {
        return "SrvRecord{name='" + this.name + '\'' + ", recordClass=" + (Object)((Object)this.recordClass) + ", ttl=" + this.ttl + ", priority=" + this.priority + ", weight=" + this.weight + ", port=" + this.port + ", target='" + this.target + '\'' + '}';
    }
}

