/*
 * Decompiled with CFR 0.152.
 */
package net.straylightlabs.hola.dns;

import java.net.DatagramPacket;
import java.net.MulticastSocket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import net.straylightlabs.hola.dns.Message;
import net.straylightlabs.hola.dns.PtrRecord;
import net.straylightlabs.hola.dns.Question;
import net.straylightlabs.hola.dns.Record;
import roomeqwizard.WizardLogger;

public class Response
extends Message {
    private final List<Question> questions = new ArrayList<Question>();
    private final List<Record> records = new ArrayList<Record>();
    private int numQuestions;
    private int numAnswers;
    private int numNameServers;
    private int numAdditionalRecords;
    private static final int QR_MASK = 32768;
    private static final int OPCODE_MASK = 30720;
    private static final int RCODE_MASK = 15;

    public static Response createFrom(DatagramPacket datagramPacket, MulticastSocket multicastSocket) {
        Response response = new Response(datagramPacket);
        response.parseRecords(multicastSocket);
        return response;
    }

    private Response() {
    }

    private Response(DatagramPacket datagramPacket) {
        this();
        byte[] byArray = this.buffer.array();
        System.arraycopy(datagramPacket.getData(), datagramPacket.getOffset(), byArray, 0, datagramPacket.getLength());
        this.buffer.limit(datagramPacket.getLength());
        this.buffer.position(0);
    }

    private void parseRecords(MulticastSocket multicastSocket) {
        Object object;
        int n2;
        this.parseHeader();
        for (n2 = 0; n2 < this.numQuestions; ++n2) {
            object = Question.fromBuffer(this.buffer);
            this.questions.add((Question)object);
        }
        for (n2 = 0; n2 < this.numAnswers; ++n2) {
            object = Record.fromBuffer(this.buffer, multicastSocket);
            this.records.add((Record)object);
        }
        for (n2 = 0; n2 < this.numNameServers; ++n2) {
            object = Record.fromBuffer(this.buffer, multicastSocket);
            this.records.add((Record)object);
        }
        for (n2 = 0; n2 < this.numAdditionalRecords; ++n2) {
            object = Record.fromBuffer(this.buffer, multicastSocket);
            this.records.add((Record)object);
        }
    }

    private void parseHeader() {
        this.readUnsignedShort();
        int n2 = this.readUnsignedShort();
        if ((n2 & 0x8000) != 32768) {
            throw new IllegalArgumentException("Packet is not a DNS response");
        }
        if ((n2 & 0x7800) != 0) {
            throw new IllegalArgumentException("mDNS response packets can't have OPCODE values");
        }
        if ((n2 & 0xF) != 0) {
            throw new IllegalArgumentException("mDNS response packets can't have RCODE values");
        }
        this.numQuestions = this.readUnsignedShort();
        this.numAnswers = this.readUnsignedShort();
        this.numNameServers = this.readUnsignedShort();
        this.numAdditionalRecords = this.readUnsignedShort();
    }

    public Set<Record> getRecords() {
        return new HashSet<Record>(Collections.unmodifiableSet(new HashSet<Record>(this.records)));
    }

    public String getUserVisibleName() {
        PtrRecord ptrRecord = null;
        for (Record record : this.records) {
            if (!(record instanceof PtrRecord)) continue;
            ptrRecord = (PtrRecord)record;
            break;
        }
        if (ptrRecord != null) {
            return ptrRecord.getUserVisibleName();
        }
        WizardLogger.getLogger().log(Level.INFO, "No PTR records: {}", this.records);
        throw new IllegalStateException("Cannot call getUserVisibleName when no PTR record is available");
    }

    public boolean answers(Set<Question> set) {
        for (Record record : this.records) {
            String string = record.getName();
            for (Question question : set) {
                if (!string.equals(question.getQName())) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "Response{questions=" + this.questions + ", records=" + this.records + ", numQuestions=" + this.numQuestions + ", numAnswers=" + this.numAnswers + ", numNameServers=" + this.numNameServers + ", numAdditionalRecords=" + this.numAdditionalRecords + '}';
    }

    int getNumQuestions() {
        return this.numQuestions;
    }

    int getNumAnswers() {
        return this.numAnswers;
    }

    int getNumNameServers() {
        return this.numNameServers;
    }

    int getNumAdditionalRecords() {
        return this.numAdditionalRecords;
    }
}

