/*
 * Decompiled with CFR 0.152.
 */
package net.straylightlabs.hola.dns;

import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.straylightlabs.hola.dns.ARecord;
import net.straylightlabs.hola.dns.AaaaRecord;
import net.straylightlabs.hola.dns.PtrRecord;
import net.straylightlabs.hola.dns.SrvRecord;
import net.straylightlabs.hola.dns.TxtRecord;
import net.straylightlabs.hola.dns.UnknownRecord;

public abstract class Record {
    protected final String name;
    protected final long ttl;
    protected final Class recordClass;
    public static final int USHORT_MASK = 65535;
    public static final long UINT_MASK = 0xFFFFFFFFL;

    public static Record fromBuffer(ByteBuffer byteBuffer, MulticastSocket multicastSocket) {
        String string = Record.readNameFromBuffer(byteBuffer);
        Type type = Type.fromInt(byteBuffer.getShort() & 0xFFFF);
        int n2 = byteBuffer.getShort() & 0xFFFF;
        int n3 = n2 & Short.MAX_VALUE;
        Class clazz = Class.fromInt(n3);
        long l2 = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
        int n4 = byteBuffer.getShort() & 0xFFFF;
        NetworkInterface networkInterface = null;
        try {
            networkInterface = multicastSocket.getNetworkInterface();
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        switch (type) {
            case A: {
                try {
                    return new ARecord(byteBuffer, string, clazz, l2);
                }
                catch (UnknownHostException unknownHostException) {
                    throw new IllegalArgumentException("Buffer does not represent a valid A record");
                }
            }
            case AAAA: {
                try {
                    return new AaaaRecord(byteBuffer, string, clazz, l2, networkInterface);
                }
                catch (UnknownHostException unknownHostException) {
                    if (networkInterface != null) {
                        throw new IllegalArgumentException("Buffer does not represent a valid AAAA record");
                    }
                    return new UnknownRecord(byteBuffer, string, clazz, l2, n4);
                }
            }
            case PTR: {
                return new PtrRecord(byteBuffer, string, clazz, l2, n4);
            }
            case SRV: {
                return new SrvRecord(byteBuffer, string, clazz, l2);
            }
            case TXT: {
                return new TxtRecord(byteBuffer, string, clazz, l2, n4);
            }
        }
        return new UnknownRecord(byteBuffer, string, clazz, l2, n4);
    }

    protected Record(String string, Class clazz, long l2) {
        this.name = string;
        this.recordClass = clazz;
        this.ttl = l2;
    }

    public static String readNameFromBuffer(ByteBuffer byteBuffer) {
        int n2;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = -1;
        do {
            byteBuffer.mark();
            n2 = byteBuffer.get() & 0xFF;
            if (Record.isPointer(n2)) {
                byteBuffer.reset();
                int n4 = byteBuffer.getShort() & 0x3FFF;
                if (n3 < 0) {
                    n3 = byteBuffer.position();
                }
                byteBuffer.position(n4);
                continue;
            }
            String string = Record.readLabel(byteBuffer, n2);
            arrayList.add(string);
        } while (n2 != 0);
        if (n3 >= 0) {
            byteBuffer.position(n3);
        }
        return arrayList.stream().collect(Collectors.joining("."));
    }

    private static boolean isPointer(int n2) {
        return (n2 & 0xC0) == 192;
    }

    private static String readLabel(ByteBuffer byteBuffer, int n2) {
        String string = "";
        if (n2 > 0) {
            byte[] byArray = new byte[n2];
            byteBuffer.get(byArray);
            string = new String(byArray, StandardCharsets.UTF_8);
        }
        return string;
    }

    public static List<String> readStringsFromBuffer(ByteBuffer byteBuffer, int n2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (n2 > 0) {
            int n3;
            int n4 = 0;
            do {
                n3 = byteBuffer.get() & 0xFF;
                String string = Record.readLabel(byteBuffer, n3);
                arrayList.add(string);
            } while ((n4 += n3 + 1) < n2);
        }
        return arrayList;
    }

    public String getName() {
        return this.name;
    }

    public long getTTL() {
        return this.ttl;
    }

    public String toString() {
        return "Record{name='" + this.name + '\'' + ", recordClass=" + (Object)((Object)this.recordClass) + ", ttl=" + this.ttl + '}';
    }

    static enum Class {
        IN(1);

        private final int value;

        public static Class fromInt(int n2) {
            for (Class clazz : Class.values()) {
                if (clazz.value != n2) continue;
                return clazz;
            }
            throw new IllegalArgumentException(String.format("Can't convert 0x%04x to a Class", n2));
        }

        private Class(int n3) {
            this.value = n3;
        }

        public int asUnsignedShort() {
            return this.value & 0xFFFF;
        }
    }

    static enum Type {
        UNSUPPORTED(0),
        A(1),
        NS(2),
        CNAME(5),
        SOA(6),
        NULL(10),
        WKS(11),
        PTR(12),
        HINFO(13),
        MINFO(14),
        MX(15),
        TXT(16),
        AAAA(28),
        SRV(33);

        private final int value;

        public static Type fromInt(int n2) {
            for (Type type : Type.values()) {
                if (type.value != n2) continue;
                return type;
            }
            return UNSUPPORTED;
        }

        private Type(int n3) {
            this.value = n3;
        }

        public int asUnsignedShort() {
            return this.value & 0xFFFF;
        }
    }
}

