/*
 * Decompiled with CFR 0.152.
 */
package net.straylightlabs.hola.dns;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import net.straylightlabs.hola.dns.Domain;
import net.straylightlabs.hola.dns.Message;
import net.straylightlabs.hola.dns.Record;
import net.straylightlabs.hola.sd.Service;
import roomeqwizard.WizardLogger;

public class Question
extends Message {
    private final String qName;
    private final QType qType;
    private final QClass qClass;
    private static final short UNICAST_RESPONSE_BIT = Short.MIN_VALUE;

    public static Question fromBuffer(ByteBuffer byteBuffer) {
        String string = Record.readNameFromBuffer(byteBuffer);
        QType qType = QType.fromInt(byteBuffer.getShort() & 0xFFFF);
        QClass qClass = QClass.fromInt(byteBuffer.getShort() & 0xFFFF);
        return new Question(string, qType, qClass);
    }

    public Question(String string, QType qType, QClass qClass) {
        this.qName = string;
        this.qType = qType;
        this.qClass = qClass;
        this.build();
    }

    public Question(Service service, Domain domain) {
        this.qName = service.getName() + "." + domain.getName();
        this.qType = QType.PTR;
        this.qClass = QClass.IN;
        this.build();
    }

    private void build() {
        this.buildHeader();
        for (String string : this.qName.split("\\.")) {
            this.addLabelToBuffer(string);
        }
        this.addLabelToBuffer("");
        this.buffer.putShort((short)this.qType.asUnsignedShort());
        this.buffer.putShort((short)this.qClass.asUnsignedShort());
    }

    private void addLabelToBuffer(String string) {
        byte[] byArray = string.getBytes();
        this.buffer.put((byte)(byArray.length & 0xFF));
        this.buffer.put(byArray);
    }

    private void buildHeader() {
        this.buffer.putShort((short)0);
        this.buffer.put((byte)0);
        this.buffer.put((byte)0);
        this.buffer.putShort((short)1);
        this.buffer.putShort((short)0);
        this.buffer.putInt(0);
    }

    public void askOn(MulticastSocket multicastSocket, InetAddress inetAddress) throws IOException {
        try {
            this.askWithGroup(inetAddress, multicastSocket);
        }
        catch (UnknownHostException unknownHostException) {
            WizardLogger.getLogger().log(Level.SEVERE, "UnknownHostException {0}", unknownHostException);
        }
    }

    private void askWithGroup(InetAddress inetAddress, MulticastSocket multicastSocket) throws IOException {
        DatagramPacket datagramPacket = new DatagramPacket(this.buffer.array(), this.buffer.position(), inetAddress, 5353);
        datagramPacket.setAddress(inetAddress);
        multicastSocket.send(datagramPacket);
    }

    public boolean answeredBy(Record record) {
        return record.getName().equals(this.qName);
    }

    String getQName() {
        return this.qName;
    }

    QType getQType() {
        return this.qType;
    }

    QClass getQClass() {
        return this.qClass;
    }

    public String toString() {
        return "Question{qName=" + this.qName + ", qType=" + (Object)((Object)this.qType) + ", qClass=" + (Object)((Object)this.qClass) + '}';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Question question = (Question)object;
        return this.qName.equals(question.qName) && this.qType == question.qType && this.qClass == question.qClass;
    }

    public int hashCode() {
        int n2 = this.qName.hashCode();
        n2 = 31 * n2 + this.qType.hashCode();
        n2 = 31 * n2 + this.qClass.hashCode();
        return n2;
    }

    public static enum QClass {
        IN(1),
        ANY(255);

        private final int value;

        public static QClass fromInt(int n2) {
            for (QClass qClass : QClass.values()) {
                if (qClass.value != (n2 & Short.MAX_VALUE)) continue;
                return qClass;
            }
            throw new IllegalArgumentException("Can't convert " + n2 + " to a QClass");
        }

        private QClass(int n3) {
            this.value = n3;
        }

        public int asUnsignedShort() {
            return this.value & 0xFFFF;
        }
    }

    public static enum QType {
        A(1),
        NS(2),
        CNAME(5),
        SOA(6),
        MB(7),
        MG(8),
        MR(9),
        NULL(10),
        WKS(11),
        PTR(12),
        HINFO(13),
        MINFO(14),
        MX(15),
        TXT(16),
        AAAA(28),
        SRV(33),
        ANY(255);

        private final int value;

        public static QType fromInt(int n2) {
            for (QType qType : QType.values()) {
                if (qType.value != n2) continue;
                return qType;
            }
            throw new IllegalArgumentException("Can't convert " + n2 + " to a QType");
        }

        private QType(int n3) {
            this.value = n3;
        }

        public int asUnsignedShort() {
            return this.value & 0xFFFF;
        }
    }
}

