/*
 * Decompiled with CFR 0.152.
 */
package net.straylightlabs.hola.dns;

import java.nio.ByteBuffer;
import net.straylightlabs.hola.dns.Record;

public class PtrRecord
extends Record {
    private final String userVisibleName;
    private final String ptrName;
    public static final String UNTITLED_NAME = "Untitled";

    public PtrRecord(ByteBuffer byteBuffer, String string, Record.Class clazz, long l2, int n2) {
        super(string, clazz, l2);
        this.ptrName = n2 > 0 ? PtrRecord.readNameFromBuffer(byteBuffer) : "";
        this.userVisibleName = this.buildUserVisibleName();
    }

    public String getPtrName() {
        return this.ptrName;
    }

    public String getUserVisibleName() {
        return this.userVisibleName;
    }

    private String buildUserVisibleName() {
        String[] stringArray = this.ptrName.split("\\.");
        if (stringArray[0].length() > 0) {
            return stringArray[0];
        }
        return UNTITLED_NAME;
    }

    @Override
    public String toString() {
        return "PtrRecord{name='" + this.name + '\'' + ", recordClass=" + (Object)((Object)this.recordClass) + ", ttl=" + this.ttl + ", ptrName='" + this.ptrName + '\'' + '}';
    }
}

