/*
 * Decompiled with CFR 0.152.
 */
package net.straylightlabs.hola.dns;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Domain {
    private final String name;
    private final List<String> labels;
    public static final Domain LOCAL = new Domain("local.");
    private static final Pattern DOMAIN_PATTERN = Pattern.compile("((.*)_(tcp|udp)\\.)?(.*?)\\.?");

    public static Domain fromName(String string) {
        Matcher matcher = DOMAIN_PATTERN.matcher(string);
        if (matcher.matches()) {
            return new Domain(matcher.group(4));
        }
        throw new IllegalArgumentException("Name does not match domain syntax");
    }

    private Domain(String string) {
        this.name = string;
        this.labels = Arrays.asList(string.split("\\."));
    }

    public String getName() {
        return this.name;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Domain domain = (Domain)object;
        return this.name.equals(domain.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "Domain{name='" + this.name + '\'' + ", labels=" + this.labels + '}';
    }
}

