/*
 * Decompiled with CFR 0.152.
 */
package net.straylightlabs.hola.dns;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import net.straylightlabs.hola.dns.Record;

public class AaaaRecord
extends Record {
    private InetAddress address;

    public AaaaRecord(ByteBuffer byteBuffer, String string, Record.Class clazz, long l2, NetworkInterface networkInterface) throws UnknownHostException {
        super(string, clazz, l2);
        byte[] byArray = new byte[16];
        byteBuffer.get(byArray);
        if (byArray[0] == -2 && byArray[1] < 0) {
            if (networkInterface == null) {
                throw new UnknownHostException("Interface unknown");
            }
            this.address = Inet6Address.getByAddress(null, byArray, networkInterface);
        } else {
            this.address = Inet6Address.getByAddress(null, byArray);
        }
    }

    public InetAddress getAddress() {
        return this.address;
    }

    @Override
    public String toString() {
        return "AaaaRecord{name='" + this.name + '\'' + ", recordClass=" + (Object)((Object)this.recordClass) + ", ttl=" + this.ttl + ", address=" + this.address + '}';
    }
}

