/*
 * Decompiled with CFR 0.152.
 */
package io.github.manusant.ss.rest;

import spark.Response;

public class RestResponse {
    private int statusCode;
    private String body;

    public RestResponse(int n2, String string) {
        this.statusCode = n2;
        this.body = string;
    }

    public RestResponse(Response response) {
        this.statusCode = response.status();
        this.body = response.body();
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int n2) {
        this.statusCode = n2;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String string) {
        this.body = string;
    }

    public static RestResponse ok(Response response) {
        response.status(204);
        response.body("Request Successfully processed");
        return new RestResponse(response);
    }

    public static <R> R ok(Response response, R r2) {
        response.status(200);
        return r2;
    }

    public static RestResponse error(Response response) {
        response.status(500);
        response.body("Something goes wrong wile processing request");
        return new RestResponse(response);
    }

    public static RestResponse error(Response response, String string) {
        response.status(500);
        response.body(string);
        return new RestResponse(response);
    }

    public static RestResponse badRequest(Response response, String string) {
        response.status(400);
        response.body(string);
        return new RestResponse(response);
    }

    public static RestResponse notFound(Response response, String string) {
        response.status(404);
        response.body(string);
        return new RestResponse(response);
    }

    public static RestResponse notImplemented(Response response) {
        response.status(501);
        response.body("Request service not implemented yet");
        return new RestResponse(response);
    }

    public static RestResponse notImplemented(Response response, String string) {
        response.status(501);
        response.body(string);
        return new RestResponse(response);
    }
}

