/*
 * Decompiled with CFR 0.152.
 */
package io.github.manusant.ss.model.utils;

import io.github.manusant.ss.model.AbstractModel;
import io.github.manusant.ss.model.ArrayModel;
import io.github.manusant.ss.model.ComposedModel;
import io.github.manusant.ss.model.Model;
import io.github.manusant.ss.model.ModelImpl;
import io.github.manusant.ss.model.RefModel;
import io.github.manusant.ss.model.Xml;
import io.github.manusant.ss.model.properties.AbstractProperty;
import io.github.manusant.ss.model.properties.ArrayProperty;
import io.github.manusant.ss.model.properties.MapProperty;
import io.github.manusant.ss.model.properties.ObjectProperty;
import io.github.manusant.ss.model.properties.Property;
import io.github.manusant.ss.model.properties.PropertyBuilder;
import io.github.manusant.ss.model.properties.RefProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class PropertyModelConverter {
    public Property modelToProperty(Model model) {
        if (model instanceof ModelImpl) {
            ModelImpl modelImpl = (ModelImpl)model;
            if (modelImpl.getAdditionalProperties() != null) {
                MapProperty mapProperty = new MapProperty();
                mapProperty.setType(modelImpl.getType());
                mapProperty.setAllowEmptyValue(modelImpl.getAllowEmptyValue());
                mapProperty.setDefault((String)modelImpl.getDefaultValue());
                mapProperty.setDescription(modelImpl.getDescription());
                mapProperty.setExample(modelImpl.getExample());
                mapProperty.setFormat(modelImpl.getFormat());
                mapProperty.setName(modelImpl.getName());
                mapProperty.setTitle(modelImpl.getTitle());
                List<String> list = modelImpl.getRequired();
                if (list != null) {
                    for (String string : list) {
                        if (!modelImpl.getName().equals(string)) continue;
                        mapProperty.setRequired(true);
                    }
                }
                mapProperty.setXml(modelImpl.getXml());
                mapProperty.setVendorExtensions(modelImpl.getVendorExtensions());
                mapProperty.setAdditionalProperties(modelImpl.getAdditionalProperties());
                return mapProperty;
            }
            Property property = this.propertyByType(modelImpl);
            if (property instanceof ObjectProperty) {
                ObjectProperty objectProperty = (ObjectProperty)property;
                objectProperty.setProperties(model.getProperties());
                objectProperty.setExample(model.getExample());
                return objectProperty;
            }
            return property;
        }
        if (model instanceof ArrayModel) {
            ArrayModel arrayModel = (ArrayModel)model;
            ArrayProperty arrayProperty = new ArrayProperty();
            Property property = arrayModel.getItems();
            arrayProperty.setItems(property);
            arrayProperty.setExample(arrayModel.getExample());
            arrayProperty.setMaxItems(arrayModel.getMaxItems());
            arrayProperty.setMinItems(arrayModel.getMinItems());
            arrayProperty.setDescription(arrayModel.getDescription());
            arrayProperty.setTitle(arrayModel.getTitle());
            arrayProperty.setUniqueItems(arrayModel.getUniqueItems());
            return arrayProperty;
        }
        if (model instanceof RefModel) {
            RefModel refModel = (RefModel)model;
            RefProperty refProperty = new RefProperty(refModel.get$ref());
            return refProperty;
        }
        if (model instanceof ComposedModel) {
            ObjectProperty objectProperty = new ObjectProperty();
            objectProperty.setDescription(model.getDescription());
            objectProperty.setTitle(model.getTitle());
            objectProperty.setExample(model.getExample());
            ComposedModel composedModel = (ComposedModel)model;
            HashSet<String> hashSet = new HashSet<String>();
            for (Model object : composedModel.getAllOf()) {
                AbstractProperty abstractProperty;
                Property property = this.modelToProperty(object);
                if (property instanceof RefProperty) {
                    abstractProperty = (RefProperty)property;
                    objectProperty.property(((RefProperty)abstractProperty).getSimpleRef(), property);
                    continue;
                }
                if (!(property instanceof ObjectProperty)) continue;
                abstractProperty = (ObjectProperty)property;
                if (((ObjectProperty)abstractProperty).getProperties() != null) {
                    for (String string : ((ObjectProperty)abstractProperty).getProperties().keySet()) {
                        objectProperty.property(string, ((ObjectProperty)abstractProperty).getProperties().get(string));
                    }
                }
                if (((ObjectProperty)abstractProperty).getRequiredProperties() == null) continue;
                for (String string : ((ObjectProperty)abstractProperty).getRequiredProperties()) {
                    hashSet.add(string);
                }
            }
            if (hashSet.size() > 0) {
                objectProperty.setRequiredProperties(new ArrayList<String>(hashSet));
            }
            if (composedModel.getVendorExtensions() != null) {
                for (String string : composedModel.getVendorExtensions().keySet()) {
                    objectProperty.vendorExtension(string, composedModel.getVendorExtensions().get(string));
                }
            }
            return objectProperty;
        }
        return null;
    }

    private Property propertyByType(ModelImpl modelImpl) {
        return PropertyBuilder.build(modelImpl.getType(), modelImpl.getFormat(), this.argsFromModel(modelImpl));
    }

    private Map<PropertyBuilder.PropertyId, Object> argsFromModel(ModelImpl modelImpl) {
        if (modelImpl == null) {
            return Collections.emptyMap();
        }
        EnumMap<PropertyBuilder.PropertyId, Object> enumMap = new EnumMap<PropertyBuilder.PropertyId, Object>(PropertyBuilder.PropertyId.class);
        enumMap.put(PropertyBuilder.PropertyId.DESCRIPTION, modelImpl.getDescription());
        enumMap.put(PropertyBuilder.PropertyId.EXAMPLE, modelImpl.getExample());
        enumMap.put(PropertyBuilder.PropertyId.ENUM, modelImpl.getEnum());
        enumMap.put(PropertyBuilder.PropertyId.TITLE, modelImpl.getTitle());
        enumMap.put(PropertyBuilder.PropertyId.DEFAULT, modelImpl.getDefaultValue());
        enumMap.put(PropertyBuilder.PropertyId.DESCRIMINATOR, modelImpl.getDiscriminator());
        enumMap.put(PropertyBuilder.PropertyId.MINIMUM, modelImpl.getMinimum());
        enumMap.put(PropertyBuilder.PropertyId.MAXIMUM, modelImpl.getMaximum());
        enumMap.put(PropertyBuilder.PropertyId.UNIQUE_ITEMS, modelImpl.getUniqueItems());
        enumMap.put(PropertyBuilder.PropertyId.VENDOR_EXTENSIONS, modelImpl.getVendorExtensions());
        return enumMap;
    }

    public Model propertyToModel(Property property) {
        Object object;
        String string = property.getDescription();
        String string2 = property.getType();
        String string3 = property.getFormat();
        Object var5_5 = null;
        String string4 = property.getTitle();
        Boolean bl = property.getAllowEmptyValue();
        if (property instanceof RefProperty) {
            RefProperty refProperty = (RefProperty)property;
            RefModel refModel = new RefModel(refProperty.get$ref());
            refModel.setTitle(string4);
            refModel.setExample(property.getExample());
            return refModel;
        }
        Map<String, Object> map = property.getVendorExtensions();
        Property property2 = null;
        if (property instanceof MapProperty) {
            property2 = ((MapProperty)property).getAdditionalProperties();
        }
        String string5 = property.getName();
        Xml xml = property.getXml();
        Map<String, Property> map2 = null;
        if (property instanceof ObjectProperty) {
            object = (ObjectProperty)property;
            map2 = ((ObjectProperty)object).getProperties();
        }
        if (property instanceof ArrayProperty) {
            object = (ArrayProperty)property;
            ArrayModel arrayModel = new ArrayModel();
            arrayModel.setItems(((ArrayProperty)object).getItems());
            arrayModel.setDescription(string);
            arrayModel.setExample(var5_5);
            arrayModel.setUniqueItems(((ArrayProperty)object).getUniqueItems());
            if (map != null) {
                arrayModel.setVendorExtensions(map);
            }
            if (map2 != null) {
                arrayModel.setProperties(map2);
            }
            return arrayModel;
        }
        object = new ModelImpl();
        ((ModelImpl)object).setDescription(string);
        ((ModelImpl)object).setExample(property.getExample());
        ((AbstractModel)object).setTitle(string4);
        ((ModelImpl)object).setName(string5);
        ((AbstractModel)object).setXml(xml);
        ((ModelImpl)object).setType(string2);
        ((ModelImpl)object).setFormat(string3);
        ((ModelImpl)object).setAllowEmptyValue(bl);
        if (map != null) {
            ((AbstractModel)object).setVendorExtensions(map);
        }
        if (property2 != null) {
            ((ModelImpl)object).setAdditionalProperties(property2);
        }
        if (map2 != null) {
            ((ModelImpl)object).setProperties(map2);
        }
        return object;
    }
}

