/*
 * Decompiled with CFR 0.152.
 */
package io.github.manusant.ss.model.refs;

import io.github.manusant.ss.model.refs.RefFormat;
import io.github.manusant.ss.model.refs.RefType;

public class GenericRef {
    private RefFormat format;
    private RefType type;
    private String ref;
    private String simpleRef;

    public GenericRef() {
    }

    public GenericRef(RefType refType, String string) {
        this.format = GenericRef.computeRefFormat(string);
        this.type = refType;
        this.ref = this.format == RefFormat.INTERNAL && !string.startsWith("#/") ? refType.getInternalPrefix() + string : string;
        this.simpleRef = GenericRef.computeSimpleRef(this.ref, this.format, refType);
    }

    public RefFormat getFormat() {
        return this.format;
    }

    public RefType getType() {
        return this.type;
    }

    public String getRef() {
        return this.ref;
    }

    public String getSimpleRef() {
        return this.simpleRef;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GenericRef)) {
            return false;
        }
        GenericRef genericRef = (GenericRef)object;
        if (this.format != genericRef.format) {
            return false;
        }
        if (this.type != genericRef.type) {
            return false;
        }
        if (this.ref != null ? !this.ref.equals(genericRef.ref) : genericRef.ref != null) {
            return false;
        }
        return this.simpleRef != null ? this.simpleRef.equals(genericRef.simpleRef) : genericRef.simpleRef == null;
    }

    public int hashCode() {
        int n2 = this.format != null ? this.format.hashCode() : 0;
        n2 = 31 * n2 + (this.type != null ? this.type.hashCode() : 0);
        n2 = 31 * n2 + (this.ref != null ? this.ref.hashCode() : 0);
        n2 = 31 * n2 + (this.simpleRef != null ? this.simpleRef.hashCode() : 0);
        return n2;
    }

    private static String computeSimpleRef(String string, RefFormat refFormat, RefType refType) {
        String string2 = string;
        if (refFormat == RefFormat.INTERNAL) {
            String string3 = refType.getInternalPrefix();
            string2 = string.substring(string.lastIndexOf("/") + 1);
        }
        return string2;
    }

    private static RefFormat computeRefFormat(String string) {
        RefFormat refFormat = RefFormat.INTERNAL;
        if (string.startsWith("http:") || string.startsWith("https:")) {
            refFormat = RefFormat.URL;
        } else if (string.startsWith("#/")) {
            refFormat = RefFormat.INTERNAL;
        } else if (string.startsWith(".") || string.startsWith("/")) {
            refFormat = RefFormat.RELATIVE;
        }
        return refFormat;
    }
}

