/*
 * Decompiled with CFR 0.152.
 */
package io.github.manusant.ss.model.properties;

import io.github.manusant.ss.model.ArrayModel;
import io.github.manusant.ss.model.Model;
import io.github.manusant.ss.model.ModelImpl;
import io.github.manusant.ss.model.RefModel;
import io.github.manusant.ss.model.properties.AbstractNumericProperty;
import io.github.manusant.ss.model.properties.AbstractProperty;
import io.github.manusant.ss.model.properties.ArrayProperty;
import io.github.manusant.ss.model.properties.BaseIntegerProperty;
import io.github.manusant.ss.model.properties.BinaryProperty;
import io.github.manusant.ss.model.properties.BooleanProperty;
import io.github.manusant.ss.model.properties.ByteArrayProperty;
import io.github.manusant.ss.model.properties.DateProperty;
import io.github.manusant.ss.model.properties.DateTimeProperty;
import io.github.manusant.ss.model.properties.DecimalProperty;
import io.github.manusant.ss.model.properties.DoubleProperty;
import io.github.manusant.ss.model.properties.EmailProperty;
import io.github.manusant.ss.model.properties.FileProperty;
import io.github.manusant.ss.model.properties.FloatProperty;
import io.github.manusant.ss.model.properties.IntegerProperty;
import io.github.manusant.ss.model.properties.LongProperty;
import io.github.manusant.ss.model.properties.MapProperty;
import io.github.manusant.ss.model.properties.ObjectProperty;
import io.github.manusant.ss.model.properties.Property;
import io.github.manusant.ss.model.properties.RefProperty;
import io.github.manusant.ss.model.properties.StringProperty;
import io.github.manusant.ss.model.properties.UUIDProperty;
import io.github.manusant.ss.model.properties.UntypedProperty;
import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyBuilder {
    static final Logger LOGGER = LoggerFactory.getLogger(PropertyBuilder.class);

    public static Property build(String string, String string2, Map<PropertyId, Object> map) {
        Map<PropertyId, Object> map2;
        Map<PropertyId, Object> map3;
        Processor processor = Processor.fromType(string, string2);
        if (processor == null) {
            return null;
        }
        Map<Object, Object> map4 = map3 = map == null ? Collections.emptyMap() : map;
        if (string2 != null) {
            map2 = new EnumMap(PropertyId.class);
            map2.putAll(map3);
            map2.put(PropertyId.FORMAT, string2);
        } else {
            map2 = map3;
        }
        return processor.build(map2);
    }

    public static Property merge(Property property, Map<PropertyId, Object> map) {
        Processor processor;
        if (map != null && !map.isEmpty() && (processor = Processor.fromProperty(property)) != null) {
            processor.merge(property, map);
        }
        return property;
    }

    public static Model toModel(Property property) {
        Processor processor = Processor.fromProperty(property);
        if (processor != null) {
            return processor.toModel(property);
        }
        return null;
    }

    private static enum Processor {
        BOOLEAN(BooleanProperty.class){

            @Override
            protected boolean isType(String string, String string2) {
                return BooleanProperty.isType(string, string2);
            }

            @Override
            protected BooleanProperty create() {
                return new BooleanProperty();
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> map) {
                super.merge(property, map);
                if (property instanceof BooleanProperty) {
                    BooleanProperty booleanProperty = (BooleanProperty)property;
                    if (map.containsKey((Object)PropertyId.DEFAULT)) {
                        String string = (String)PropertyId.DEFAULT.findValue(map);
                        if (string != null) {
                            booleanProperty.setDefault(string);
                        } else {
                            booleanProperty.setDefault((Boolean)null);
                        }
                    }
                }
                return property;
            }
        }
        ,
        BYTE_ARRAY(ByteArrayProperty.class){

            @Override
            protected boolean isType(String string, String string2) {
                return ByteArrayProperty.isType(string, string2);
            }

            @Override
            protected ByteArrayProperty create() {
                return new ByteArrayProperty();
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> map) {
                super.merge(property, map);
                if (property instanceof ByteArrayProperty) {
                    ByteArrayProperty byteArrayProperty = (ByteArrayProperty)property;
                    this.mergeString(byteArrayProperty, map);
                    byteArrayProperty.setEnum(null);
                    byteArrayProperty.setPattern("^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$");
                }
                return property;
            }

            @Override
            public Model toModel(Property property) {
                if (this.isType(property)) {
                    return this.createStringModel((StringProperty)property);
                }
                return null;
            }
        }
        ,
        BINARY(BinaryProperty.class){

            @Override
            protected boolean isType(String string, String string2) {
                return BinaryProperty.isType(string, string2);
            }

            @Override
            protected BinaryProperty create() {
                return new BinaryProperty();
            }
        }
        ,
        DATE(DateProperty.class){

            @Override
            protected boolean isType(String string, String string2) {
                return DateProperty.isType(string, string2);
            }

            @Override
            protected DateProperty create() {
                return new DateProperty();
            }
        }
        ,
        DATE_TIME(DateTimeProperty.class){

            @Override
            protected boolean isType(String string, String string2) {
                return DateTimeProperty.isType(string, string2);
            }

            @Override
            protected DateTimeProperty create() {
                return new DateTimeProperty();
            }
        }
        ,
        INT(IntegerProperty.class){

            @Override
            protected boolean isType(String string, String string2) {
                return IntegerProperty.isType(string, string2);
            }

            @Override
            protected IntegerProperty create() {
                return new IntegerProperty();
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> map) {
                super.merge(property, map);
                if (property instanceof IntegerProperty) {
                    IntegerProperty integerProperty = (IntegerProperty)property;
                    this.mergeNumeric(integerProperty, map);
                    if (map.containsKey((Object)PropertyId.DEFAULT)) {
                        String string = (String)PropertyId.DEFAULT.findValue(map);
                        if (string != null) {
                            integerProperty.setDefault(string);
                        } else {
                            integerProperty.setDefault((Integer)null);
                        }
                    }
                }
                return property;
            }

            @Override
            public Model toModel(Property property) {
                if (this.isType(property)) {
                    IntegerProperty integerProperty = (IntegerProperty)property;
                    ModelImpl modelImpl = this.createModel(integerProperty);
                    Integer n2 = integerProperty.getDefault();
                    if (n2 != null) {
                        modelImpl.setDefaultValue(n2.toString());
                    }
                    return modelImpl;
                }
                return null;
            }
        }
        ,
        LONG(LongProperty.class){

            @Override
            protected boolean isType(String string, String string2) {
                return LongProperty.isType(string, string2);
            }

            @Override
            protected LongProperty create() {
                return new LongProperty();
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> map) {
                super.merge(property, map);
                if (property instanceof LongProperty) {
                    LongProperty longProperty = (LongProperty)property;
                    this.mergeNumeric(longProperty, map);
                    if (map.containsKey((Object)PropertyId.DEFAULT)) {
                        String string = (String)PropertyId.DEFAULT.findValue(map);
                        if (string != null) {
                            longProperty.setDefault(string);
                        } else {
                            longProperty.setDefault((Long)null);
                        }
                    }
                }
                return property;
            }

            @Override
            public Model toModel(Property property) {
                if (this.isType(property)) {
                    LongProperty longProperty = (LongProperty)property;
                    ModelImpl modelImpl = this.createModel(longProperty);
                    Long l2 = longProperty.getDefault();
                    if (l2 != null) {
                        modelImpl.setDefaultValue(l2.toString());
                    }
                    return modelImpl;
                }
                return null;
            }
        }
        ,
        FLOAT(FloatProperty.class){

            @Override
            protected boolean isType(String string, String string2) {
                return FloatProperty.isType(string, string2);
            }

            @Override
            protected FloatProperty create() {
                return new FloatProperty();
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> map) {
                super.merge(property, map);
                if (property instanceof FloatProperty) {
                    FloatProperty floatProperty = (FloatProperty)property;
                    this.mergeNumeric(floatProperty, map);
                    if (map.containsKey((Object)PropertyId.DEFAULT)) {
                        String string = (String)PropertyId.DEFAULT.findValue(map);
                        if (string != null) {
                            floatProperty.setDefault(string);
                        } else {
                            floatProperty.setDefault((Float)null);
                        }
                    }
                }
                return property;
            }

            @Override
            public Model toModel(Property property) {
                if (this.isType(property)) {
                    FloatProperty floatProperty = (FloatProperty)property;
                    ModelImpl modelImpl = this.createModel(floatProperty);
                    Float f2 = floatProperty.getDefault();
                    if (f2 != null) {
                        modelImpl.setDefaultValue(f2.toString());
                    }
                    return modelImpl;
                }
                return null;
            }
        }
        ,
        DOUBLE(DoubleProperty.class){

            @Override
            protected boolean isType(String string, String string2) {
                return DoubleProperty.isType(string, string2);
            }

            @Override
            protected DoubleProperty create() {
                return new DoubleProperty();
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> map) {
                super.merge(property, map);
                if (property instanceof DoubleProperty) {
                    DoubleProperty doubleProperty = (DoubleProperty)property;
                    this.mergeNumeric(doubleProperty, map);
                    if (map.containsKey((Object)PropertyId.DEFAULT)) {
                        String string = (String)PropertyId.DEFAULT.findValue(map);
                        if (string != null) {
                            doubleProperty.setDefault(string);
                        } else {
                            doubleProperty.setDefault((Double)null);
                        }
                    }
                }
                return property;
            }

            @Override
            public Model toModel(Property property) {
                if (this.isType(property)) {
                    DoubleProperty doubleProperty = (DoubleProperty)property;
                    ModelImpl modelImpl = this.createModel(doubleProperty);
                    Double d2 = doubleProperty.getDefault();
                    if (d2 != null) {
                        modelImpl.setDefaultValue(d2.toString());
                    }
                    return modelImpl;
                }
                return null;
            }
        }
        ,
        INTEGER(BaseIntegerProperty.class){

            @Override
            protected boolean isType(String string, String string2) {
                return BaseIntegerProperty.isType(string, string2);
            }

            @Override
            protected BaseIntegerProperty create() {
                return new BaseIntegerProperty();
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> map) {
                super.merge(property, map);
                if (property instanceof BaseIntegerProperty) {
                    BaseIntegerProperty baseIntegerProperty = (BaseIntegerProperty)property;
                    this.mergeNumeric(baseIntegerProperty, map);
                }
                return property;
            }
        }
        ,
        DECIMAL(DecimalProperty.class){

            @Override
            protected boolean isType(String string, String string2) {
                return DecimalProperty.isType(string, string2);
            }

            @Override
            protected DecimalProperty create() {
                return new DecimalProperty();
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> map) {
                super.merge(property, map);
                if (property instanceof DecimalProperty) {
                    DecimalProperty decimalProperty = (DecimalProperty)property;
                    this.mergeNumeric(decimalProperty, map);
                }
                return property;
            }
        }
        ,
        FILE(FileProperty.class){

            @Override
            protected boolean isType(String string, String string2) {
                return FileProperty.isType(string, string2);
            }

            @Override
            protected FileProperty create() {
                return new FileProperty();
            }
        }
        ,
        REFERENCE(RefProperty.class){

            @Override
            protected boolean isType(String string, String string2) {
                return RefProperty.isType(string, string2);
            }

            @Override
            protected RefProperty create() {
                return new RefProperty();
            }

            @Override
            public Model toModel(Property property) {
                if (property instanceof RefProperty) {
                    RefProperty refProperty = (RefProperty)property;
                    RefModel refModel = new RefModel(refProperty.get$ref());
                    refModel.setDescription(refProperty.getDescription());
                    return refModel;
                }
                return null;
            }
        }
        ,
        E_MAIL(EmailProperty.class){

            @Override
            protected boolean isType(String string, String string2) {
                return EmailProperty.isType(string, string2);
            }

            @Override
            protected EmailProperty create() {
                return new EmailProperty();
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> map) {
                super.merge(property, map);
                if (property instanceof EmailProperty) {
                    this.mergeString((EmailProperty)property, map);
                }
                return property;
            }

            @Override
            public Model toModel(Property property) {
                if (this.isType(property)) {
                    return this.createStringModel((StringProperty)property);
                }
                return null;
            }
        }
        ,
        UUID(UUIDProperty.class){

            @Override
            protected boolean isType(String string, String string2) {
                return UUIDProperty.isType(string, string2);
            }

            @Override
            protected UUIDProperty create() {
                return new UUIDProperty();
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> map) {
                super.merge(property, map);
                if (property instanceof UUIDProperty) {
                    Object object;
                    UUIDProperty uUIDProperty = (UUIDProperty)property;
                    if (map.containsKey((Object)PropertyId.DEFAULT)) {
                        object = (String)PropertyId.DEFAULT.findValue(map);
                        property.setDefault((String)object);
                    }
                    if (map.containsKey((Object)PropertyId.MIN_LENGTH)) {
                        object = (Integer)PropertyId.MIN_LENGTH.findValue(map);
                        uUIDProperty.setMinLength((Integer)object);
                    }
                    if (map.containsKey((Object)PropertyId.MAX_LENGTH)) {
                        object = (Integer)PropertyId.MAX_LENGTH.findValue(map);
                        uUIDProperty.setMaxLength((Integer)object);
                    }
                    if (map.containsKey((Object)PropertyId.PATTERN)) {
                        object = (String)PropertyId.PATTERN.findValue(map);
                        uUIDProperty.setPattern((String)object);
                    }
                }
                return property;
            }

            @Override
            public Model toModel(Property property) {
                if (this.isType(property)) {
                    UUIDProperty uUIDProperty = (UUIDProperty)property;
                    ModelImpl modelImpl = this.createModel(uUIDProperty);
                    modelImpl.setDefaultValue(uUIDProperty.getDefault());
                    return modelImpl;
                }
                return null;
            }
        }
        ,
        OBJECT(ObjectProperty.class){

            @Override
            protected boolean isType(String string, String string2) {
                return ObjectProperty.isType(string, string2);
            }

            @Override
            protected ObjectProperty create() {
                return new ObjectProperty();
            }
        }
        ,
        UNTYPED(UntypedProperty.class){

            @Override
            protected boolean isType(String string, String string2) {
                return UntypedProperty.isType(string, string2);
            }

            @Override
            protected UntypedProperty create() {
                return new UntypedProperty();
            }
        }
        ,
        ARRAY(ArrayProperty.class){

            @Override
            protected boolean isType(String string, String string2) {
                return ArrayProperty.isType(string);
            }

            @Override
            protected ArrayProperty create() {
                return new ArrayProperty();
            }

            @Override
            public Model toModel(Property property) {
                if (property instanceof ArrayProperty) {
                    ArrayProperty arrayProperty = (ArrayProperty)property;
                    ArrayModel arrayModel = new ArrayModel().items(arrayProperty.getItems()).description(arrayProperty.getDescription());
                    return arrayModel;
                }
                return null;
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> map) {
                super.merge(property, map);
                if (property instanceof ArrayProperty) {
                    Constable constable;
                    ArrayProperty arrayProperty = (ArrayProperty)property;
                    if (map.containsKey((Object)PropertyId.MIN_ITEMS)) {
                        constable = (Integer)PropertyId.MIN_ITEMS.findValue(map);
                        arrayProperty.setMinItems((Integer)constable);
                    }
                    if (map.containsKey((Object)PropertyId.MAX_ITEMS)) {
                        constable = (Integer)PropertyId.MAX_ITEMS.findValue(map);
                        arrayProperty.setMaxItems((Integer)constable);
                    }
                    if (map.containsKey((Object)PropertyId.UNIQUE_ITEMS)) {
                        constable = (Boolean)PropertyId.UNIQUE_ITEMS.findValue(map);
                        arrayProperty.setUniqueItems((Boolean)constable);
                    }
                }
                return property;
            }
        }
        ,
        MAP(MapProperty.class){

            @Override
            protected boolean isType(String string, String string2) {
                return MapProperty.isType(string, string2);
            }

            @Override
            protected MapProperty create() {
                return new MapProperty();
            }

            @Override
            public Model toModel(Property property) {
                if (property instanceof MapProperty) {
                    MapProperty mapProperty = (MapProperty)property;
                    return this.createModel(property).additionalProperties(mapProperty.getAdditionalProperties());
                }
                return null;
            }
        }
        ,
        STRING(StringProperty.class){

            @Override
            protected boolean isType(String string, String string2) {
                return StringProperty.isType(string, string2);
            }

            @Override
            protected StringProperty create() {
                return new StringProperty();
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> map) {
                super.merge(property, map);
                if (property instanceof StringProperty) {
                    this.mergeString((StringProperty)property, map);
                }
                return property;
            }

            @Override
            public Model toModel(Property property) {
                if (this.isType(property)) {
                    return this.createStringModel((StringProperty)property);
                }
                return null;
            }
        };

        private final Class<? extends Property> type;

        private Processor(Class<? extends Property> clazz) {
            this.type = clazz;
        }

        public static Processor fromType(String string, String string2) {
            for (Processor processor : Processor.values()) {
                if (!processor.isType(string, string2)) continue;
                return processor;
            }
            LOGGER.debug("no property for " + string + ", " + string2);
            return null;
        }

        public static Processor fromProperty(Property property) {
            for (Processor processor : Processor.values()) {
                if (!processor.isType(property)) continue;
                return processor;
            }
            LOGGER.error("no property for " + (property == null ? "null" : property.getClass().getName()));
            return null;
        }

        protected abstract boolean isType(String var1, String var2);

        protected boolean isType(Property property) {
            return this.type.isInstance(property);
        }

        protected abstract Property create();

        protected <N extends AbstractNumericProperty> N mergeNumeric(N n2, Map<PropertyId, Object> map) {
            Comparable<BigDecimal> comparable;
            if (map.containsKey((Object)PropertyId.MINIMUM) && (comparable = (BigDecimal)PropertyId.MINIMUM.findValue(map)) != null) {
                n2.setMinimum((BigDecimal)comparable);
            }
            if (map.containsKey((Object)PropertyId.MAXIMUM) && (comparable = (BigDecimal)PropertyId.MAXIMUM.findValue(map)) != null) {
                n2.setMaximum((BigDecimal)comparable);
            }
            if (map.containsKey((Object)PropertyId.EXCLUSIVE_MINIMUM)) {
                comparable = (Boolean)PropertyId.EXCLUSIVE_MINIMUM.findValue(map);
                n2.setExclusiveMinimum((Boolean)comparable);
            }
            if (map.containsKey((Object)PropertyId.EXCLUSIVE_MAXIMUM)) {
                comparable = (Boolean)PropertyId.EXCLUSIVE_MAXIMUM.findValue(map);
                n2.setExclusiveMaximum((Boolean)comparable);
            }
            if (map.containsKey((Object)PropertyId.MULTIPLE_OF) && (comparable = (BigDecimal)PropertyId.MULTIPLE_OF.findValue(map)) != null) {
                n2.setMultipleOf((BigDecimal)comparable);
            }
            return n2;
        }

        protected <N extends StringProperty> N mergeString(N n2, Map<PropertyId, Object> map) {
            Object object;
            if (map.containsKey((Object)PropertyId.DEFAULT)) {
                object = (String)PropertyId.DEFAULT.findValue(map);
                n2.setDefault((String)object);
            }
            if (map.containsKey((Object)PropertyId.MIN_LENGTH)) {
                object = (Integer)PropertyId.MIN_LENGTH.findValue(map);
                n2.setMinLength((Integer)object);
            }
            if (map.containsKey((Object)PropertyId.MAX_LENGTH)) {
                object = (Integer)PropertyId.MAX_LENGTH.findValue(map);
                n2.setMaxLength((Integer)object);
            }
            if (map.containsKey((Object)PropertyId.PATTERN)) {
                object = (String)PropertyId.PATTERN.findValue(map);
                n2.setPattern((String)object);
            }
            if (map.containsKey((Object)PropertyId.ENUM)) {
                object = (List)PropertyId.ENUM.findValue(map);
                n2.setEnum((List<String>)object);
            }
            return n2;
        }

        protected ModelImpl createModel(Property property) {
            return new ModelImpl().type(property.getType()).format(property.getFormat()).description(property.getDescription());
        }

        protected ModelImpl createStringModel(StringProperty stringProperty) {
            ModelImpl modelImpl = this.createModel(stringProperty);
            modelImpl.setDefaultValue(stringProperty.getDefault());
            return modelImpl;
        }

        public Property build(Map<PropertyId, Object> map) {
            return this.merge(this.create(), map);
        }

        public Property merge(Property property, Map<PropertyId, Object> map) {
            if (map.containsKey((Object)PropertyId.READ_ONLY)) {
                property.setReadOnly((Boolean)PropertyId.READ_ONLY.findValue(map));
            }
            if (property instanceof AbstractProperty) {
                Object object;
                AbstractProperty abstractProperty = (AbstractProperty)property;
                if (abstractProperty.getFormat() == null) {
                    abstractProperty.setFormat((String)PropertyId.FORMAT.findValue(map));
                }
                if (map.containsKey((Object)PropertyId.ALLOW_EMPTY_VALUE)) {
                    object = (Boolean)PropertyId.ALLOW_EMPTY_VALUE.findValue(map);
                    abstractProperty.setAllowEmptyValue((Boolean)object);
                }
                if (map.containsKey((Object)PropertyId.TITLE)) {
                    object = (String)PropertyId.TITLE.findValue(map);
                    abstractProperty.setTitle((String)object);
                }
                if (map.containsKey((Object)PropertyId.DESCRIPTION)) {
                    object = (String)PropertyId.DESCRIPTION.findValue(map);
                    abstractProperty.setDescription((String)object);
                }
                if (map.containsKey((Object)PropertyId.EXAMPLE)) {
                    object = PropertyId.EXAMPLE.findValue(map);
                    abstractProperty.setExample(object);
                }
                if (map.containsKey((Object)PropertyId.VENDOR_EXTENSIONS)) {
                    object = (Map)PropertyId.VENDOR_EXTENSIONS.findValue(map);
                    abstractProperty.setVendorExtensionMap((Map<String, Object>)object);
                }
                if (map.containsKey((Object)PropertyId.ENUM) && (object = (List)PropertyId.ENUM.findValue(map)) != null) {
                    String string;
                    Iterator iterator;
                    AbstractProperty abstractProperty2;
                    if (property instanceof BooleanProperty) {
                        abstractProperty2 = (BooleanProperty)property;
                        iterator = object.iterator();
                        while (iterator.hasNext()) {
                            string = (String)iterator.next();
                            try {
                                ((BooleanProperty)abstractProperty2)._enum(Boolean.parseBoolean(string));
                            }
                            catch (Exception exception) {}
                        }
                    }
                    if (property instanceof IntegerProperty) {
                        abstractProperty2 = (IntegerProperty)property;
                        iterator = object.iterator();
                        while (iterator.hasNext()) {
                            string = (String)iterator.next();
                            try {
                                ((IntegerProperty)abstractProperty2)._enum(Integer.parseInt(string));
                            }
                            catch (Exception exception) {}
                        }
                    }
                    if (property instanceof LongProperty) {
                        abstractProperty2 = (LongProperty)property;
                        iterator = object.iterator();
                        while (iterator.hasNext()) {
                            string = (String)iterator.next();
                            try {
                                ((LongProperty)abstractProperty2)._enum(Long.parseLong(string));
                            }
                            catch (Exception exception) {}
                        }
                    }
                    if (property instanceof DoubleProperty) {
                        abstractProperty2 = (DoubleProperty)property;
                        iterator = object.iterator();
                        while (iterator.hasNext()) {
                            string = (String)iterator.next();
                            try {
                                ((DoubleProperty)abstractProperty2)._enum(Double.parseDouble(string));
                            }
                            catch (Exception exception) {}
                        }
                    }
                    if (property instanceof FloatProperty) {
                        abstractProperty2 = (FloatProperty)property;
                        iterator = object.iterator();
                        while (iterator.hasNext()) {
                            string = (String)iterator.next();
                            try {
                                ((FloatProperty)abstractProperty2)._enum(Float.valueOf(Float.parseFloat(string)));
                            }
                            catch (Exception exception) {}
                        }
                    }
                    if (property instanceof DateProperty) {
                        abstractProperty2 = (DateProperty)property;
                        iterator = object.iterator();
                        while (iterator.hasNext()) {
                            string = (String)iterator.next();
                            try {
                                ((DateProperty)abstractProperty2)._enum(string);
                            }
                            catch (Exception exception) {}
                        }
                    }
                    if (property instanceof DateTimeProperty) {
                        abstractProperty2 = (DateTimeProperty)property;
                        iterator = object.iterator();
                        while (iterator.hasNext()) {
                            string = (String)iterator.next();
                            try {
                                ((DateTimeProperty)abstractProperty2)._enum(string);
                            }
                            catch (Exception exception) {}
                        }
                    }
                    if (property instanceof UUIDProperty) {
                        abstractProperty2 = (UUIDProperty)property;
                        iterator = object.iterator();
                        while (iterator.hasNext()) {
                            string = (String)iterator.next();
                            try {
                                ((UUIDProperty)abstractProperty2)._enum(string);
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
            }
            return property;
        }

        public Model toModel(Property property) {
            return this.createModel(property);
        }
    }

    public static enum PropertyId {
        ENUM("enum"),
        TITLE("title"),
        DESCRIPTION("description"),
        DEFAULT("default"),
        PATTERN("pattern"),
        DESCRIMINATOR("discriminator"),
        MIN_ITEMS("minItems"),
        MAX_ITEMS("maxItems"),
        MIN_PROPERTIES("minProperties"),
        MAX_PROPERTIES("maxProperties"),
        MIN_LENGTH("minLength"),
        MAX_LENGTH("maxLength"),
        MINIMUM("minimum"),
        MAXIMUM("maximum"),
        EXCLUSIVE_MINIMUM("exclusiveMinimum"),
        EXCLUSIVE_MAXIMUM("exclusiveMaximum"),
        UNIQUE_ITEMS("uniqueItems"),
        EXAMPLE("example"),
        TYPE("type"),
        FORMAT("format"),
        READ_ONLY("readOnly"),
        REQUIRED("required"),
        VENDOR_EXTENSIONS("vendorExtensions"),
        ALLOW_EMPTY_VALUE("allowEmptyValue"),
        MULTIPLE_OF("multipleOf");

        private String propertyName;

        private PropertyId(String string2) {
            this.propertyName = string2;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public <T> T findValue(Map<PropertyId, Object> map) {
            Object object = map.get((Object)this);
            return (T)object;
        }
    }
}

