/*
 * Decompiled with CFR 0.152.
 */
package io.github.manusant.ss.model.properties;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonSetter;
import io.github.manusant.ss.model.Xml;
import io.github.manusant.ss.model.properties.AbstractProperty;
import io.github.manusant.ss.model.properties.Property;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ObjectProperty
extends AbstractProperty
implements Property {
    public static final String TYPE = "object";
    Map<String, Property> properties;

    public ObjectProperty() {
        this.type = TYPE;
    }

    public ObjectProperty(Map<String, Property> map) {
        this.type = TYPE;
        this.properties = map;
    }

    public ObjectProperty vendorExtension(String string, Object object) {
        this.setVendorExtension(string, object);
        return this;
    }

    public static boolean isType(String string) {
        return TYPE.equals(string);
    }

    public static boolean isType(String string, String string2) {
        return ObjectProperty.isType(string);
    }

    public ObjectProperty properties(Map<String, Property> map) {
        this.setProperties(map);
        return this;
    }

    public ObjectProperty property(String string, Property property) {
        if (this.properties == null) {
            this.properties = new TreeMap<String, Property>();
        }
        this.properties.put(string, property);
        return this;
    }

    public ObjectProperty access(String string) {
        this.setAccess(string);
        return this;
    }

    @Override
    public ObjectProperty description(String string) {
        this.setDescription(string);
        return this;
    }

    public ObjectProperty name(String string) {
        this.setName(string);
        return this;
    }

    @Override
    public ObjectProperty title(String string) {
        this.setTitle(string);
        return this;
    }

    public ObjectProperty _default(String string) {
        this.setDefault(string);
        return this;
    }

    public ObjectProperty readOnly(boolean bl) {
        this.setReadOnly(bl);
        return this;
    }

    public ObjectProperty required(boolean bl) {
        this.setRequired(bl);
        return this;
    }

    @Override
    public ObjectProperty readOnly() {
        this.setReadOnly(Boolean.TRUE);
        return this;
    }

    public Map<String, Property> getProperties() {
        return this.properties;
    }

    @JsonGetter(value="required")
    public List<String> getRequiredProperties() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.properties != null) {
            for (String string : this.properties.keySet()) {
                Property property = this.properties.get(string);
                if (property == null || !property.getRequired()) continue;
                arrayList.add(string);
            }
        }
        Collections.sort(arrayList);
        if (arrayList.size() > 0) {
            return arrayList;
        }
        return null;
    }

    @JsonSetter(value="required")
    public void setRequiredProperties(List<String> list) {
        if (this.properties != null) {
            for (String string : list) {
                Property property = this.properties.get(string);
                if (property == null) continue;
                property.setRequired(true);
            }
        }
    }

    public void setProperties(Map<String, Property> map) {
        this.properties = map;
    }

    public ObjectProperty xml(Xml xml) {
        this.setXml(xml);
        return this;
    }

    public ObjectProperty example(Object object) {
        this.setExample(object);
        return this;
    }
}

