/*
 * Decompiled with CFR 0.152.
 */
package io.github.manusant.ss.model.properties;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import io.github.manusant.ss.model.Xml;
import io.github.manusant.ss.model.properties.Property;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class AbstractProperty
implements Property,
Cloneable {
    protected String name;
    protected String type;
    protected String format;
    protected Object example;
    protected Xml xml;
    protected boolean required;
    protected Integer position;
    protected String description;
    protected String title;
    protected Boolean readOnly;
    protected Boolean allowEmptyValue;
    protected String access;
    protected Map<String, Object> vendorExtensions = new LinkedHashMap<String, Object>();

    @Override
    public Property rename(String string) {
        try {
            Property property = (Property)this.clone();
            property.setName(string);
            return property;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Clone is not supported!?");
        }
    }

    @Override
    public Property title(String string) {
        this.setTitle(string);
        return this;
    }

    @Override
    public Property description(String string) {
        this.setDescription(string);
        return this;
    }

    public Property readOnly() {
        this.setReadOnly(Boolean.TRUE);
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AbstractProperty)) {
            return false;
        }
        AbstractProperty abstractProperty = (AbstractProperty)object;
        if (this.required != abstractProperty.required) {
            return false;
        }
        if (this.name != null ? !this.name.equals(abstractProperty.name) : abstractProperty.name != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(abstractProperty.type) : abstractProperty.type != null) {
            return false;
        }
        if (this.format != null ? !this.format.equals(abstractProperty.format) : abstractProperty.format != null) {
            return false;
        }
        if (this.example != null ? !this.example.equals(abstractProperty.example) : abstractProperty.example != null) {
            return false;
        }
        if (this.xml != null ? !this.xml.equals(abstractProperty.xml) : abstractProperty.xml != null) {
            return false;
        }
        if (this.position != null ? !this.position.equals(abstractProperty.position) : abstractProperty.position != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(abstractProperty.description) : abstractProperty.description != null) {
            return false;
        }
        if (this.title != null ? !this.title.equals(abstractProperty.title) : abstractProperty.title != null) {
            return false;
        }
        if (this.readOnly != null ? !this.readOnly.equals(abstractProperty.readOnly) : abstractProperty.readOnly != null) {
            return false;
        }
        if (this.allowEmptyValue != null ? !this.allowEmptyValue.equals(abstractProperty.allowEmptyValue) : abstractProperty.allowEmptyValue != null) {
            return false;
        }
        if (this.access != null ? !this.access.equals(abstractProperty.access) : abstractProperty.access != null) {
            return false;
        }
        return this.vendorExtensions != null ? this.vendorExtensions.equals(abstractProperty.vendorExtensions) : abstractProperty.vendorExtensions == null;
    }

    public int hashCode() {
        int n2 = this.name != null ? this.name.hashCode() : 0;
        n2 = 31 * n2 + (this.type != null ? this.type.hashCode() : 0);
        n2 = 31 * n2 + (this.format != null ? this.format.hashCode() : 0);
        n2 = 31 * n2 + (this.example != null ? this.example.hashCode() : 0);
        n2 = 31 * n2 + (this.xml != null ? this.xml.hashCode() : 0);
        n2 = 31 * n2 + (this.required ? 1 : 0);
        n2 = 31 * n2 + (this.position != null ? this.position.hashCode() : 0);
        n2 = 31 * n2 + (this.description != null ? this.description.hashCode() : 0);
        n2 = 31 * n2 + (this.title != null ? this.title.hashCode() : 0);
        n2 = 31 * n2 + (this.readOnly != null ? this.readOnly.hashCode() : 0);
        n2 = 31 * n2 + (this.allowEmptyValue != null ? this.allowEmptyValue.hashCode() : 0);
        n2 = 31 * n2 + (this.access != null ? this.access.hashCode() : 0);
        n2 = 31 * n2 + (this.vendorExtensions != null ? this.vendorExtensions.hashCode() : 0);
        return n2;
    }

    public Property allowEmptyValue(Boolean bl) {
        this.setAllowEmptyValue(bl);
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public Object getExample() {
        return this.example;
    }

    @Override
    public void setExample(Object object) {
        this.example = object;
    }

    @Override
    public void setExample(String string) {
        this.setExample((Object)string);
    }

    @Override
    public Integer getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Integer n2) {
        this.position = n2;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    public void setFormat(String string) {
        this.format = string;
    }

    @Override
    public Xml getXml() {
        return this.xml;
    }

    @Override
    public void setXml(Xml xml) {
        this.xml = xml;
    }

    @Override
    public boolean getRequired() {
        return this.required;
    }

    @Override
    public void setRequired(boolean bl) {
        this.required = bl;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String string) {
        this.title = string;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String string) {
        this.description = string;
    }

    @Override
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(Boolean bl) {
        this.readOnly = Boolean.FALSE.equals(bl) ? null : bl;
    }

    @Override
    public void setDefault(String string) {
    }

    @Override
    public String getAccess() {
        return this.access;
    }

    @Override
    public void setAccess(String string) {
        this.access = string;
    }

    @Override
    public Boolean getAllowEmptyValue() {
        return this.allowEmptyValue;
    }

    @Override
    public void setAllowEmptyValue(Boolean bl) {
        if (bl != null) {
            this.allowEmptyValue = bl;
        }
    }

    @Override
    @JsonAnyGetter
    public Map<String, Object> getVendorExtensions() {
        return this.vendorExtensions;
    }

    @JsonAnySetter
    public void setVendorExtension(String string, Object object) {
        if (string.startsWith("x-")) {
            this.vendorExtensions.put(string, object);
        }
    }

    public void setVendorExtensions(Map<String, Object> map) {
        this.vendorExtensions = map;
    }

    public void setVendorExtensionMap(Map<String, Object> map) {
        this.vendorExtensions.putAll(map);
    }
}

