/*
 * Decompiled with CFR 0.152.
 */
package io.github.manusant.ss.model.parameters;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.github.manusant.ss.model.parameters.AbstractParameter;
import io.github.manusant.ss.model.parameters.SerializableParameter;
import io.github.manusant.ss.model.properties.ArrayProperty;
import io.github.manusant.ss.model.properties.BaseIntegerProperty;
import io.github.manusant.ss.model.properties.DecimalProperty;
import io.github.manusant.ss.model.properties.DoubleProperty;
import io.github.manusant.ss.model.properties.FloatProperty;
import io.github.manusant.ss.model.properties.IntegerProperty;
import io.github.manusant.ss.model.properties.LongProperty;
import io.github.manusant.ss.model.properties.Property;
import io.github.manusant.ss.model.properties.StringProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonPropertyOrder(value={"name", "in", "description", "required", "type", "items", "format", "collectionFormat", "default", "maximum", "exclusiveMaximum", "minimum", "exclusiveMinimum", "maxLength", "minLength", "pattern", "maxItems", "minItems", "uniqueItems", "multipleOf", "example"})
public abstract class AbstractSerializableParameter<T extends AbstractSerializableParameter<T>>
extends AbstractParameter
implements SerializableParameter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSerializableParameter.class);
    protected String type;
    protected String format;
    protected String collectionFormat;
    protected Property items;
    protected Boolean exclusiveMaximum;
    protected BigDecimal maximum;
    protected Boolean exclusiveMinimum;
    protected BigDecimal minimum;
    protected String example;
    private Integer maxItems;
    private Integer minItems;
    protected Boolean allowEmptyValue;
    @JsonIgnore
    protected List<String> _enum;
    public Integer maxLength;
    public Integer minLength;
    public String pattern;
    public Boolean uniqueItems;
    public Number multipleOf;
    @JsonIgnore
    protected String defaultValue;

    public T property(Property property) {
        this.setProperty(property);
        return this.castThis();
    }

    public T type(String string) {
        this.setType(string);
        return this.castThis();
    }

    public T format(String string) {
        this.setFormat(string);
        return this.castThis();
    }

    public T description(String string) {
        this.setDescription(string);
        return this.castThis();
    }

    public T name(String string) {
        this.setName(string);
        return this.castThis();
    }

    public T required(boolean bl) {
        this.setRequired(bl);
        return this.castThis();
    }

    public T collectionFormat(String string) {
        this.setCollectionFormat(string);
        return this.castThis();
    }

    public T example(String string) {
        this.setExample(string);
        return this.castThis();
    }

    public T allowEmptyValue(Boolean bl) {
        this.setAllowEmptyValue(bl);
        return this.castThis();
    }

    public T readOnly(Boolean bl) {
        this.setReadOnly(bl);
        return this.castThis();
    }

    @JsonIgnore
    protected String getDefaultCollectionFormat() {
        return "csv";
    }

    public T items(Property property) {
        this.items = property;
        return this.castThis();
    }

    public T _enum(List<String> list) {
        this._enum = list;
        return this.castThis();
    }

    @Override
    @JsonIgnore
    public List<String> getEnum() {
        return this._enum;
    }

    @Override
    public void setEnum(List<String> list) {
        this._enum = list;
    }

    @Override
    @JsonProperty(value="enum")
    public List<Object> getEnumValue() {
        if (this._enum == null) {
            return null;
        }
        if (this._enum.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(this._enum.size());
        if ("integer".equals(this.type) || "number".equals(this.type)) {
            for (String string : this._enum) {
                try {
                    if ("int32".equals(this.format)) {
                        arrayList.add(Integer.valueOf(string));
                        continue;
                    }
                    if ("int64".equals(this.format)) {
                        arrayList.add(Long.valueOf(string));
                        continue;
                    }
                    if ("double".equals(this.format)) {
                        arrayList.add(Double.valueOf(string));
                        continue;
                    }
                    if ("float".equals(this.format)) {
                        arrayList.add(Float.valueOf(string));
                        continue;
                    }
                    if ("integer".equals(this.type)) {
                        arrayList.add(Integer.valueOf(string));
                        continue;
                    }
                    if (!"number".equals(this.type)) continue;
                    arrayList.add(Double.valueOf(string));
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.warn(String.format("Illegal enum value %s for parameter type %s", string, this.type), (Throwable)numberFormatException);
                    arrayList.add(string);
                }
            }
        } else if ((this.type == null || "array".equals(this.type)) && this.items != null) {
            for (String string : this._enum) {
                try {
                    if (this.items instanceof StringProperty) {
                        arrayList.add(string);
                        continue;
                    }
                    if (this.items instanceof IntegerProperty) {
                        arrayList.add(Integer.valueOf(string));
                        continue;
                    }
                    if (this.items instanceof LongProperty) {
                        arrayList.add(Long.valueOf(string));
                        continue;
                    }
                    if (this.items instanceof FloatProperty) {
                        arrayList.add(Float.valueOf(string));
                        continue;
                    }
                    if (this.items instanceof DoubleProperty) {
                        arrayList.add(Double.valueOf(string));
                        continue;
                    }
                    if (this.items instanceof BaseIntegerProperty) {
                        arrayList.add(Integer.valueOf(string));
                        continue;
                    }
                    if (this.items instanceof DecimalProperty) {
                        arrayList.add(Double.valueOf(string));
                        continue;
                    }
                    arrayList.add(string);
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.warn(String.format("Illegal enum value %s for parameter type %s", string, this.type), (Throwable)numberFormatException);
                    arrayList.add(string);
                }
            }
        } else {
            for (String string : this._enum) {
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    @Override
    public void setEnumValue(List<?> list) {
        if (list == null) {
            this._enum = null;
            return;
        }
        if (list.isEmpty()) {
            this._enum = Collections.emptyList();
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (Object obj : list) {
            arrayList.add(obj.toString());
        }
        this._enum = arrayList;
    }

    @Override
    public Property getItems() {
        return this.items;
    }

    @Override
    public void setItems(Property property) {
        this.items = property;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public void setFormat(String string) {
        this.format = string;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String string) {
        this.type = string;
        this.setCollectionFormat(ArrayProperty.isType(string) ? this.getDefaultCollectionFormat() : null);
    }

    @Override
    public String getCollectionFormat() {
        return this.collectionFormat;
    }

    @Override
    public void setCollectionFormat(String string) {
        this.collectionFormat = string;
    }

    public void setProperty(Property property) {
        this.setType(property.getType());
        this.format = property.getFormat();
        if (property instanceof StringProperty) {
            StringProperty stringProperty = (StringProperty)property;
            this.setEnum(stringProperty.getEnum());
        } else if (property instanceof IntegerProperty) {
            this.setEnumValue(((IntegerProperty)property).getEnum());
        } else if (property instanceof LongProperty) {
            this.setEnumValue(((LongProperty)property).getEnum());
        } else if (property instanceof FloatProperty) {
            this.setEnumValue(((FloatProperty)property).getEnum());
        } else if (property instanceof DoubleProperty) {
            this.setEnumValue(((DoubleProperty)property).getEnum());
        } else if (property instanceof ArrayProperty) {
            ArrayProperty arrayProperty = (ArrayProperty)property;
            this.setItems(arrayProperty.getItems());
        }
    }

    public Object getDefaultValue() {
        if (this.defaultValue == null) {
            return null;
        }
        try {
            if ("integer".equals(this.type)) {
                return new Integer(this.defaultValue);
            }
            if ("number".equals(this.type)) {
                return new BigDecimal(this.defaultValue);
            }
        }
        catch (Exception exception) {
            return null;
        }
        return this.defaultValue;
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    public Object getDefault() {
        if (this.defaultValue == null || this.defaultValue.isEmpty()) {
            return null;
        }
        try {
            if ("integer".equals(this.type)) {
                return Long.valueOf(this.defaultValue);
            }
            if ("number".equals(this.type)) {
                return Double.valueOf(this.defaultValue);
            }
            if ("boolean".equals(this.type) && ("true".equalsIgnoreCase(this.defaultValue) || "false".equalsIgnoreCase(this.defaultValue))) {
                return Boolean.valueOf(this.defaultValue);
            }
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn(String.format("Illegal DefaultValue %s for parameter type %s", this.defaultValue, this.type), (Throwable)numberFormatException);
        }
        return this.defaultValue;
    }

    public void setDefault(Object object) {
        this.defaultValue = object == null ? null : object.toString();
    }

    @Override
    public void setExclusiveMaximum(Boolean bl) {
        this.exclusiveMaximum = bl;
    }

    @Override
    public BigDecimal getMaximum() {
        return this.maximum;
    }

    @Override
    public void setMaximum(BigDecimal bigDecimal) {
        this.maximum = bigDecimal;
    }

    @Override
    public Boolean isExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    @Override
    public void setExclusiveMinimum(Boolean bl) {
        this.exclusiveMinimum = bl;
    }

    @Override
    public BigDecimal getMinimum() {
        return this.minimum;
    }

    @Override
    public void setMinimum(BigDecimal bigDecimal) {
        this.minimum = bigDecimal;
    }

    @Override
    public Integer getMaxItems() {
        return this.maxItems;
    }

    @Override
    public void setMaxItems(Integer n2) {
        this.maxItems = n2;
    }

    @Override
    public Integer getMinItems() {
        return this.minItems;
    }

    @Override
    public void setMinItems(Integer n2) {
        this.minItems = n2;
    }

    @Override
    public Boolean getAllowEmptyValue() {
        return this.allowEmptyValue;
    }

    @Override
    public void setAllowEmptyValue(Boolean bl) {
        this.allowEmptyValue = bl;
    }

    @JsonProperty(value="x-example")
    public Object getXExample() {
        return this.getExample();
    }

    @JsonProperty(value="example")
    public Object getExample() {
        if (this.example == null) {
            return null;
        }
        try {
            if ("integer".equals(this.type)) {
                return Long.valueOf(this.example);
            }
            if ("number".equals(this.type)) {
                return Double.valueOf(this.example);
            }
            if ("boolean".equals(this.type) && ("true".equalsIgnoreCase(this.example) || "false".equalsIgnoreCase(this.defaultValue))) {
                return Boolean.valueOf(this.example);
            }
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn(String.format("Illegal DefaultValue %s for parameter type %s", this.defaultValue, this.type), (Throwable)numberFormatException);
        }
        return this.example;
    }

    @Override
    public Integer getMaxLength() {
        return this.maxLength;
    }

    @Override
    public void setMaxLength(Integer n2) {
        this.maxLength = n2;
    }

    @Override
    public Integer getMinLength() {
        return this.minLength;
    }

    @Override
    public void setMinLength(Integer n2) {
        this.minLength = n2;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public void setPattern(String string) {
        this.pattern = string;
    }

    @Override
    public Boolean isUniqueItems() {
        return this.uniqueItems;
    }

    @Override
    public void setUniqueItems(Boolean bl) {
        this.uniqueItems = bl;
    }

    @Override
    public Number getMultipleOf() {
        return this.multipleOf;
    }

    @Override
    public void setMultipleOf(Number number) {
        this.multipleOf = number;
    }

    @Override
    public Boolean isExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    public void setExample(String string) {
        this.example = string;
    }

    @JsonIgnore
    private T castThis() {
        AbstractSerializableParameter abstractSerializableParameter = this;
        return (T)abstractSerializableParameter;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AbstractSerializableParameter abstractSerializableParameter = (AbstractSerializableParameter)object;
        if (this._enum == null ? abstractSerializableParameter._enum != null : !this._enum.equals(abstractSerializableParameter._enum)) {
            return false;
        }
        if (this.collectionFormat == null ? abstractSerializableParameter.collectionFormat != null : !this.collectionFormat.equals(abstractSerializableParameter.collectionFormat)) {
            return false;
        }
        if (this.defaultValue == null ? abstractSerializableParameter.defaultValue != null : !this.defaultValue.equals(abstractSerializableParameter.defaultValue)) {
            return false;
        }
        if (this.example == null ? abstractSerializableParameter.example != null : !this.example.equals(abstractSerializableParameter.example)) {
            return false;
        }
        if (this.exclusiveMaximum == null ? abstractSerializableParameter.exclusiveMaximum != null : !this.exclusiveMaximum.equals(abstractSerializableParameter.exclusiveMaximum)) {
            return false;
        }
        if (this.exclusiveMinimum == null ? abstractSerializableParameter.exclusiveMinimum != null : !this.exclusiveMinimum.equals(abstractSerializableParameter.exclusiveMinimum)) {
            return false;
        }
        if (this.format == null ? abstractSerializableParameter.format != null : !this.format.equals(abstractSerializableParameter.format)) {
            return false;
        }
        if (this.items == null ? abstractSerializableParameter.items != null : !this.items.equals(abstractSerializableParameter.items)) {
            return false;
        }
        if (this.maxItems == null ? abstractSerializableParameter.maxItems != null : !this.maxItems.equals(abstractSerializableParameter.maxItems)) {
            return false;
        }
        if (this.maxLength == null ? abstractSerializableParameter.maxLength != null : !this.maxLength.equals(abstractSerializableParameter.maxLength)) {
            return false;
        }
        if (this.maximum == null ? abstractSerializableParameter.maximum != null : !this.maximum.equals(abstractSerializableParameter.maximum)) {
            return false;
        }
        if (this.minItems == null ? abstractSerializableParameter.minItems != null : !this.minItems.equals(abstractSerializableParameter.minItems)) {
            return false;
        }
        if (this.minLength == null ? abstractSerializableParameter.minLength != null : !this.minLength.equals(abstractSerializableParameter.minLength)) {
            return false;
        }
        if (this.minimum == null ? abstractSerializableParameter.minimum != null : !this.minimum.equals(abstractSerializableParameter.minimum)) {
            return false;
        }
        if (this.multipleOf == null ? abstractSerializableParameter.multipleOf != null : !this.multipleOf.equals(abstractSerializableParameter.multipleOf)) {
            return false;
        }
        if (this.pattern == null ? abstractSerializableParameter.pattern != null : !this.pattern.equals(abstractSerializableParameter.pattern)) {
            return false;
        }
        if (this.type == null ? abstractSerializableParameter.type != null : !this.type.equals(abstractSerializableParameter.type)) {
            return false;
        }
        if (this.uniqueItems == null ? abstractSerializableParameter.uniqueItems != null : !this.uniqueItems.equals(abstractSerializableParameter.uniqueItems)) {
            return false;
        }
        return !(this.allowEmptyValue != null ? !this.allowEmptyValue.equals(abstractSerializableParameter.allowEmptyValue) : abstractSerializableParameter.allowEmptyValue != null);
    }

    @Override
    public int hashCode() {
        int n2 = 31;
        int n3 = super.hashCode();
        n3 = 31 * n3 + (this._enum == null ? 0 : this._enum.hashCode());
        n3 = 31 * n3 + (this.collectionFormat == null ? 0 : this.collectionFormat.hashCode());
        n3 = 31 * n3 + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
        n3 = 31 * n3 + (this.example == null ? 0 : this.example.hashCode());
        n3 = 31 * n3 + (this.exclusiveMaximum == null ? 0 : this.exclusiveMaximum.hashCode());
        n3 = 31 * n3 + (this.exclusiveMinimum == null ? 0 : this.exclusiveMinimum.hashCode());
        n3 = 31 * n3 + (this.format == null ? 0 : this.format.hashCode());
        n3 = 31 * n3 + (this.items == null ? 0 : this.items.hashCode());
        n3 = 31 * n3 + (this.maxItems == null ? 0 : this.maxItems.hashCode());
        n3 = 31 * n3 + (this.maxLength == null ? 0 : this.maxLength.hashCode());
        n3 = 31 * n3 + (this.maximum == null ? 0 : this.maximum.hashCode());
        n3 = 31 * n3 + (this.minItems == null ? 0 : this.minItems.hashCode());
        n3 = 31 * n3 + (this.minLength == null ? 0 : this.minLength.hashCode());
        n3 = 31 * n3 + (this.minimum == null ? 0 : this.minimum.hashCode());
        n3 = 31 * n3 + (this.multipleOf == null ? 0 : this.multipleOf.hashCode());
        n3 = 31 * n3 + (this.pattern == null ? 0 : this.pattern.hashCode());
        n3 = 31 * n3 + (this.type == null ? 0 : this.type.hashCode());
        n3 = 31 * n3 + (this.uniqueItems == null ? 0 : this.uniqueItems.hashCode());
        n3 = 31 * n3 + (this.allowEmptyValue != null ? this.allowEmptyValue.hashCode() : 0);
        return n3;
    }
}

