/*
 * Decompiled with CFR 0.152.
 */
package io.github.manusant.ss.model.auth;

import io.github.manusant.ss.model.auth.AbstractSecuritySchemeDefinition;
import java.util.LinkedHashMap;
import java.util.Map;

public class OAuth2Definition
extends AbstractSecuritySchemeDefinition {
    private String type = "oauth2";
    private String authorizationUrl;
    private String tokenUrl;
    private String flow;
    private Map<String, String> scopes;

    public OAuth2Definition implicit(String string) {
        this.setAuthorizationUrl(string);
        this.setFlow("implicit");
        return this;
    }

    public OAuth2Definition password(String string) {
        this.setTokenUrl(string);
        this.setFlow("password");
        return this;
    }

    public OAuth2Definition application(String string) {
        this.setTokenUrl(string);
        this.setFlow("application");
        return this;
    }

    public OAuth2Definition accessCode(String string, String string2) {
        this.setTokenUrl(string2);
        this.setAuthorizationUrl(string);
        this.setFlow("accessCode");
        return this;
    }

    public OAuth2Definition scope(String string, String string2) {
        this.addScope(string, string2);
        return this;
    }

    public String getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    public void setAuthorizationUrl(String string) {
        this.authorizationUrl = string;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public void setTokenUrl(String string) {
        this.tokenUrl = string;
    }

    public String getFlow() {
        return this.flow;
    }

    public void setFlow(String string) {
        this.flow = string;
    }

    public Map<String, String> getScopes() {
        return this.scopes;
    }

    public void setScopes(Map<String, String> map) {
        this.scopes = map;
    }

    public void addScope(String string, String string2) {
        if (this.scopes == null) {
            this.scopes = new LinkedHashMap<String, String>();
        }
        this.scopes.put(string, string2);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String string) {
        this.type = string;
    }

    @Override
    public int hashCode() {
        int n2 = 31;
        int n3 = super.hashCode();
        n3 = 31 * n3 + (this.authorizationUrl == null ? 0 : this.authorizationUrl.hashCode());
        n3 = 31 * n3 + (this.flow == null ? 0 : this.flow.hashCode());
        n3 = 31 * n3 + (this.scopes == null ? 0 : this.scopes.hashCode());
        n3 = 31 * n3 + (this.tokenUrl == null ? 0 : this.tokenUrl.hashCode());
        n3 = 31 * n3 + (this.type == null ? 0 : this.type.hashCode());
        return n3;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        OAuth2Definition oAuth2Definition = (OAuth2Definition)object;
        if (this.authorizationUrl == null ? oAuth2Definition.authorizationUrl != null : !this.authorizationUrl.equals(oAuth2Definition.authorizationUrl)) {
            return false;
        }
        if (this.flow == null ? oAuth2Definition.flow != null : !this.flow.equals(oAuth2Definition.flow)) {
            return false;
        }
        if (this.scopes == null ? oAuth2Definition.scopes != null : !this.scopes.equals(oAuth2Definition.scopes)) {
            return false;
        }
        if (this.tokenUrl == null ? oAuth2Definition.tokenUrl != null : !this.tokenUrl.equals(oAuth2Definition.tokenUrl)) {
            return false;
        }
        return !(this.type == null ? oAuth2Definition.type != null : !this.type.equals(oAuth2Definition.type));
    }
}

