/*
 * Decompiled with CFR 0.152.
 */
package io.github.manusant.ss.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.github.manusant.ss.model.ExternalDocs;
import java.util.LinkedHashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Tag {
    private Map<String, Object> vendorExtensions = new LinkedHashMap<String, Object>();
    private String name;
    private String description;
    private ExternalDocs externalDocs;

    public Tag name(String string) {
        this.setName(string);
        return this;
    }

    public Tag description(String string) {
        this.setDescription(string);
        return this;
    }

    public Tag externalDocs(ExternalDocs externalDocs) {
        this.setExternalDocs(externalDocs);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public ExternalDocs getExternalDocs() {
        return this.externalDocs;
    }

    public void setExternalDocs(ExternalDocs externalDocs) {
        this.externalDocs = externalDocs;
    }

    @JsonAnyGetter
    public Map<String, Object> getVendorExtensions() {
        return this.vendorExtensions;
    }

    @JsonAnySetter
    public void setVendorExtension(String string, Object object) {
        if (string.startsWith("x-")) {
            this.vendorExtensions.put(string, object);
        }
    }

    public void setVendorExtensions(Map<String, Object> map) {
        this.vendorExtensions = map;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Tag {\n");
        stringBuilder.append("\tname: ").append(this.getName()).append("\n");
        stringBuilder.append("\tdescription: ").append(this.getDescription()).append("\n");
        stringBuilder.append("\texternalDocs: ").append(this.getExternalDocs()).append("\n");
        stringBuilder.append("\textensions:").append(this.vendorExtensions.toString());
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.description == null ? 0 : this.description.hashCode());
        n3 = 31 * n3 + (this.externalDocs == null ? 0 : this.externalDocs.hashCode());
        n3 = 31 * n3 + (this.name == null ? 0 : this.name.hashCode());
        n3 = 31 * n3 + (this.vendorExtensions == null ? 0 : this.vendorExtensions.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Tag tag = (Tag)object;
        if (this.description == null ? tag.description != null : !this.description.equals(tag.description)) {
            return false;
        }
        if (this.externalDocs == null ? tag.externalDocs != null : !this.externalDocs.equals(tag.externalDocs)) {
            return false;
        }
        if (this.name == null ? tag.name != null : !this.name.equals(tag.name)) {
            return false;
        }
        return !(this.vendorExtensions == null ? tag.vendorExtensions != null : !this.vendorExtensions.equals(tag.vendorExtensions));
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private Map<String, Object> vendorExtensions = new LinkedHashMap<String, Object>();
        private String name;
        private String description;
        private ExternalDocs externalDocs;

        private Builder() {
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder withVendorExtensions(Map<String, Object> map) {
            this.vendorExtensions = map;
            return this;
        }

        public Builder withName(String string) {
            this.name = string;
            return this;
        }

        public Builder withDescription(String string) {
            this.description = string;
            return this;
        }

        public Builder withExternalDocs(ExternalDocs externalDocs) {
            this.externalDocs = externalDocs;
            return this;
        }

        public Tag build() {
            Tag tag = new Tag();
            tag.setVendorExtensions(this.vendorExtensions);
            tag.setName(this.name);
            tag.setDescription(this.description);
            tag.setExternalDocs(this.externalDocs);
            return tag;
        }
    }
}

