/*
 * Decompiled with CFR 0.152.
 */
package io.github.manusant.ss.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.github.manusant.ss.model.Model;
import io.github.manusant.ss.model.properties.Property;
import io.github.manusant.ss.model.utils.PropertyModelConverter;
import java.util.LinkedHashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Response {
    private String description;
    private Model schemaAsModel;
    private Property schemaAsProperty;
    private Map<String, Object> examples;
    private Map<String, Property> headers;
    private Map<String, Object> vendorExtensions = new LinkedHashMap<String, Object>();

    public Response description(String string) {
        this.setDescription(string);
        return this;
    }

    public Response example(String string, Object object) {
        if (this.examples == null) {
            this.examples = new LinkedHashMap<String, Object>();
        }
        this.examples.put(string, object);
        return this;
    }

    public Response header(String string, Property property) {
        this.addHeader(string, property);
        return this;
    }

    public Response headers(Map<String, Property> map) {
        this.headers = map;
        return this;
    }

    public Response vendorExtension(String string, Object object) {
        this.setVendorExtension(string, object);
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    @Deprecated
    public Property getSchema() {
        if (this.schemaAsProperty == null && this.schemaAsModel != null) {
            return new PropertyModelConverter().modelToProperty(this.schemaAsModel);
        }
        return this.schemaAsProperty;
    }

    @Deprecated
    public void setSchema(Property property) {
        this.schemaAsProperty = property;
    }

    @Deprecated
    public Response schema(Property property) {
        this.setSchema(property);
        return this;
    }

    public Model getResponseSchema() {
        if (this.schemaAsModel == null && this.schemaAsProperty != null) {
            return new PropertyModelConverter().propertyToModel(this.schemaAsProperty);
        }
        return this.schemaAsModel;
    }

    public void setResponseSchema(Model model) {
        this.schemaAsModel = model;
    }

    public Response responseSchema(Model model) {
        this.setResponseSchema(model);
        return this;
    }

    public Map<String, Object> getExamples() {
        return this.examples;
    }

    public void setExamples(Map<String, Object> map) {
        this.examples = map;
    }

    public Map<String, Property> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, Property> map) {
        this.headers = map;
    }

    public void addHeader(String string, Property property) {
        if (this.headers == null) {
            this.headers = new LinkedHashMap<String, Property>();
        }
        this.headers.put(string, property);
    }

    @JsonAnyGetter
    public Map<String, Object> getVendorExtensions() {
        return this.vendorExtensions;
    }

    @JsonAnySetter
    public void setVendorExtension(String string, Object object) {
        if (string.startsWith("x-")) {
            this.vendorExtensions.put(string, object);
        }
    }

    public void setVendorExtensions(Map<String, Object> map) {
        this.vendorExtensions = map;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Response)) {
            return false;
        }
        Response response = (Response)object;
        if (this.description != null ? !this.description.equals(response.description) : response.description != null) {
            return false;
        }
        if (this.schemaAsModel != null ? !this.schemaAsModel.equals(response.schemaAsModel) : response.schemaAsModel != null) {
            return false;
        }
        if (this.schemaAsProperty != null ? !this.schemaAsProperty.equals(response.schemaAsProperty) : response.schemaAsProperty != null) {
            return false;
        }
        if (this.examples != null ? !this.examples.equals(response.examples) : response.examples != null) {
            return false;
        }
        if (this.headers != null ? !this.headers.equals(response.headers) : response.headers != null) {
            return false;
        }
        return this.vendorExtensions != null ? this.vendorExtensions.equals(response.vendorExtensions) : response.vendorExtensions == null;
    }

    public int hashCode() {
        int n2 = this.description != null ? this.description.hashCode() : 0;
        n2 = 31 * n2 + (this.schemaAsModel != null ? this.schemaAsModel.hashCode() : 0);
        n2 = 31 * n2 + (this.schemaAsProperty != null ? this.schemaAsProperty.hashCode() : 0);
        n2 = 31 * n2 + (this.examples != null ? this.examples.hashCode() : 0);
        n2 = 31 * n2 + (this.headers != null ? this.headers.hashCode() : 0);
        n2 = 31 * n2 + (this.vendorExtensions != null ? this.vendorExtensions.hashCode() : 0);
        return n2;
    }
}

