/*
 * Decompiled with CFR 0.152.
 */
package io.github.manusant.ss.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.github.manusant.ss.model.ExternalDocs;
import io.github.manusant.ss.model.Model;
import io.github.manusant.ss.model.properties.Property;
import io.github.manusant.ss.model.refs.GenericRef;
import io.github.manusant.ss.model.refs.RefFormat;
import io.github.manusant.ss.model.refs.RefType;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RefModel
implements Model {
    private GenericRef genericRef;
    private String description;
    private ExternalDocs externalDocs;
    private Map<String, Property> properties;
    private Object example;
    private String title;
    private Class<?> typeClass;

    public RefModel() {
    }

    public RefModel(String string) {
        this.set$ref(string);
    }

    public RefModel asDefault(String string) {
        this.set$ref(RefType.DEFINITION.getInternalPrefix() + string);
        return this;
    }

    @Override
    @JsonIgnore
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String string) {
        this.title = string;
    }

    @Override
    public Class<?> getTypeClass() {
        return this.typeClass;
    }

    @Override
    public void setTypeClass(Class<?> clazz) {
        this.typeClass = clazz;
    }

    @Override
    @JsonIgnore
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String string) {
        this.description = string;
    }

    @Override
    @JsonIgnore
    public Map<String, Property> getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Map<String, Property> map) {
        this.properties = map;
    }

    @JsonIgnore
    public String getSimpleRef() {
        return this.genericRef.getSimpleRef();
    }

    public String get$ref() {
        return this.genericRef.getRef();
    }

    public void set$ref(String string) {
        this.genericRef = new GenericRef(RefType.DEFINITION, string);
    }

    @JsonIgnore
    public RefFormat getRefFormat() {
        return this.genericRef.getFormat();
    }

    @Override
    @JsonIgnore
    public Object getExample() {
        return this.example;
    }

    @Override
    public void setExample(Object object) {
        this.example = object;
    }

    @Override
    @JsonIgnore
    public ExternalDocs getExternalDocs() {
        return this.externalDocs;
    }

    public void setExternalDocs(ExternalDocs externalDocs) {
        this.externalDocs = externalDocs;
    }

    @Override
    public Object clone() {
        RefModel refModel = new RefModel();
        refModel.genericRef = this.genericRef;
        refModel.description = this.description;
        refModel.properties = this.properties;
        refModel.example = this.example;
        refModel.title = this.title;
        refModel.typeClass = this.typeClass;
        return refModel;
    }

    @Override
    @JsonIgnore
    public Map<String, Object> getVendorExtensions() {
        return null;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.description == null ? 0 : this.description.hashCode());
        n3 = 31 * n3 + (this.title == null ? 0 : this.title.hashCode());
        n3 = 31 * n3 + (this.typeClass == null ? 0 : this.typeClass.hashCode());
        n3 = 31 * n3 + (this.example == null ? 0 : this.example.hashCode());
        n3 = 31 * n3 + (this.externalDocs == null ? 0 : this.externalDocs.hashCode());
        n3 = 31 * n3 + (this.properties == null ? 0 : this.properties.hashCode());
        n3 = 31 * n3 + (this.genericRef == null ? 0 : this.genericRef.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RefModel refModel = (RefModel)object;
        if (this.description == null ? refModel.description != null : !this.description.equals(refModel.description)) {
            return false;
        }
        if (this.example == null ? refModel.example != null : !this.example.equals(refModel.example)) {
            return false;
        }
        if (this.externalDocs == null ? refModel.externalDocs != null : !this.externalDocs.equals(refModel.externalDocs)) {
            return false;
        }
        if (this.properties == null ? refModel.properties != null : !this.properties.equals(refModel.properties)) {
            return false;
        }
        if (this.genericRef == null ? refModel.genericRef != null : !this.genericRef.equals(refModel.genericRef)) {
            return false;
        }
        if (this.title == null ? refModel.title != null : !this.title.equals(refModel.title)) {
            return false;
        }
        return !(this.typeClass == null ? refModel.typeClass != null : !this.typeClass.equals(refModel.typeClass));
    }

    @Override
    @JsonIgnore
    public String getReference() {
        return this.genericRef.getRef();
    }

    @Override
    public void setReference(String string) {
        this.genericRef = new GenericRef(RefType.DEFINITION, string);
    }
}

