/*
 * Decompiled with CFR 0.152.
 */
package io.github.manusant.ss.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.github.manusant.ss.model.HttpMethod;
import io.github.manusant.ss.model.Operation;
import io.github.manusant.ss.model.parameters.Parameter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"get", "head", "post", "put", "delete", "options", "patch"})
public class Path {
    private Map<String, Object> vendorExtensions = new LinkedHashMap<String, Object>();
    private Operation get;
    private Operation put;
    private Operation post;
    private Operation head;
    private Operation delete;
    private Operation patch;
    private Operation options;
    private List<Parameter> parameters;

    public Path set(HttpMethod httpMethod, Operation operation) {
        if (HttpMethod.GET.equals((Object)httpMethod)) {
            return this.get(operation);
        }
        if (HttpMethod.PUT.equals((Object)httpMethod)) {
            return this.put(operation);
        }
        if (HttpMethod.HEAD.equals((Object)httpMethod)) {
            return this.head(operation);
        }
        if (HttpMethod.POST.equals((Object)httpMethod)) {
            return this.post(operation);
        }
        if (HttpMethod.DELETE.equals((Object)httpMethod)) {
            return this.delete(operation);
        }
        if (HttpMethod.PATCH.equals((Object)httpMethod)) {
            return this.patch(operation);
        }
        if (HttpMethod.OPTIONS.equals((Object)httpMethod)) {
            return this.options(operation);
        }
        return null;
    }

    public Path get(Operation operation) {
        this.get = operation;
        return this;
    }

    public Path head(Operation operation) {
        this.head = operation;
        return this;
    }

    public Path put(Operation operation) {
        this.put = operation;
        return this;
    }

    public Path post(Operation operation) {
        this.post = operation;
        return this;
    }

    public Path delete(Operation operation) {
        this.delete = operation;
        return this;
    }

    public Path patch(Operation operation) {
        this.patch = operation;
        return this;
    }

    public Path options(Operation operation) {
        this.options = operation;
        return this;
    }

    public Operation getGet() {
        return this.get;
    }

    public void setGet(Operation operation) {
        this.get = operation;
    }

    public Operation getHead() {
        return this.head;
    }

    public void setHead(Operation operation) {
        this.head = operation;
    }

    public Operation getPut() {
        return this.put;
    }

    public void setPut(Operation operation) {
        this.put = operation;
    }

    public Operation getPost() {
        return this.post;
    }

    public void setPost(Operation operation) {
        this.post = operation;
    }

    public Operation getDelete() {
        return this.delete;
    }

    public void setDelete(Operation operation) {
        this.delete = operation;
    }

    public Operation getPatch() {
        return this.patch;
    }

    public void setPatch(Operation operation) {
        this.patch = operation;
    }

    public Operation getOptions() {
        return this.options;
    }

    public void setOptions(Operation operation) {
        this.options = operation;
    }

    @JsonIgnore
    public List<Operation> getOperations() {
        ArrayList<Operation> arrayList = new ArrayList<Operation>();
        if (this.get != null) {
            arrayList.add(this.get);
        }
        if (this.put != null) {
            arrayList.add(this.put);
        }
        if (this.head != null) {
            arrayList.add(this.head);
        }
        if (this.post != null) {
            arrayList.add(this.post);
        }
        if (this.delete != null) {
            arrayList.add(this.delete);
        }
        if (this.patch != null) {
            arrayList.add(this.patch);
        }
        if (this.options != null) {
            arrayList.add(this.options);
        }
        return arrayList;
    }

    @JsonIgnore
    public Map<HttpMethod, Operation> getOperationMap() {
        LinkedHashMap<HttpMethod, Operation> linkedHashMap = new LinkedHashMap<HttpMethod, Operation>();
        if (this.get != null) {
            linkedHashMap.put(HttpMethod.GET, this.get);
        }
        if (this.put != null) {
            linkedHashMap.put(HttpMethod.PUT, this.put);
        }
        if (this.post != null) {
            linkedHashMap.put(HttpMethod.POST, this.post);
        }
        if (this.delete != null) {
            linkedHashMap.put(HttpMethod.DELETE, this.delete);
        }
        if (this.patch != null) {
            linkedHashMap.put(HttpMethod.PATCH, this.patch);
        }
        if (this.head != null) {
            linkedHashMap.put(HttpMethod.HEAD, this.head);
        }
        if (this.options != null) {
            linkedHashMap.put(HttpMethod.OPTIONS, this.options);
        }
        return linkedHashMap;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> list) {
        this.parameters = list;
    }

    public void addParameter(Parameter parameter) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<Parameter>();
        }
        this.parameters.add(parameter);
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.get == null && this.put == null && this.head == null && this.post == null && this.delete == null && this.patch == null && this.options == null;
    }

    @JsonAnyGetter
    public Map<String, Object> getVendorExtensions() {
        return this.vendorExtensions;
    }

    @JsonAnySetter
    public void setVendorExtension(String string, Object object) {
        if (string.startsWith("x-")) {
            this.vendorExtensions.put(string, object);
        }
    }

    public void setVendorExtensions(Map<String, Object> map) {
        this.vendorExtensions = map;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.delete == null ? 0 : this.delete.hashCode());
        n3 = 31 * n3 + (this.get == null ? 0 : this.get.hashCode());
        n3 = 31 * n3 + (this.head == null ? 0 : this.head.hashCode());
        n3 = 31 * n3 + (this.options == null ? 0 : this.options.hashCode());
        n3 = 31 * n3 + (this.parameters == null ? 0 : this.parameters.hashCode());
        n3 = 31 * n3 + (this.patch == null ? 0 : this.patch.hashCode());
        n3 = 31 * n3 + (this.post == null ? 0 : this.post.hashCode());
        n3 = 31 * n3 + (this.put == null ? 0 : this.put.hashCode());
        n3 = 31 * n3 + (this.vendorExtensions == null ? 0 : this.vendorExtensions.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Path path = (Path)object;
        if (this.delete == null ? path.delete != null : !this.delete.equals(path.delete)) {
            return false;
        }
        if (this.get == null ? path.get != null : !this.get.equals(path.get)) {
            return false;
        }
        if (this.head == null ? path.head != null : !this.head.equals(path.head)) {
            return false;
        }
        if (this.options == null ? path.options != null : !this.options.equals(path.options)) {
            return false;
        }
        if (this.parameters == null ? path.parameters != null : !this.parameters.equals(path.parameters)) {
            return false;
        }
        if (this.patch == null ? path.patch != null : !this.patch.equals(path.patch)) {
            return false;
        }
        if (this.post == null ? path.post != null : !this.post.equals(path.post)) {
            return false;
        }
        if (this.put == null ? path.put != null : !this.put.equals(path.put)) {
            return false;
        }
        return !(this.vendorExtensions == null ? path.vendorExtensions != null : !this.vendorExtensions.equals(path.vendorExtensions));
    }
}

