/*
 * Decompiled with CFR 0.152.
 */
package io.github.manusant.ss.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.github.manusant.ss.model.ExternalDocs;
import io.github.manusant.ss.model.Response;
import io.github.manusant.ss.model.Scheme;
import io.github.manusant.ss.model.SecurityRequirement;
import io.github.manusant.ss.model.parameters.Parameter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Operation {
    private Map<String, Object> vendorExtensions = new LinkedHashMap<String, Object>();
    private List<String> tags;
    private String summary;
    private String description;
    private String operationId;
    private List<Scheme> schemes;
    private List<String> consumes;
    private List<String> produces;
    private List<Parameter> parameters = new ArrayList<Parameter>();
    private Map<String, Response> responses;
    private List<Map<String, List<String>>> security;
    private ExternalDocs externalDocs;
    private Boolean deprecated;

    public Operation summary(String string) {
        this.setSummary(string);
        return this;
    }

    public Operation description(String string) {
        this.setDescription(string);
        return this;
    }

    public Operation operationId(String string) {
        this.setOperationId(string);
        return this;
    }

    public Operation schemes(List<Scheme> list) {
        this.setSchemes(list);
        return this;
    }

    public Operation scheme(Scheme scheme) {
        this.addScheme(scheme);
        return this;
    }

    public Operation consumes(List<String> list) {
        this.setConsumes(list);
        return this;
    }

    public Operation consumes(String string) {
        this.addConsumes(string);
        return this;
    }

    public Operation produces(List<String> list) {
        this.setProduces(list);
        return this;
    }

    public Operation produces(String string) {
        this.addProduces(string);
        return this;
    }

    public Operation security(SecurityRequirement securityRequirement) {
        this.addSecurity(securityRequirement.getName(), securityRequirement.getScopes());
        return this;
    }

    public Operation parameter(Parameter parameter) {
        this.addParameter(parameter);
        return this;
    }

    public Operation response(int n2, Response response) {
        this.addResponse(String.valueOf(n2), response);
        return this;
    }

    public Operation defaultResponse(Response response) {
        this.addResponse("default", response);
        return this;
    }

    public Operation tags(List<String> list) {
        this.setTags(list);
        return this;
    }

    public Operation tag(String string) {
        this.addTag(string);
        return this;
    }

    public Operation externalDocs(ExternalDocs externalDocs) {
        this.setExternalDocs(externalDocs);
        return this;
    }

    public Operation deprecated(Boolean bl) {
        this.setDeprecated(bl);
        return this;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> list) {
        this.tags = list;
    }

    public void addTag(String string) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(string);
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String string) {
        this.summary = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public void setOperationId(String string) {
        this.operationId = string;
    }

    public List<Scheme> getSchemes() {
        return this.schemes;
    }

    public void setSchemes(List<Scheme> list) {
        this.schemes = list;
    }

    public void addScheme(Scheme scheme) {
        if (this.schemes == null) {
            this.schemes = new ArrayList<Scheme>();
        }
        if (!this.schemes.contains((Object)scheme)) {
            this.schemes.add(scheme);
        }
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public void setConsumes(List<String> list) {
        this.consumes = list;
    }

    public void addConsumes(String string) {
        if (this.consumes == null) {
            this.consumes = new ArrayList<String>();
        }
        this.consumes.add(string);
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public void setProduces(List<String> list) {
        this.produces = list;
    }

    public void addProduces(String string) {
        if (this.produces == null) {
            this.produces = new ArrayList<String>();
        }
        this.produces.add(string);
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> list) {
        this.parameters = list;
    }

    public void addParameter(Parameter parameter) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<Parameter>();
        }
        this.parameters.add(parameter);
    }

    public Map<String, Response> getResponses() {
        return this.responses;
    }

    public void setResponses(Map<String, Response> map) {
        this.responses = map;
    }

    public void addResponse(String string, Response response) {
        if (this.responses == null) {
            this.responses = new LinkedHashMap<String, Response>();
        }
        this.responses.put(string, response);
    }

    public List<Map<String, List<String>>> getSecurity() {
        return this.security;
    }

    public void setSecurity(List<Map<String, List<String>>> list) {
        this.security = list;
    }

    public void addSecurity(String string, List<String> list) {
        if (this.security == null) {
            this.security = new ArrayList<Map<String, List<String>>>();
        }
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        if (list == null) {
            list = new ArrayList<String>();
        }
        linkedHashMap.put(string, list);
        this.security.add(linkedHashMap);
    }

    public ExternalDocs getExternalDocs() {
        return this.externalDocs;
    }

    public void setExternalDocs(ExternalDocs externalDocs) {
        this.externalDocs = externalDocs;
    }

    public Boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(Boolean bl) {
        this.deprecated = bl == null || bl.equals(Boolean.FALSE) ? null : bl;
    }

    @JsonAnyGetter
    public Map<String, Object> getVendorExtensions() {
        return this.vendorExtensions;
    }

    @JsonAnySetter
    public void setVendorExtension(String string, Object object) {
        if (string.startsWith("x-")) {
            this.vendorExtensions.put(string, object);
        }
    }

    public void setVendorExtensions(Map<String, Object> map) {
        this.vendorExtensions = map;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.consumes == null ? 0 : this.consumes.hashCode());
        n3 = 31 * n3 + (this.deprecated == null ? 0 : this.deprecated.hashCode());
        n3 = 31 * n3 + (this.description == null ? 0 : this.description.hashCode());
        n3 = 31 * n3 + (this.externalDocs == null ? 0 : this.externalDocs.hashCode());
        n3 = 31 * n3 + (this.operationId == null ? 0 : this.operationId.hashCode());
        n3 = 31 * n3 + (this.parameters == null ? 0 : this.parameters.hashCode());
        n3 = 31 * n3 + (this.produces == null ? 0 : this.produces.hashCode());
        n3 = 31 * n3 + (this.responses == null ? 0 : this.responses.hashCode());
        n3 = 31 * n3 + (this.schemes == null ? 0 : this.schemes.hashCode());
        n3 = 31 * n3 + (this.security == null ? 0 : this.security.hashCode());
        n3 = 31 * n3 + (this.summary == null ? 0 : this.summary.hashCode());
        n3 = 31 * n3 + (this.tags == null ? 0 : this.tags.hashCode());
        n3 = 31 * n3 + (this.vendorExtensions == null ? 0 : this.vendorExtensions.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Operation operation = (Operation)object;
        if (this.consumes == null ? operation.consumes != null : !this.consumes.equals(operation.consumes)) {
            return false;
        }
        if (this.deprecated == null ? operation.deprecated != null : !this.deprecated.equals(operation.deprecated)) {
            return false;
        }
        if (this.description == null ? operation.description != null : !this.description.equals(operation.description)) {
            return false;
        }
        if (this.externalDocs == null ? operation.externalDocs != null : !this.externalDocs.equals(operation.externalDocs)) {
            return false;
        }
        if (this.operationId == null ? operation.operationId != null : !this.operationId.equals(operation.operationId)) {
            return false;
        }
        if (this.parameters == null ? operation.parameters != null : !this.parameters.equals(operation.parameters)) {
            return false;
        }
        if (this.produces == null ? operation.produces != null : !this.produces.equals(operation.produces)) {
            return false;
        }
        if (this.responses == null ? operation.responses != null : !this.responses.equals(operation.responses)) {
            return false;
        }
        if (this.schemes == null ? operation.schemes != null : !this.schemes.equals(operation.schemes)) {
            return false;
        }
        if (this.security == null ? operation.security != null : !this.security.equals(operation.security)) {
            return false;
        }
        if (this.summary == null ? operation.summary != null : !this.summary.equals(operation.summary)) {
            return false;
        }
        if (this.tags == null ? operation.tags != null : !this.tags.equals(operation.tags)) {
            return false;
        }
        return !(this.vendorExtensions == null ? operation.vendorExtensions != null : !this.vendorExtensions.equals(operation.vendorExtensions));
    }

    public Operation vendorExtensions(Map<String, Object> map) {
        this.vendorExtensions.putAll(map);
        return this;
    }

    public String toString() {
        return super.toString() + "[" + this.operationId + "]";
    }
}

