/*
 * Decompiled with CFR 0.152.
 */
package io.github.manusant.ss.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.github.manusant.ss.model.AbstractModel;
import io.github.manusant.ss.model.Xml;
import io.github.manusant.ss.model.properties.Property;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "required", "discriminator", "properties"})
public class ModelImpl
extends AbstractModel {
    public static final String OBJECT = "object";
    private String type;
    private String format;
    private String name;
    private List<String> required;
    private Map<String, Property> properties;
    private Boolean allowEmptyValue;
    private Boolean uniqueItems;
    private boolean isSimple = false;
    private String description;
    private Object example;
    private Property additionalProperties;
    private String discriminator;
    @JsonProperty(value="default")
    private String defaultValue;
    private List<String> _enum;
    private BigDecimal minimum;
    private BigDecimal maximum;

    public ModelImpl _enum(List<String> list) {
        this._enum = list;
        return this;
    }

    public ModelImpl _enum(String string) {
        if (this._enum == null) {
            this._enum = new ArrayList<String>();
        }
        this._enum.add(string);
        return this;
    }

    public List<String> getEnum() {
        return this._enum;
    }

    public void setEnum(List<String> list) {
        this._enum = list;
    }

    public ModelImpl discriminator(String string) {
        this.setDiscriminator(string);
        return this;
    }

    public ModelImpl type(String string) {
        this.setType(string);
        return this;
    }

    public ModelImpl format(String string) {
        this.setFormat(string);
        return this;
    }

    public ModelImpl name(String string) {
        this.setName(string);
        return this;
    }

    public ModelImpl uniqueItems(Boolean bl) {
        this.setUniqueItems(bl);
        return this;
    }

    public ModelImpl allowEmptyValue(Boolean bl) {
        this.setAllowEmptyValue(bl);
        return this;
    }

    public ModelImpl description(String string) {
        this.setDescription(string);
        return this;
    }

    public ModelImpl property(String string, Property property) {
        this.addProperty(string, property);
        return this;
    }

    public ModelImpl example(Object object) {
        this.setExample(object);
        return this;
    }

    public ModelImpl additionalProperties(Property property) {
        this.setAdditionalProperties(property);
        return this;
    }

    public ModelImpl required(String string) {
        this.addRequired(string);
        return this;
    }

    public ModelImpl xml(Xml xml) {
        this.setXml(xml);
        return this;
    }

    public ModelImpl minimum(BigDecimal bigDecimal) {
        this.minimum = bigDecimal;
        return this;
    }

    public ModelImpl maximum(BigDecimal bigDecimal) {
        this.maximum = bigDecimal;
        return this;
    }

    public String getDiscriminator() {
        return this.discriminator;
    }

    public void setDiscriminator(String string) {
        this.discriminator = string;
    }

    @JsonIgnore
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String string) {
        this.description = string;
    }

    @JsonIgnore
    public boolean isSimple() {
        return this.isSimple;
    }

    public void setSimple(boolean bl) {
        this.isSimple = bl;
    }

    public Property getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAdditionalProperties(Property property) {
        this.type(OBJECT);
        this.additionalProperties = property;
    }

    public Boolean getAllowEmptyValue() {
        return this.allowEmptyValue;
    }

    public void setAllowEmptyValue(Boolean bl) {
        if (bl != null) {
            this.allowEmptyValue = bl;
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String string) {
        this.format = string;
    }

    public void addRequired(String string) {
        if (this.required == null) {
            this.required = new ArrayList<String>();
        }
        this.required.add(string);
        Property property = this.properties.get(string);
        if (property != null) {
            property.setRequired(true);
        }
    }

    public List<String> getRequired() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.properties != null) {
            for (String string : this.properties.keySet()) {
                Property property = this.properties.get(string);
                if (property == null || !property.getRequired()) continue;
                arrayList.add(string);
            }
        }
        Collections.sort(arrayList);
        if (arrayList.size() > 0) {
            return arrayList;
        }
        return null;
    }

    public void setRequired(List<String> list) {
        this.required = list;
        if (list != null && this.properties != null) {
            for (String string : list) {
                Property property = this.properties.get(string);
                if (property == null) continue;
                property.setRequired(true);
            }
        }
    }

    public void addProperty(String string, Property property) {
        if (property == null) {
            return;
        }
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, Property>();
        }
        if (this.required != null) {
            for (String string2 : this.required) {
                if (!string.equals(string2)) continue;
                property.setRequired(true);
            }
        }
        this.properties.put(string, property);
    }

    @Override
    public Map<String, Property> getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Map<String, Property> map) {
        if (map != null) {
            for (String string : map.keySet()) {
                this.addProperty(string, map.get(string));
            }
        }
    }

    @Override
    public Object getExample() {
        if (this.example == null) {
            // empty if block
        }
        return this.example;
    }

    @Override
    public void setExample(Object object) {
        this.example = object;
    }

    public Object getDefaultValue() {
        if (this.defaultValue == null) {
            return null;
        }
        try {
            if ("integer".equals(this.type)) {
                return new Integer(this.defaultValue);
            }
            if ("number".equals(this.type)) {
                return new BigDecimal(this.defaultValue);
            }
        }
        catch (Exception exception) {
            return null;
        }
        return this.defaultValue;
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    public BigDecimal getMinimum() {
        return this.minimum;
    }

    public void setMinimum(BigDecimal bigDecimal) {
        this.minimum = bigDecimal;
    }

    public BigDecimal getMaximum() {
        return this.maximum;
    }

    public void setMaximum(BigDecimal bigDecimal) {
        this.maximum = bigDecimal;
    }

    public Boolean getUniqueItems() {
        return this.uniqueItems;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ModelImpl)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        ModelImpl modelImpl = (ModelImpl)object;
        if (this.isSimple != modelImpl.isSimple) {
            return false;
        }
        if (this.type != null ? !this.type.equals(modelImpl.type) : modelImpl.type != null) {
            return false;
        }
        if (this.format != null ? !this.format.equals(modelImpl.format) : modelImpl.format != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(modelImpl.name) : modelImpl.name != null) {
            return false;
        }
        if (this.required != null ? !this.required.equals(modelImpl.required) : modelImpl.required != null) {
            return false;
        }
        if (this.properties != null ? !this.properties.equals(modelImpl.properties) : modelImpl.properties != null) {
            return false;
        }
        if (this.allowEmptyValue != null ? !this.allowEmptyValue.equals(modelImpl.allowEmptyValue) : modelImpl.allowEmptyValue != null) {
            return false;
        }
        if (this.uniqueItems != null ? !this.uniqueItems.equals(modelImpl.uniqueItems) : modelImpl.uniqueItems != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(modelImpl.description) : modelImpl.description != null) {
            return false;
        }
        if (this.example != null ? !this.example.equals(modelImpl.example) : modelImpl.example != null) {
            return false;
        }
        if (this.additionalProperties != null ? !this.additionalProperties.equals(modelImpl.additionalProperties) : modelImpl.additionalProperties != null) {
            return false;
        }
        if (this.discriminator != null ? !this.discriminator.equals(modelImpl.discriminator) : modelImpl.discriminator != null) {
            return false;
        }
        if (this.defaultValue != null ? !this.defaultValue.equals(modelImpl.defaultValue) : modelImpl.defaultValue != null) {
            return false;
        }
        if (this._enum != null ? !this._enum.equals(modelImpl._enum) : modelImpl._enum != null) {
            return false;
        }
        if (this.minimum != null ? !this.minimum.equals(modelImpl.minimum) : modelImpl.minimum != null) {
            return false;
        }
        return this.maximum != null ? this.maximum.equals(modelImpl.maximum) : modelImpl.maximum == null;
    }

    @Override
    public int hashCode() {
        int n2 = super.hashCode();
        n2 = 31 * n2 + (this.type != null ? this.type.hashCode() : 0);
        n2 = 31 * n2 + (this.format != null ? this.format.hashCode() : 0);
        n2 = 31 * n2 + (this.name != null ? this.name.hashCode() : 0);
        n2 = 31 * n2 + (this.required != null ? this.required.hashCode() : 0);
        n2 = 31 * n2 + (this.properties != null ? this.properties.hashCode() : 0);
        n2 = 31 * n2 + (this.allowEmptyValue != null ? this.allowEmptyValue.hashCode() : 0);
        n2 = 31 * n2 + (this.uniqueItems != null ? this.uniqueItems.hashCode() : 0);
        n2 = 31 * n2 + (this.isSimple ? 1 : 0);
        n2 = 31 * n2 + (this.description != null ? this.description.hashCode() : 0);
        n2 = 31 * n2 + (this.example != null ? this.example.hashCode() : 0);
        n2 = 31 * n2 + (this.additionalProperties != null ? this.additionalProperties.hashCode() : 0);
        n2 = 31 * n2 + (this.discriminator != null ? this.discriminator.hashCode() : 0);
        n2 = 31 * n2 + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
        n2 = 31 * n2 + (this._enum != null ? this._enum.hashCode() : 0);
        n2 = 31 * n2 + (this.minimum != null ? this.minimum.hashCode() : 0);
        n2 = 31 * n2 + (this.maximum != null ? this.maximum.hashCode() : 0);
        return n2;
    }

    public void setUniqueItems(Boolean bl) {
        this.uniqueItems = bl;
    }

    @Override
    public Object clone() {
        ModelImpl modelImpl = new ModelImpl();
        super.cloneTo(modelImpl);
        modelImpl.type = this.type;
        modelImpl.name = this.name;
        modelImpl.required = this.required;
        if (this.properties != null) {
            modelImpl.properties = new LinkedHashMap<String, Property>(this.properties);
        }
        modelImpl.isSimple = this.isSimple;
        modelImpl.description = this.description;
        modelImpl.example = this.example;
        modelImpl.additionalProperties = this.additionalProperties;
        modelImpl.discriminator = this.discriminator;
        modelImpl.defaultValue = this.defaultValue;
        modelImpl.minimum = this.minimum;
        modelImpl.maximum = this.maximum;
        return modelImpl;
    }
}

