/*
 * Decompiled with CFR 0.152.
 */
package io.github.manusant.ss.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.github.manusant.ss.model.AbstractModel;
import io.github.manusant.ss.model.Model;
import io.github.manusant.ss.model.RefModel;
import io.github.manusant.ss.model.properties.Property;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ComposedModel
extends AbstractModel {
    private List<Model> allOf = new ArrayList<Model>();
    private Model parent;
    private Model child;
    private List<RefModel> interfaces;
    private String description;
    private Object example;

    public ComposedModel parent(Model model) {
        this.setParent(model);
        return this;
    }

    public ComposedModel child(Model model) {
        this.setChild(model);
        return this;
    }

    public ComposedModel interfaces(List<RefModel> list) {
        this.setInterfaces(list);
        return this;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String string) {
        this.description = string;
    }

    @Override
    public Map<String, Property> getProperties() {
        return null;
    }

    @Override
    public void setProperties(Map<String, Property> map) {
    }

    @Override
    public Object getExample() {
        return this.example;
    }

    @Override
    public void setExample(Object object) {
        this.example = object;
    }

    public List<Model> getAllOf() {
        return this.allOf;
    }

    public void setAllOf(List<Model> list) {
        this.allOf = list;
    }

    public Model getParent() {
        return this.parent;
    }

    @JsonIgnore
    public void setParent(Model model) {
        this.parent = model;
        if (!this.allOf.contains(model)) {
            this.allOf.add(model);
        }
    }

    public Model getChild() {
        return this.child;
    }

    @JsonIgnore
    public void setChild(Model model) {
        this.child = model;
        if (!this.allOf.contains(model)) {
            this.allOf.add(model);
        }
    }

    public List<RefModel> getInterfaces() {
        return this.interfaces;
    }

    @JsonIgnore
    public void setInterfaces(List<RefModel> list) {
        this.interfaces = list;
        if (list != null) {
            for (RefModel refModel : list) {
                if (this.allOf.contains(refModel)) continue;
                this.allOf.add(refModel);
            }
        }
    }

    @Override
    public Object clone() {
        ComposedModel composedModel = new ComposedModel();
        super.cloneTo(composedModel);
        composedModel.allOf = this.allOf;
        composedModel.parent = this.parent;
        composedModel.child = this.child;
        composedModel.interfaces = this.interfaces;
        composedModel.description = this.description;
        composedModel.example = this.example;
        return composedModel;
    }

    @Override
    public int hashCode() {
        int n2 = 31;
        int n3 = super.hashCode();
        n3 = 31 * n3 + (this.allOf == null ? 0 : this.allOf.hashCode());
        n3 = 31 * n3 + (this.child == null ? 0 : this.child.hashCode());
        n3 = 31 * n3 + (this.description == null ? 0 : this.description.hashCode());
        n3 = 31 * n3 + (this.example == null ? 0 : this.example.hashCode());
        n3 = 31 * n3 + (this.interfaces == null ? 0 : this.interfaces.hashCode());
        n3 = 31 * n3 + (this.parent == null ? 0 : this.parent.hashCode());
        return n3;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ComposedModel composedModel = (ComposedModel)object;
        if (this.allOf == null ? composedModel.allOf != null : !this.allOf.equals(composedModel.allOf)) {
            return false;
        }
        if (this.child == null ? composedModel.child != null : !this.child.equals(composedModel.child)) {
            return false;
        }
        if (this.description == null ? composedModel.description != null : !this.description.equals(composedModel.description)) {
            return false;
        }
        if (this.example == null ? composedModel.example != null : !this.example.equals(composedModel.example)) {
            return false;
        }
        if (this.interfaces == null ? composedModel.interfaces != null : !this.interfaces.equals(composedModel.interfaces)) {
            return false;
        }
        return !(this.parent == null ? composedModel.parent != null : !this.parent.equals(composedModel.parent));
    }
}

