/*
 * Decompiled with CFR 0.152.
 */
package io.github.manusant.ss.factory;

import io.github.manusant.ss.descriptor.ParameterDescriptor;
import io.github.manusant.ss.model.parameters.AbstractSerializableParameter;
import io.github.manusant.ss.model.parameters.CookieParameter;
import io.github.manusant.ss.model.parameters.FormParameter;
import io.github.manusant.ss.model.parameters.HeaderParameter;
import io.github.manusant.ss.model.parameters.Parameter;
import io.github.manusant.ss.model.parameters.PathParameter;
import io.github.manusant.ss.model.parameters.QueryParameter;
import io.github.manusant.ss.model.properties.ArrayProperty;
import io.github.manusant.ss.model.properties.BooleanProperty;
import io.github.manusant.ss.model.properties.ByteArrayProperty;
import io.github.manusant.ss.model.properties.DecimalProperty;
import io.github.manusant.ss.model.properties.DoubleProperty;
import io.github.manusant.ss.model.properties.FloatProperty;
import io.github.manusant.ss.model.properties.IntegerProperty;
import io.github.manusant.ss.model.properties.LongProperty;
import io.github.manusant.ss.model.properties.Property;
import io.github.manusant.ss.model.properties.StringProperty;
import io.github.manusant.ss.model.properties.UUIDProperty;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import spark.utils.SparkUtils;

public class ParamsFactory {
    public static List<Parameter> create(String string, List<ParameterDescriptor> list) {
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        List<Parameter> list2 = ParamsFactory.createPathParams(string, list);
        arrayList.addAll(list2);
        List<Parameter> list3 = ParamsFactory.createQueryParams(list);
        arrayList.addAll(list3);
        List<Parameter> list4 = ParamsFactory.createHeaderParams(list);
        arrayList.addAll(list4);
        List<Parameter> list5 = ParamsFactory.createFormParams(list);
        arrayList.addAll(list5);
        List<Parameter> list6 = ParamsFactory.createCookieParams(list);
        arrayList.addAll(list6);
        return arrayList;
    }

    private static List<Parameter> createPathParams(String string, List<ParameterDescriptor> list) {
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        for (String string2 : SparkUtils.convertRouteToList((String)string)) {
            if (!SparkUtils.isParam((String)string2)) continue;
            try {
                Optional optional;
                String string3 = URLDecoder.decode(string2, "UTF-8");
                String string4 = string3.contains(":") ? string3.substring(string3.indexOf(":") + 1) : string3;
                Optional<Object> optional2 = optional = list != null ? list.stream().filter(parameterDescriptor -> parameterDescriptor.getName().equals(string4)).findFirst() : Optional.empty();
                if (optional.isPresent()) {
                    ParameterDescriptor parameterDescriptor2 = (ParameterDescriptor)optional.get();
                    if (parameterDescriptor2.getType() != ParameterDescriptor.ParameterType.PATH) continue;
                    arrayList.add(ParamsFactory.toPath(parameterDescriptor2));
                    continue;
                }
                arrayList.add(ParamsFactory.toGeneric(string4));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
        return arrayList;
    }

    private static List<Parameter> createQueryParams(List<ParameterDescriptor> list) {
        return ParamsFactory.filter(list, ParameterDescriptor.ParameterType.QUERY).stream().map(ParamsFactory::toQuery).collect(Collectors.toList());
    }

    private static List<Parameter> createHeaderParams(List<ParameterDescriptor> list) {
        return ParamsFactory.filter(list, ParameterDescriptor.ParameterType.HEADER).stream().map(ParamsFactory::toHeader).collect(Collectors.toList());
    }

    private static List<Parameter> createFormParams(List<ParameterDescriptor> list) {
        return ParamsFactory.filter(list, ParameterDescriptor.ParameterType.FORM).stream().map(ParamsFactory::toForm).collect(Collectors.toList());
    }

    private static List<Parameter> createCookieParams(List<ParameterDescriptor> list) {
        return ParamsFactory.filter(list, ParameterDescriptor.ParameterType.COOKIE).stream().map(ParamsFactory::toCookie).collect(Collectors.toList());
    }

    public static String formatPath(String string) {
        if (ParamsFactory.containsParam(string)) {
            StringBuilder stringBuilder = new StringBuilder();
            List list = SparkUtils.convertRouteToList((String)string);
            for (String string2 : list) {
                try {
                    stringBuilder.append("/");
                    if (SparkUtils.isParam((String)string2)) {
                        String string3 = URLDecoder.decode(string2, "UTF-8");
                        String string4 = string3.contains(":") ? string3.substring(string3.indexOf(":") + 1) : string3;
                        stringBuilder.append("{").append(string4).append("}");
                        continue;
                    }
                    stringBuilder.append(string2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                }
            }
            String string5 = stringBuilder.toString();
            return string5.isEmpty() ? "/" : string5;
        }
        return string;
    }

    public static boolean containsParam(String string) {
        return string.contains(":");
    }

    private static PathParameter toGeneric(String string) {
        PathParameter pathParameter = new PathParameter();
        pathParameter.setName(string);
        pathParameter.setRequired(true);
        pathParameter.setProperty(ParamsFactory.createProperty(String.class));
        return pathParameter;
    }

    private static PathParameter toPath(ParameterDescriptor parameterDescriptor) {
        PathParameter pathParameter = new PathParameter();
        ParamsFactory.bindAttributes(parameterDescriptor, pathParameter);
        pathParameter.setRequired(true);
        return pathParameter;
    }

    private static QueryParameter toQuery(ParameterDescriptor parameterDescriptor) {
        QueryParameter queryParameter = new QueryParameter();
        ParamsFactory.bindAttributes(parameterDescriptor, queryParameter);
        return queryParameter;
    }

    private static HeaderParameter toHeader(ParameterDescriptor parameterDescriptor) {
        HeaderParameter headerParameter = new HeaderParameter();
        ParamsFactory.bindAttributes(parameterDescriptor, headerParameter);
        return headerParameter;
    }

    private static FormParameter toForm(ParameterDescriptor parameterDescriptor) {
        FormParameter formParameter = new FormParameter();
        ParamsFactory.bindAttributes(parameterDescriptor, formParameter);
        return formParameter;
    }

    private static CookieParameter toCookie(ParameterDescriptor parameterDescriptor) {
        CookieParameter cookieParameter = new CookieParameter();
        ParamsFactory.bindAttributes(parameterDescriptor, cookieParameter);
        return cookieParameter;
    }

    private static void bindAttributes(ParameterDescriptor parameterDescriptor, AbstractSerializableParameter abstractSerializableParameter) {
        abstractSerializableParameter.setName(parameterDescriptor.getName());
        abstractSerializableParameter.setDescription(parameterDescriptor.getDescription());
        abstractSerializableParameter.setPattern(parameterDescriptor.getPattern());
        abstractSerializableParameter.setRequired(parameterDescriptor.isRequired());
        abstractSerializableParameter.setExample(parameterDescriptor.getExample());
        abstractSerializableParameter.setAllowEmptyValue(parameterDescriptor.getAllowEmptyValue());
        abstractSerializableParameter.setDefaultValue(parameterDescriptor.getDefaultValue());
        if (parameterDescriptor.getObject() != null) {
            abstractSerializableParameter.setProperty(ParamsFactory.createProperty(parameterDescriptor.getObject()));
        } else if (parameterDescriptor.getCollectionOf() != null) {
            Property property = ParamsFactory.createProperty(parameterDescriptor.getCollectionOf());
            ArrayProperty arrayProperty = new ArrayProperty();
            arrayProperty.setItems(property);
            abstractSerializableParameter.setProperty(arrayProperty);
        } else {
            abstractSerializableParameter.setProperty(ParamsFactory.createProperty(String.class));
        }
    }

    private static Property createProperty(Class clazz) {
        if (clazz.isEnum()) {
            StringProperty stringProperty = new StringProperty();
            stringProperty._enum(Stream.of(clazz.getEnumConstants()).map(object -> ((Enum)object).name()).collect(Collectors.toList()));
            return stringProperty;
        }
        if (clazz.equals(Boolean.TYPE) || clazz.equals(Boolean.class)) {
            return new BooleanProperty();
        }
        if (clazz == byte[].class) {
            return new ByteArrayProperty();
        }
        if (clazz.equals(Number.class)) {
            return new DecimalProperty();
        }
        if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            return new DoubleProperty();
        }
        if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
            return new FloatProperty();
        }
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            return new IntegerProperty();
        }
        if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            return new LongProperty();
        }
        if (clazz.equals(String.class)) {
            return new StringProperty();
        }
        if (clazz.equals(UUID.class)) {
            return new UUIDProperty();
        }
        throw new UnsupportedOperationException("Only 'String' or 'primitive' types can be used as parameters");
    }

    private static List<ParameterDescriptor> filter(List<ParameterDescriptor> list, ParameterDescriptor.ParameterType parameterType) {
        return list.stream().filter(parameterDescriptor -> parameterDescriptor.getType() == parameterType).collect(Collectors.toList());
    }
}

